package io.apicurio.registry.operator.api.v1.model.apicurioregistryspec.deployment.podtemplatespecpreview.spec.volumes;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class FcBuilder extends FcFluent<FcBuilder> implements VisitableBuilder<Fc,FcBuilder>{
  public FcBuilder() {
    this(false);
  }
  public FcBuilder(Boolean validationEnabled) {
    this(new Fc(), validationEnabled);
  }
  public FcBuilder(FcFluent<?> fluent) {
    this(fluent, false);
  }
  public FcBuilder(FcFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Fc(), validationEnabled);
  }
  public FcBuilder(FcFluent<?> fluent,Fc instance) {
    this(fluent, instance, false);
  }
  public FcBuilder(FcFluent<?> fluent,Fc instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new Fc());

    if (instance != null) {
      fluent.withFsType(instance.getFsType());
      fluent.withLun(instance.getLun());
      fluent.withReadOnly(instance.getReadOnly());
      fluent.withTargetWWNs(instance.getTargetWWNs());
      fluent.withWwids(instance.getWwids());
    }
    this.validationEnabled = validationEnabled; 
  }
  public FcBuilder(Fc instance) {
    this(instance,false);
  }
  public FcBuilder(Fc instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new Fc());

    if (instance != null) {
      this.withFsType(instance.getFsType());
      this.withLun(instance.getLun());
      this.withReadOnly(instance.getReadOnly());
      this.withTargetWWNs(instance.getTargetWWNs());
      this.withWwids(instance.getWwids());
    }
    this.validationEnabled = validationEnabled; 
  }
  FcFluent<?> fluent;
  Boolean validationEnabled;
  public Fc build() {
    Fc buildable = new Fc();
    buildable.setFsType(fluent.getFsType());
    buildable.setLun(fluent.getLun());
    buildable.setReadOnly(fluent.getReadOnly());
    buildable.setTargetWWNs(fluent.getTargetWWNs());
    buildable.setWwids(fluent.getWwids());
    return buildable;
  }
  
}