package io.apicurio.registry.operator.api.v1.model.apicurioregistryspec.deployment.podtemplatespecpreview.spec.volumes;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class FlexVolumeBuilder extends FlexVolumeFluent<FlexVolumeBuilder> implements VisitableBuilder<FlexVolume,FlexVolumeBuilder>{
  public FlexVolumeBuilder() {
    this(false);
  }
  public FlexVolumeBuilder(Boolean validationEnabled) {
    this(new FlexVolume(), validationEnabled);
  }
  public FlexVolumeBuilder(FlexVolumeFluent<?> fluent) {
    this(fluent, false);
  }
  public FlexVolumeBuilder(FlexVolumeFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new FlexVolume(), validationEnabled);
  }
  public FlexVolumeBuilder(FlexVolumeFluent<?> fluent,FlexVolume instance) {
    this(fluent, instance, false);
  }
  public FlexVolumeBuilder(FlexVolumeFluent<?> fluent,FlexVolume instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new FlexVolume());

    if (instance != null) {
      fluent.withDriver(instance.getDriver());
      fluent.withFsType(instance.getFsType());
      fluent.withOptions(instance.getOptions());
      fluent.withReadOnly(instance.getReadOnly());
      fluent.withSecretRef(instance.getSecretRef());
    }
    this.validationEnabled = validationEnabled; 
  }
  public FlexVolumeBuilder(FlexVolume instance) {
    this(instance,false);
  }
  public FlexVolumeBuilder(FlexVolume instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new FlexVolume());

    if (instance != null) {
      this.withDriver(instance.getDriver());
      this.withFsType(instance.getFsType());
      this.withOptions(instance.getOptions());
      this.withReadOnly(instance.getReadOnly());
      this.withSecretRef(instance.getSecretRef());
    }
    this.validationEnabled = validationEnabled; 
  }
  FlexVolumeFluent<?> fluent;
  Boolean validationEnabled;
  public FlexVolume build() {
    FlexVolume buildable = new FlexVolume();
    buildable.setDriver(fluent.getDriver());
    buildable.setFsType(fluent.getFsType());
    buildable.setOptions(fluent.getOptions());
    buildable.setReadOnly(fluent.getReadOnly());
    buildable.setSecretRef(fluent.buildSecretRef());
    return buildable;
  }
  
}