package io.apicurio.registry.operator.api.v1.model.apicurioregistryspec.deployment.podtemplatespecpreview.spec.volumes;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class FlockerBuilder extends FlockerFluent<FlockerBuilder> implements VisitableBuilder<Flocker,FlockerBuilder>{
  public FlockerBuilder() {
    this(false);
  }
  public FlockerBuilder(Boolean validationEnabled) {
    this(new Flocker(), validationEnabled);
  }
  public FlockerBuilder(FlockerFluent<?> fluent) {
    this(fluent, false);
  }
  public FlockerBuilder(FlockerFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Flocker(), validationEnabled);
  }
  public FlockerBuilder(FlockerFluent<?> fluent,Flocker instance) {
    this(fluent, instance, false);
  }
  public FlockerBuilder(FlockerFluent<?> fluent,Flocker instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new Flocker());

    if (instance != null) {
      fluent.withDatasetName(instance.getDatasetName());
      fluent.withDatasetUUID(instance.getDatasetUUID());
    }
    this.validationEnabled = validationEnabled; 
  }
  public FlockerBuilder(Flocker instance) {
    this(instance,false);
  }
  public FlockerBuilder(Flocker instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new Flocker());

    if (instance != null) {
      this.withDatasetName(instance.getDatasetName());
      this.withDatasetUUID(instance.getDatasetUUID());
    }
    this.validationEnabled = validationEnabled; 
  }
  FlockerFluent<?> fluent;
  Boolean validationEnabled;
  public Flocker build() {
    Flocker buildable = new Flocker();
    buildable.setDatasetName(fluent.getDatasetName());
    buildable.setDatasetUUID(fluent.getDatasetUUID());
    return buildable;
  }
  
}