package io.apicurio.registry.operator.api.v1.model.apicurioregistryspec.deployment.podtemplatespecpreview.spec.volumes;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class GcePersistentDiskBuilder extends GcePersistentDiskFluent<GcePersistentDiskBuilder> implements VisitableBuilder<GcePersistentDisk,GcePersistentDiskBuilder>{
  public GcePersistentDiskBuilder() {
    this(false);
  }
  public GcePersistentDiskBuilder(Boolean validationEnabled) {
    this(new GcePersistentDisk(), validationEnabled);
  }
  public GcePersistentDiskBuilder(GcePersistentDiskFluent<?> fluent) {
    this(fluent, false);
  }
  public GcePersistentDiskBuilder(GcePersistentDiskFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new GcePersistentDisk(), validationEnabled);
  }
  public GcePersistentDiskBuilder(GcePersistentDiskFluent<?> fluent,GcePersistentDisk instance) {
    this(fluent, instance, false);
  }
  public GcePersistentDiskBuilder(GcePersistentDiskFluent<?> fluent,GcePersistentDisk instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new GcePersistentDisk());

    if (instance != null) {
      fluent.withFsType(instance.getFsType());
      fluent.withPartition(instance.getPartition());
      fluent.withPdName(instance.getPdName());
      fluent.withReadOnly(instance.getReadOnly());
    }
    this.validationEnabled = validationEnabled; 
  }
  public GcePersistentDiskBuilder(GcePersistentDisk instance) {
    this(instance,false);
  }
  public GcePersistentDiskBuilder(GcePersistentDisk instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new GcePersistentDisk());

    if (instance != null) {
      this.withFsType(instance.getFsType());
      this.withPartition(instance.getPartition());
      this.withPdName(instance.getPdName());
      this.withReadOnly(instance.getReadOnly());
    }
    this.validationEnabled = validationEnabled; 
  }
  GcePersistentDiskFluent<?> fluent;
  Boolean validationEnabled;
  public GcePersistentDisk build() {
    GcePersistentDisk buildable = new GcePersistentDisk();
    buildable.setFsType(fluent.getFsType());
    buildable.setPartition(fluent.getPartition());
    buildable.setPdName(fluent.getPdName());
    buildable.setReadOnly(fluent.getReadOnly());
    return buildable;
  }
  
}