package io.apicurio.registry.operator.api.v1.model.apicurioregistryspec.deployment.podtemplatespecpreview.spec.volumes;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class GitRepoBuilder extends GitRepoFluent<GitRepoBuilder> implements VisitableBuilder<GitRepo,GitRepoBuilder>{
  public GitRepoBuilder() {
    this(false);
  }
  public GitRepoBuilder(Boolean validationEnabled) {
    this(new GitRepo(), validationEnabled);
  }
  public GitRepoBuilder(GitRepoFluent<?> fluent) {
    this(fluent, false);
  }
  public GitRepoBuilder(GitRepoFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new GitRepo(), validationEnabled);
  }
  public GitRepoBuilder(GitRepoFluent<?> fluent,GitRepo instance) {
    this(fluent, instance, false);
  }
  public GitRepoBuilder(GitRepoFluent<?> fluent,GitRepo instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new GitRepo());

    if (instance != null) {
      fluent.withDirectory(instance.getDirectory());
      fluent.withRepository(instance.getRepository());
      fluent.withRevision(instance.getRevision());
    }
    this.validationEnabled = validationEnabled; 
  }
  public GitRepoBuilder(GitRepo instance) {
    this(instance,false);
  }
  public GitRepoBuilder(GitRepo instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new GitRepo());

    if (instance != null) {
      this.withDirectory(instance.getDirectory());
      this.withRepository(instance.getRepository());
      this.withRevision(instance.getRevision());
    }
    this.validationEnabled = validationEnabled; 
  }
  GitRepoFluent<?> fluent;
  Boolean validationEnabled;
  public GitRepo build() {
    GitRepo buildable = new GitRepo();
    buildable.setDirectory(fluent.getDirectory());
    buildable.setRepository(fluent.getRepository());
    buildable.setRevision(fluent.getRevision());
    return buildable;
  }
  
}