package io.apicurio.registry.operator.api.v1.model.apicurioregistryspec.deployment.podtemplatespecpreview.spec.volumes;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class GlusterfsBuilder extends GlusterfsFluent<GlusterfsBuilder> implements VisitableBuilder<Glusterfs,GlusterfsBuilder>{
  public GlusterfsBuilder() {
    this(false);
  }
  public GlusterfsBuilder(Boolean validationEnabled) {
    this(new Glusterfs(), validationEnabled);
  }
  public GlusterfsBuilder(GlusterfsFluent<?> fluent) {
    this(fluent, false);
  }
  public GlusterfsBuilder(GlusterfsFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Glusterfs(), validationEnabled);
  }
  public GlusterfsBuilder(GlusterfsFluent<?> fluent,Glusterfs instance) {
    this(fluent, instance, false);
  }
  public GlusterfsBuilder(GlusterfsFluent<?> fluent,Glusterfs instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new Glusterfs());

    if (instance != null) {
      fluent.withEndpoints(instance.getEndpoints());
      fluent.withPath(instance.getPath());
      fluent.withReadOnly(instance.getReadOnly());
    }
    this.validationEnabled = validationEnabled; 
  }
  public GlusterfsBuilder(Glusterfs instance) {
    this(instance,false);
  }
  public GlusterfsBuilder(Glusterfs instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new Glusterfs());

    if (instance != null) {
      this.withEndpoints(instance.getEndpoints());
      this.withPath(instance.getPath());
      this.withReadOnly(instance.getReadOnly());
    }
    this.validationEnabled = validationEnabled; 
  }
  GlusterfsFluent<?> fluent;
  Boolean validationEnabled;
  public Glusterfs build() {
    Glusterfs buildable = new Glusterfs();
    buildable.setEndpoints(fluent.getEndpoints());
    buildable.setPath(fluent.getPath());
    buildable.setReadOnly(fluent.getReadOnly());
    return buildable;
  }
  
}