package io.apicurio.registry.operator.api.v1.model.apicurioregistryspec.deployment.podtemplatespecpreview.spec.volumes;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class HostPathBuilder extends HostPathFluent<HostPathBuilder> implements VisitableBuilder<HostPath,HostPathBuilder>{
  public HostPathBuilder() {
    this(false);
  }
  public HostPathBuilder(Boolean validationEnabled) {
    this(new HostPath(), validationEnabled);
  }
  public HostPathBuilder(HostPathFluent<?> fluent) {
    this(fluent, false);
  }
  public HostPathBuilder(HostPathFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new HostPath(), validationEnabled);
  }
  public HostPathBuilder(HostPathFluent<?> fluent,HostPath instance) {
    this(fluent, instance, false);
  }
  public HostPathBuilder(HostPathFluent<?> fluent,HostPath instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new HostPath());

    if (instance != null) {
      fluent.withPath(instance.getPath());
      fluent.withType(instance.getType());
    }
    this.validationEnabled = validationEnabled; 
  }
  public HostPathBuilder(HostPath instance) {
    this(instance,false);
  }
  public HostPathBuilder(HostPath instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new HostPath());

    if (instance != null) {
      this.withPath(instance.getPath());
      this.withType(instance.getType());
    }
    this.validationEnabled = validationEnabled; 
  }
  HostPathFluent<?> fluent;
  Boolean validationEnabled;
  public HostPath build() {
    HostPath buildable = new HostPath();
    buildable.setPath(fluent.getPath());
    buildable.setType(fluent.getType());
    return buildable;
  }
  
}