package io.apicurio.registry.operator.api.v1.model.apicurioregistryspec.deployment.podtemplatespecpreview.spec.volumes;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class IscsiBuilder extends IscsiFluent<IscsiBuilder> implements VisitableBuilder<Iscsi,IscsiBuilder>{
  public IscsiBuilder() {
    this(false);
  }
  public IscsiBuilder(Boolean validationEnabled) {
    this(new Iscsi(), validationEnabled);
  }
  public IscsiBuilder(IscsiFluent<?> fluent) {
    this(fluent, false);
  }
  public IscsiBuilder(IscsiFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Iscsi(), validationEnabled);
  }
  public IscsiBuilder(IscsiFluent<?> fluent,Iscsi instance) {
    this(fluent, instance, false);
  }
  public IscsiBuilder(IscsiFluent<?> fluent,Iscsi instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new Iscsi());

    if (instance != null) {
      fluent.withChapAuthDiscovery(instance.getChapAuthDiscovery());
      fluent.withChapAuthSession(instance.getChapAuthSession());
      fluent.withFsType(instance.getFsType());
      fluent.withInitiatorName(instance.getInitiatorName());
      fluent.withIqn(instance.getIqn());
      fluent.withIscsiInterface(instance.getIscsiInterface());
      fluent.withLun(instance.getLun());
      fluent.withPortals(instance.getPortals());
      fluent.withReadOnly(instance.getReadOnly());
      fluent.withSecretRef(instance.getSecretRef());
      fluent.withTargetPortal(instance.getTargetPortal());
    }
    this.validationEnabled = validationEnabled; 
  }
  public IscsiBuilder(Iscsi instance) {
    this(instance,false);
  }
  public IscsiBuilder(Iscsi instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new Iscsi());

    if (instance != null) {
      this.withChapAuthDiscovery(instance.getChapAuthDiscovery());
      this.withChapAuthSession(instance.getChapAuthSession());
      this.withFsType(instance.getFsType());
      this.withInitiatorName(instance.getInitiatorName());
      this.withIqn(instance.getIqn());
      this.withIscsiInterface(instance.getIscsiInterface());
      this.withLun(instance.getLun());
      this.withPortals(instance.getPortals());
      this.withReadOnly(instance.getReadOnly());
      this.withSecretRef(instance.getSecretRef());
      this.withTargetPortal(instance.getTargetPortal());
    }
    this.validationEnabled = validationEnabled; 
  }
  IscsiFluent<?> fluent;
  Boolean validationEnabled;
  public Iscsi build() {
    Iscsi buildable = new Iscsi();
    buildable.setChapAuthDiscovery(fluent.getChapAuthDiscovery());
    buildable.setChapAuthSession(fluent.getChapAuthSession());
    buildable.setFsType(fluent.getFsType());
    buildable.setInitiatorName(fluent.getInitiatorName());
    buildable.setIqn(fluent.getIqn());
    buildable.setIscsiInterface(fluent.getIscsiInterface());
    buildable.setLun(fluent.getLun());
    buildable.setPortals(fluent.getPortals());
    buildable.setReadOnly(fluent.getReadOnly());
    buildable.setSecretRef(fluent.buildSecretRef());
    buildable.setTargetPortal(fluent.getTargetPortal());
    return buildable;
  }
  
}