package io.apicurio.registry.operator.api.v1.model.apicurioregistryspec.deployment.podtemplatespecpreview.spec.volumes;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class NfsBuilder extends NfsFluent<NfsBuilder> implements VisitableBuilder<Nfs,NfsBuilder>{
  public NfsBuilder() {
    this(false);
  }
  public NfsBuilder(Boolean validationEnabled) {
    this(new Nfs(), validationEnabled);
  }
  public NfsBuilder(NfsFluent<?> fluent) {
    this(fluent, false);
  }
  public NfsBuilder(NfsFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Nfs(), validationEnabled);
  }
  public NfsBuilder(NfsFluent<?> fluent,Nfs instance) {
    this(fluent, instance, false);
  }
  public NfsBuilder(NfsFluent<?> fluent,Nfs instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new Nfs());

    if (instance != null) {
      fluent.withPath(instance.getPath());
      fluent.withReadOnly(instance.getReadOnly());
      fluent.withServer(instance.getServer());
    }
    this.validationEnabled = validationEnabled; 
  }
  public NfsBuilder(Nfs instance) {
    this(instance,false);
  }
  public NfsBuilder(Nfs instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new Nfs());

    if (instance != null) {
      this.withPath(instance.getPath());
      this.withReadOnly(instance.getReadOnly());
      this.withServer(instance.getServer());
    }
    this.validationEnabled = validationEnabled; 
  }
  NfsFluent<?> fluent;
  Boolean validationEnabled;
  public Nfs build() {
    Nfs buildable = new Nfs();
    buildable.setPath(fluent.getPath());
    buildable.setReadOnly(fluent.getReadOnly());
    buildable.setServer(fluent.getServer());
    return buildable;
  }
  
}