package io.apicurio.registry.operator.api.v1.model.apicurioregistryspec.deployment.podtemplatespecpreview.spec.volumes;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PersistentVolumeClaimBuilder extends PersistentVolumeClaimFluent<PersistentVolumeClaimBuilder> implements VisitableBuilder<PersistentVolumeClaim,PersistentVolumeClaimBuilder>{
  public PersistentVolumeClaimBuilder() {
    this(false);
  }
  public PersistentVolumeClaimBuilder(Boolean validationEnabled) {
    this(new PersistentVolumeClaim(), validationEnabled);
  }
  public PersistentVolumeClaimBuilder(PersistentVolumeClaimFluent<?> fluent) {
    this(fluent, false);
  }
  public PersistentVolumeClaimBuilder(PersistentVolumeClaimFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new PersistentVolumeClaim(), validationEnabled);
  }
  public PersistentVolumeClaimBuilder(PersistentVolumeClaimFluent<?> fluent,PersistentVolumeClaim instance) {
    this(fluent, instance, false);
  }
  public PersistentVolumeClaimBuilder(PersistentVolumeClaimFluent<?> fluent,PersistentVolumeClaim instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new PersistentVolumeClaim());

    if (instance != null) {
      fluent.withClaimName(instance.getClaimName());
      fluent.withReadOnly(instance.getReadOnly());
    }
    this.validationEnabled = validationEnabled; 
  }
  public PersistentVolumeClaimBuilder(PersistentVolumeClaim instance) {
    this(instance,false);
  }
  public PersistentVolumeClaimBuilder(PersistentVolumeClaim instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new PersistentVolumeClaim());

    if (instance != null) {
      this.withClaimName(instance.getClaimName());
      this.withReadOnly(instance.getReadOnly());
    }
    this.validationEnabled = validationEnabled; 
  }
  PersistentVolumeClaimFluent<?> fluent;
  Boolean validationEnabled;
  public PersistentVolumeClaim build() {
    PersistentVolumeClaim buildable = new PersistentVolumeClaim();
    buildable.setClaimName(fluent.getClaimName());
    buildable.setReadOnly(fluent.getReadOnly());
    return buildable;
  }
  
}