package io.apicurio.registry.operator.api.v1.model.apicurioregistryspec.deployment.podtemplatespecpreview.spec.volumes;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PhotonPersistentDiskBuilder extends PhotonPersistentDiskFluent<PhotonPersistentDiskBuilder> implements VisitableBuilder<PhotonPersistentDisk,PhotonPersistentDiskBuilder>{
  public PhotonPersistentDiskBuilder() {
    this(false);
  }
  public PhotonPersistentDiskBuilder(Boolean validationEnabled) {
    this(new PhotonPersistentDisk(), validationEnabled);
  }
  public PhotonPersistentDiskBuilder(PhotonPersistentDiskFluent<?> fluent) {
    this(fluent, false);
  }
  public PhotonPersistentDiskBuilder(PhotonPersistentDiskFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new PhotonPersistentDisk(), validationEnabled);
  }
  public PhotonPersistentDiskBuilder(PhotonPersistentDiskFluent<?> fluent,PhotonPersistentDisk instance) {
    this(fluent, instance, false);
  }
  public PhotonPersistentDiskBuilder(PhotonPersistentDiskFluent<?> fluent,PhotonPersistentDisk instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new PhotonPersistentDisk());

    if (instance != null) {
      fluent.withFsType(instance.getFsType());
      fluent.withPdID(instance.getPdID());
    }
    this.validationEnabled = validationEnabled; 
  }
  public PhotonPersistentDiskBuilder(PhotonPersistentDisk instance) {
    this(instance,false);
  }
  public PhotonPersistentDiskBuilder(PhotonPersistentDisk instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new PhotonPersistentDisk());

    if (instance != null) {
      this.withFsType(instance.getFsType());
      this.withPdID(instance.getPdID());
    }
    this.validationEnabled = validationEnabled; 
  }
  PhotonPersistentDiskFluent<?> fluent;
  Boolean validationEnabled;
  public PhotonPersistentDisk build() {
    PhotonPersistentDisk buildable = new PhotonPersistentDisk();
    buildable.setFsType(fluent.getFsType());
    buildable.setPdID(fluent.getPdID());
    return buildable;
  }
  
}