package io.apicurio.registry.operator.api.v1.model.apicurioregistryspec.deployment.podtemplatespecpreview.spec.volumes;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PortworxVolumeBuilder extends PortworxVolumeFluent<PortworxVolumeBuilder> implements VisitableBuilder<PortworxVolume,PortworxVolumeBuilder>{
  public PortworxVolumeBuilder() {
    this(false);
  }
  public PortworxVolumeBuilder(Boolean validationEnabled) {
    this(new PortworxVolume(), validationEnabled);
  }
  public PortworxVolumeBuilder(PortworxVolumeFluent<?> fluent) {
    this(fluent, false);
  }
  public PortworxVolumeBuilder(PortworxVolumeFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new PortworxVolume(), validationEnabled);
  }
  public PortworxVolumeBuilder(PortworxVolumeFluent<?> fluent,PortworxVolume instance) {
    this(fluent, instance, false);
  }
  public PortworxVolumeBuilder(PortworxVolumeFluent<?> fluent,PortworxVolume instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new PortworxVolume());

    if (instance != null) {
      fluent.withFsType(instance.getFsType());
      fluent.withReadOnly(instance.getReadOnly());
      fluent.withVolumeID(instance.getVolumeID());
    }
    this.validationEnabled = validationEnabled; 
  }
  public PortworxVolumeBuilder(PortworxVolume instance) {
    this(instance,false);
  }
  public PortworxVolumeBuilder(PortworxVolume instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new PortworxVolume());

    if (instance != null) {
      this.withFsType(instance.getFsType());
      this.withReadOnly(instance.getReadOnly());
      this.withVolumeID(instance.getVolumeID());
    }
    this.validationEnabled = validationEnabled; 
  }
  PortworxVolumeFluent<?> fluent;
  Boolean validationEnabled;
  public PortworxVolume build() {
    PortworxVolume buildable = new PortworxVolume();
    buildable.setFsType(fluent.getFsType());
    buildable.setReadOnly(fluent.getReadOnly());
    buildable.setVolumeID(fluent.getVolumeID());
    return buildable;
  }
  
}