package io.apicurio.registry.operator.api.v1.model.apicurioregistryspec.deployment.podtemplatespecpreview.spec.volumes;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class QuobyteBuilder extends QuobyteFluent<QuobyteBuilder> implements VisitableBuilder<Quobyte,QuobyteBuilder>{
  public QuobyteBuilder() {
    this(false);
  }
  public QuobyteBuilder(Boolean validationEnabled) {
    this(new Quobyte(), validationEnabled);
  }
  public QuobyteBuilder(QuobyteFluent<?> fluent) {
    this(fluent, false);
  }
  public QuobyteBuilder(QuobyteFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Quobyte(), validationEnabled);
  }
  public QuobyteBuilder(QuobyteFluent<?> fluent,Quobyte instance) {
    this(fluent, instance, false);
  }
  public QuobyteBuilder(QuobyteFluent<?> fluent,Quobyte instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new Quobyte());

    if (instance != null) {
      fluent.withGroup(instance.getGroup());
      fluent.withReadOnly(instance.getReadOnly());
      fluent.withRegistry(instance.getRegistry());
      fluent.withTenant(instance.getTenant());
      fluent.withUser(instance.getUser());
      fluent.withVolume(instance.getVolume());
    }
    this.validationEnabled = validationEnabled; 
  }
  public QuobyteBuilder(Quobyte instance) {
    this(instance,false);
  }
  public QuobyteBuilder(Quobyte instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new Quobyte());

    if (instance != null) {
      this.withGroup(instance.getGroup());
      this.withReadOnly(instance.getReadOnly());
      this.withRegistry(instance.getRegistry());
      this.withTenant(instance.getTenant());
      this.withUser(instance.getUser());
      this.withVolume(instance.getVolume());
    }
    this.validationEnabled = validationEnabled; 
  }
  QuobyteFluent<?> fluent;
  Boolean validationEnabled;
  public Quobyte build() {
    Quobyte buildable = new Quobyte();
    buildable.setGroup(fluent.getGroup());
    buildable.setReadOnly(fluent.getReadOnly());
    buildable.setRegistry(fluent.getRegistry());
    buildable.setTenant(fluent.getTenant());
    buildable.setUser(fluent.getUser());
    buildable.setVolume(fluent.getVolume());
    return buildable;
  }
  
}