package io.apicurio.registry.operator.api.v1.model.apicurioregistryspec.deployment.podtemplatespecpreview.spec.volumes;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class RbdBuilder extends RbdFluent<RbdBuilder> implements VisitableBuilder<Rbd,RbdBuilder>{
  public RbdBuilder() {
    this(false);
  }
  public RbdBuilder(Boolean validationEnabled) {
    this(new Rbd(), validationEnabled);
  }
  public RbdBuilder(RbdFluent<?> fluent) {
    this(fluent, false);
  }
  public RbdBuilder(RbdFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Rbd(), validationEnabled);
  }
  public RbdBuilder(RbdFluent<?> fluent,Rbd instance) {
    this(fluent, instance, false);
  }
  public RbdBuilder(RbdFluent<?> fluent,Rbd instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new Rbd());

    if (instance != null) {
      fluent.withFsType(instance.getFsType());
      fluent.withImage(instance.getImage());
      fluent.withKeyring(instance.getKeyring());
      fluent.withMonitors(instance.getMonitors());
      fluent.withPool(instance.getPool());
      fluent.withReadOnly(instance.getReadOnly());
      fluent.withSecretRef(instance.getSecretRef());
      fluent.withUser(instance.getUser());
    }
    this.validationEnabled = validationEnabled; 
  }
  public RbdBuilder(Rbd instance) {
    this(instance,false);
  }
  public RbdBuilder(Rbd instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new Rbd());

    if (instance != null) {
      this.withFsType(instance.getFsType());
      this.withImage(instance.getImage());
      this.withKeyring(instance.getKeyring());
      this.withMonitors(instance.getMonitors());
      this.withPool(instance.getPool());
      this.withReadOnly(instance.getReadOnly());
      this.withSecretRef(instance.getSecretRef());
      this.withUser(instance.getUser());
    }
    this.validationEnabled = validationEnabled; 
  }
  RbdFluent<?> fluent;
  Boolean validationEnabled;
  public Rbd build() {
    Rbd buildable = new Rbd();
    buildable.setFsType(fluent.getFsType());
    buildable.setImage(fluent.getImage());
    buildable.setKeyring(fluent.getKeyring());
    buildable.setMonitors(fluent.getMonitors());
    buildable.setPool(fluent.getPool());
    buildable.setReadOnly(fluent.getReadOnly());
    buildable.setSecretRef(fluent.buildSecretRef());
    buildable.setUser(fluent.getUser());
    return buildable;
  }
  
}