package io.apicurio.registry.operator.api.v1.model.apicurioregistryspec.deployment.podtemplatespecpreview.spec.volumes;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ScaleIOBuilder extends ScaleIOFluent<ScaleIOBuilder> implements VisitableBuilder<ScaleIO,ScaleIOBuilder>{
  public ScaleIOBuilder() {
    this(false);
  }
  public ScaleIOBuilder(Boolean validationEnabled) {
    this(new ScaleIO(), validationEnabled);
  }
  public ScaleIOBuilder(ScaleIOFluent<?> fluent) {
    this(fluent, false);
  }
  public ScaleIOBuilder(ScaleIOFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ScaleIO(), validationEnabled);
  }
  public ScaleIOBuilder(ScaleIOFluent<?> fluent,ScaleIO instance) {
    this(fluent, instance, false);
  }
  public ScaleIOBuilder(ScaleIOFluent<?> fluent,ScaleIO instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ScaleIO());

    if (instance != null) {
      fluent.withFsType(instance.getFsType());
      fluent.withGateway(instance.getGateway());
      fluent.withProtectionDomain(instance.getProtectionDomain());
      fluent.withReadOnly(instance.getReadOnly());
      fluent.withSecretRef(instance.getSecretRef());
      fluent.withSslEnabled(instance.getSslEnabled());
      fluent.withStorageMode(instance.getStorageMode());
      fluent.withStoragePool(instance.getStoragePool());
      fluent.withSystem(instance.getSystem());
      fluent.withVolumeName(instance.getVolumeName());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ScaleIOBuilder(ScaleIO instance) {
    this(instance,false);
  }
  public ScaleIOBuilder(ScaleIO instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ScaleIO());

    if (instance != null) {
      this.withFsType(instance.getFsType());
      this.withGateway(instance.getGateway());
      this.withProtectionDomain(instance.getProtectionDomain());
      this.withReadOnly(instance.getReadOnly());
      this.withSecretRef(instance.getSecretRef());
      this.withSslEnabled(instance.getSslEnabled());
      this.withStorageMode(instance.getStorageMode());
      this.withStoragePool(instance.getStoragePool());
      this.withSystem(instance.getSystem());
      this.withVolumeName(instance.getVolumeName());
    }
    this.validationEnabled = validationEnabled; 
  }
  ScaleIOFluent<?> fluent;
  Boolean validationEnabled;
  public ScaleIO build() {
    ScaleIO buildable = new ScaleIO();
    buildable.setFsType(fluent.getFsType());
    buildable.setGateway(fluent.getGateway());
    buildable.setProtectionDomain(fluent.getProtectionDomain());
    buildable.setReadOnly(fluent.getReadOnly());
    buildable.setSecretRef(fluent.buildSecretRef());
    buildable.setSslEnabled(fluent.getSslEnabled());
    buildable.setStorageMode(fluent.getStorageMode());
    buildable.setStoragePool(fluent.getStoragePool());
    buildable.setSystem(fluent.getSystem());
    buildable.setVolumeName(fluent.getVolumeName());
    return buildable;
  }
  
}