package io.apicurio.registry.operator.api.v1.model.apicurioregistryspec.deployment.podtemplatespecpreview.spec.volumes;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class SecretBuilder extends SecretFluent<SecretBuilder> implements VisitableBuilder<Secret,SecretBuilder>{
  public SecretBuilder() {
    this(false);
  }
  public SecretBuilder(Boolean validationEnabled) {
    this(new Secret(), validationEnabled);
  }
  public SecretBuilder(SecretFluent<?> fluent) {
    this(fluent, false);
  }
  public SecretBuilder(SecretFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Secret(), validationEnabled);
  }
  public SecretBuilder(SecretFluent<?> fluent,Secret instance) {
    this(fluent, instance, false);
  }
  public SecretBuilder(SecretFluent<?> fluent,Secret instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new Secret());

    if (instance != null) {
      fluent.withDefaultMode(instance.getDefaultMode());
      fluent.withItems(instance.getItems());
      fluent.withOptional(instance.getOptional());
      fluent.withSecretName(instance.getSecretName());
    }
    this.validationEnabled = validationEnabled; 
  }
  public SecretBuilder(Secret instance) {
    this(instance,false);
  }
  public SecretBuilder(Secret instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new Secret());

    if (instance != null) {
      this.withDefaultMode(instance.getDefaultMode());
      this.withItems(instance.getItems());
      this.withOptional(instance.getOptional());
      this.withSecretName(instance.getSecretName());
    }
    this.validationEnabled = validationEnabled; 
  }
  SecretFluent<?> fluent;
  Boolean validationEnabled;
  public Secret build() {
    Secret buildable = new Secret();
    buildable.setDefaultMode(fluent.getDefaultMode());
    buildable.setItems(fluent.buildItems());
    buildable.setOptional(fluent.getOptional());
    buildable.setSecretName(fluent.getSecretName());
    return buildable;
  }
  
}