package io.apicurio.registry.operator.api.v1.model.apicurioregistryspec.deployment.podtemplatespecpreview.spec.volumes;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class StorageosBuilder extends StorageosFluent<StorageosBuilder> implements VisitableBuilder<Storageos,StorageosBuilder>{
  public StorageosBuilder() {
    this(false);
  }
  public StorageosBuilder(Boolean validationEnabled) {
    this(new Storageos(), validationEnabled);
  }
  public StorageosBuilder(StorageosFluent<?> fluent) {
    this(fluent, false);
  }
  public StorageosBuilder(StorageosFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Storageos(), validationEnabled);
  }
  public StorageosBuilder(StorageosFluent<?> fluent,Storageos instance) {
    this(fluent, instance, false);
  }
  public StorageosBuilder(StorageosFluent<?> fluent,Storageos instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new Storageos());

    if (instance != null) {
      fluent.withFsType(instance.getFsType());
      fluent.withReadOnly(instance.getReadOnly());
      fluent.withSecretRef(instance.getSecretRef());
      fluent.withVolumeName(instance.getVolumeName());
      fluent.withVolumeNamespace(instance.getVolumeNamespace());
    }
    this.validationEnabled = validationEnabled; 
  }
  public StorageosBuilder(Storageos instance) {
    this(instance,false);
  }
  public StorageosBuilder(Storageos instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new Storageos());

    if (instance != null) {
      this.withFsType(instance.getFsType());
      this.withReadOnly(instance.getReadOnly());
      this.withSecretRef(instance.getSecretRef());
      this.withVolumeName(instance.getVolumeName());
      this.withVolumeNamespace(instance.getVolumeNamespace());
    }
    this.validationEnabled = validationEnabled; 
  }
  StorageosFluent<?> fluent;
  Boolean validationEnabled;
  public Storageos build() {
    Storageos buildable = new Storageos();
    buildable.setFsType(fluent.getFsType());
    buildable.setReadOnly(fluent.getReadOnly());
    buildable.setSecretRef(fluent.buildSecretRef());
    buildable.setVolumeName(fluent.getVolumeName());
    buildable.setVolumeNamespace(fluent.getVolumeNamespace());
    return buildable;
  }
  
}