package io.apicurio.registry.operator.api.v1.model.apicurioregistryspec.deployment.podtemplatespecpreview.spec.volumes;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class VsphereVolumeBuilder extends VsphereVolumeFluent<VsphereVolumeBuilder> implements VisitableBuilder<VsphereVolume,VsphereVolumeBuilder>{
  public VsphereVolumeBuilder() {
    this(false);
  }
  public VsphereVolumeBuilder(Boolean validationEnabled) {
    this(new VsphereVolume(), validationEnabled);
  }
  public VsphereVolumeBuilder(VsphereVolumeFluent<?> fluent) {
    this(fluent, false);
  }
  public VsphereVolumeBuilder(VsphereVolumeFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new VsphereVolume(), validationEnabled);
  }
  public VsphereVolumeBuilder(VsphereVolumeFluent<?> fluent,VsphereVolume instance) {
    this(fluent, instance, false);
  }
  public VsphereVolumeBuilder(VsphereVolumeFluent<?> fluent,VsphereVolume instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new VsphereVolume());

    if (instance != null) {
      fluent.withFsType(instance.getFsType());
      fluent.withStoragePolicyID(instance.getStoragePolicyID());
      fluent.withStoragePolicyName(instance.getStoragePolicyName());
      fluent.withVolumePath(instance.getVolumePath());
    }
    this.validationEnabled = validationEnabled; 
  }
  public VsphereVolumeBuilder(VsphereVolume instance) {
    this(instance,false);
  }
  public VsphereVolumeBuilder(VsphereVolume instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new VsphereVolume());

    if (instance != null) {
      this.withFsType(instance.getFsType());
      this.withStoragePolicyID(instance.getStoragePolicyID());
      this.withStoragePolicyName(instance.getStoragePolicyName());
      this.withVolumePath(instance.getVolumePath());
    }
    this.validationEnabled = validationEnabled; 
  }
  VsphereVolumeFluent<?> fluent;
  Boolean validationEnabled;
  public VsphereVolume build() {
    VsphereVolume buildable = new VsphereVolume();
    buildable.setFsType(fluent.getFsType());
    buildable.setStoragePolicyID(fluent.getStoragePolicyID());
    buildable.setStoragePolicyName(fluent.getStoragePolicyName());
    buildable.setVolumePath(fluent.getVolumePath());
    return buildable;
  }
  
}