package io.apicurio.registry.operator.api.v1.model.apicurioregistryspec.deployment.podtemplatespecpreview.spec.volumes.csi;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class NodePublishSecretRefBuilder extends NodePublishSecretRefFluent<NodePublishSecretRefBuilder> implements VisitableBuilder<NodePublishSecretRef,NodePublishSecretRefBuilder>{
  public NodePublishSecretRefBuilder() {
    this(false);
  }
  public NodePublishSecretRefBuilder(Boolean validationEnabled) {
    this(new NodePublishSecretRef(), validationEnabled);
  }
  public NodePublishSecretRefBuilder(NodePublishSecretRefFluent<?> fluent) {
    this(fluent, false);
  }
  public NodePublishSecretRefBuilder(NodePublishSecretRefFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new NodePublishSecretRef(), validationEnabled);
  }
  public NodePublishSecretRefBuilder(NodePublishSecretRefFluent<?> fluent,NodePublishSecretRef instance) {
    this(fluent, instance, false);
  }
  public NodePublishSecretRefBuilder(NodePublishSecretRefFluent<?> fluent,NodePublishSecretRef instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new NodePublishSecretRef());

    if (instance != null) {
      fluent.withName(instance.getName());
    }
    this.validationEnabled = validationEnabled; 
  }
  public NodePublishSecretRefBuilder(NodePublishSecretRef instance) {
    this(instance,false);
  }
  public NodePublishSecretRefBuilder(NodePublishSecretRef instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new NodePublishSecretRef());

    if (instance != null) {
      this.withName(instance.getName());
    }
    this.validationEnabled = validationEnabled; 
  }
  NodePublishSecretRefFluent<?> fluent;
  Boolean validationEnabled;
  public NodePublishSecretRef build() {
    NodePublishSecretRef buildable = new NodePublishSecretRef();
    buildable.setName(fluent.getName());
    return buildable;
  }
  
}