package io.apicurio.registry.operator.api.v1.model.apicurioregistryspec.deployment.podtemplatespecpreview.spec.volumes.ephemeral.volumeclaimtemplate;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class SpecBuilder extends SpecFluent<SpecBuilder> implements VisitableBuilder<Spec,SpecBuilder>{
  public SpecBuilder() {
    this(false);
  }
  public SpecBuilder(Boolean validationEnabled) {
    this(new Spec(), validationEnabled);
  }
  public SpecBuilder(SpecFluent<?> fluent) {
    this(fluent, false);
  }
  public SpecBuilder(SpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Spec(), validationEnabled);
  }
  public SpecBuilder(SpecFluent<?> fluent,Spec instance) {
    this(fluent, instance, false);
  }
  public SpecBuilder(SpecFluent<?> fluent,Spec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new Spec());

    if (instance != null) {
      fluent.withAccessModes(instance.getAccessModes());
      fluent.withDataSource(instance.getDataSource());
      fluent.withDataSourceRef(instance.getDataSourceRef());
      fluent.withResources(instance.getResources());
      fluent.withSelector(instance.getSelector());
      fluent.withStorageClassName(instance.getStorageClassName());
      fluent.withVolumeMode(instance.getVolumeMode());
      fluent.withVolumeName(instance.getVolumeName());
    }
    this.validationEnabled = validationEnabled; 
  }
  public SpecBuilder(Spec instance) {
    this(instance,false);
  }
  public SpecBuilder(Spec instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new Spec());

    if (instance != null) {
      this.withAccessModes(instance.getAccessModes());
      this.withDataSource(instance.getDataSource());
      this.withDataSourceRef(instance.getDataSourceRef());
      this.withResources(instance.getResources());
      this.withSelector(instance.getSelector());
      this.withStorageClassName(instance.getStorageClassName());
      this.withVolumeMode(instance.getVolumeMode());
      this.withVolumeName(instance.getVolumeName());
    }
    this.validationEnabled = validationEnabled; 
  }
  SpecFluent<?> fluent;
  Boolean validationEnabled;
  public Spec build() {
    Spec buildable = new Spec();
    buildable.setAccessModes(fluent.getAccessModes());
    buildable.setDataSource(fluent.buildDataSource());
    buildable.setDataSourceRef(fluent.buildDataSourceRef());
    buildable.setResources(fluent.buildResources());
    buildable.setSelector(fluent.buildSelector());
    buildable.setStorageClassName(fluent.getStorageClassName());
    buildable.setVolumeMode(fluent.getVolumeMode());
    buildable.setVolumeName(fluent.getVolumeName());
    return buildable;
  }
  
}