package io.apicurio.registry.operator.api.v1.model.apicurioregistryspec.deployment.podtemplatespecpreview.spec.volumes.ephemeral.volumeclaimtemplate.spec;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class DataSourceBuilder extends DataSourceFluent<DataSourceBuilder> implements VisitableBuilder<DataSource,DataSourceBuilder>{
  public DataSourceBuilder() {
    this(false);
  }
  public DataSourceBuilder(Boolean validationEnabled) {
    this(new DataSource(), validationEnabled);
  }
  public DataSourceBuilder(DataSourceFluent<?> fluent) {
    this(fluent, false);
  }
  public DataSourceBuilder(DataSourceFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new DataSource(), validationEnabled);
  }
  public DataSourceBuilder(DataSourceFluent<?> fluent,DataSource instance) {
    this(fluent, instance, false);
  }
  public DataSourceBuilder(DataSourceFluent<?> fluent,DataSource instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new DataSource());

    if (instance != null) {
      fluent.withApiGroup(instance.getApiGroup());
      fluent.withKind(instance.getKind());
      fluent.withName(instance.getName());
    }
    this.validationEnabled = validationEnabled; 
  }
  public DataSourceBuilder(DataSource instance) {
    this(instance,false);
  }
  public DataSourceBuilder(DataSource instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new DataSource());

    if (instance != null) {
      this.withApiGroup(instance.getApiGroup());
      this.withKind(instance.getKind());
      this.withName(instance.getName());
    }
    this.validationEnabled = validationEnabled; 
  }
  DataSourceFluent<?> fluent;
  Boolean validationEnabled;
  public DataSource build() {
    DataSource buildable = new DataSource();
    buildable.setApiGroup(fluent.getApiGroup());
    buildable.setKind(fluent.getKind());
    buildable.setName(fluent.getName());
    return buildable;
  }
  
}