package io.apicurio.registry.operator.api.v1.model.apicurioregistryspec.deployment.podtemplatespecpreview.spec.volumes.ephemeral.volumeclaimtemplate.spec;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class DataSourceRefBuilder extends DataSourceRefFluent<DataSourceRefBuilder> implements VisitableBuilder<DataSourceRef,DataSourceRefBuilder>{
  public DataSourceRefBuilder() {
    this(false);
  }
  public DataSourceRefBuilder(Boolean validationEnabled) {
    this(new DataSourceRef(), validationEnabled);
  }
  public DataSourceRefBuilder(DataSourceRefFluent<?> fluent) {
    this(fluent, false);
  }
  public DataSourceRefBuilder(DataSourceRefFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new DataSourceRef(), validationEnabled);
  }
  public DataSourceRefBuilder(DataSourceRefFluent<?> fluent,DataSourceRef instance) {
    this(fluent, instance, false);
  }
  public DataSourceRefBuilder(DataSourceRefFluent<?> fluent,DataSourceRef instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new DataSourceRef());

    if (instance != null) {
      fluent.withApiGroup(instance.getApiGroup());
      fluent.withKind(instance.getKind());
      fluent.withName(instance.getName());
    }
    this.validationEnabled = validationEnabled; 
  }
  public DataSourceRefBuilder(DataSourceRef instance) {
    this(instance,false);
  }
  public DataSourceRefBuilder(DataSourceRef instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new DataSourceRef());

    if (instance != null) {
      this.withApiGroup(instance.getApiGroup());
      this.withKind(instance.getKind());
      this.withName(instance.getName());
    }
    this.validationEnabled = validationEnabled; 
  }
  DataSourceRefFluent<?> fluent;
  Boolean validationEnabled;
  public DataSourceRef build() {
    DataSourceRef buildable = new DataSourceRef();
    buildable.setApiGroup(fluent.getApiGroup());
    buildable.setKind(fluent.getKind());
    buildable.setName(fluent.getName());
    return buildable;
  }
  
}