package io.apicurio.registry.operator.api.v1.model.apicurioregistryspec.deployment.podtemplatespecpreview.spec.volumes.ephemeral.volumeclaimtemplate.spec;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ResourcesBuilder extends ResourcesFluent<ResourcesBuilder> implements VisitableBuilder<Resources,ResourcesBuilder>{
  public ResourcesBuilder() {
    this(false);
  }
  public ResourcesBuilder(Boolean validationEnabled) {
    this(new Resources(), validationEnabled);
  }
  public ResourcesBuilder(ResourcesFluent<?> fluent) {
    this(fluent, false);
  }
  public ResourcesBuilder(ResourcesFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Resources(), validationEnabled);
  }
  public ResourcesBuilder(ResourcesFluent<?> fluent,Resources instance) {
    this(fluent, instance, false);
  }
  public ResourcesBuilder(ResourcesFluent<?> fluent,Resources instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new Resources());

    if (instance != null) {
      fluent.withLimits(instance.getLimits());
      fluent.withRequests(instance.getRequests());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ResourcesBuilder(Resources instance) {
    this(instance,false);
  }
  public ResourcesBuilder(Resources instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new Resources());

    if (instance != null) {
      this.withLimits(instance.getLimits());
      this.withRequests(instance.getRequests());
    }
    this.validationEnabled = validationEnabled; 
  }
  ResourcesFluent<?> fluent;
  Boolean validationEnabled;
  public Resources build() {
    Resources buildable = new Resources();
    buildable.setLimits(fluent.getLimits());
    buildable.setRequests(fluent.getRequests());
    return buildable;
  }
  
}