package io.apicurio.registry.operator.api.v1.model.apicurioregistryspec.deployment.podtemplatespecpreview.spec.volumes.ephemeral.volumeclaimtemplate.spec;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class SelectorBuilder extends SelectorFluent<SelectorBuilder> implements VisitableBuilder<Selector,SelectorBuilder>{
  public SelectorBuilder() {
    this(false);
  }
  public SelectorBuilder(Boolean validationEnabled) {
    this(new Selector(), validationEnabled);
  }
  public SelectorBuilder(SelectorFluent<?> fluent) {
    this(fluent, false);
  }
  public SelectorBuilder(SelectorFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Selector(), validationEnabled);
  }
  public SelectorBuilder(SelectorFluent<?> fluent,Selector instance) {
    this(fluent, instance, false);
  }
  public SelectorBuilder(SelectorFluent<?> fluent,Selector instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new Selector());

    if (instance != null) {
      fluent.withMatchExpressions(instance.getMatchExpressions());
      fluent.withMatchLabels(instance.getMatchLabels());
    }
    this.validationEnabled = validationEnabled; 
  }
  public SelectorBuilder(Selector instance) {
    this(instance,false);
  }
  public SelectorBuilder(Selector instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new Selector());

    if (instance != null) {
      this.withMatchExpressions(instance.getMatchExpressions());
      this.withMatchLabels(instance.getMatchLabels());
    }
    this.validationEnabled = validationEnabled; 
  }
  SelectorFluent<?> fluent;
  Boolean validationEnabled;
  public Selector build() {
    Selector buildable = new Selector();
    buildable.setMatchExpressions(fluent.buildMatchExpressions());
    buildable.setMatchLabels(fluent.getMatchLabels());
    return buildable;
  }
  
}