package io.apicurio.registry.operator.api.v1.model.apicurioregistryspec.deployment.podtemplatespecpreview.spec.volumes.projected;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class SourcesBuilder extends SourcesFluent<SourcesBuilder> implements VisitableBuilder<Sources,SourcesBuilder>{
  public SourcesBuilder() {
    this(false);
  }
  public SourcesBuilder(Boolean validationEnabled) {
    this(new Sources(), validationEnabled);
  }
  public SourcesBuilder(SourcesFluent<?> fluent) {
    this(fluent, false);
  }
  public SourcesBuilder(SourcesFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Sources(), validationEnabled);
  }
  public SourcesBuilder(SourcesFluent<?> fluent,Sources instance) {
    this(fluent, instance, false);
  }
  public SourcesBuilder(SourcesFluent<?> fluent,Sources instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new Sources());

    if (instance != null) {
      fluent.withConfigMap(instance.getConfigMap());
      fluent.withDownwardAPI(instance.getDownwardAPI());
      fluent.withSecret(instance.getSecret());
      fluent.withServiceAccountToken(instance.getServiceAccountToken());
    }
    this.validationEnabled = validationEnabled; 
  }
  public SourcesBuilder(Sources instance) {
    this(instance,false);
  }
  public SourcesBuilder(Sources instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new Sources());

    if (instance != null) {
      this.withConfigMap(instance.getConfigMap());
      this.withDownwardAPI(instance.getDownwardAPI());
      this.withSecret(instance.getSecret());
      this.withServiceAccountToken(instance.getServiceAccountToken());
    }
    this.validationEnabled = validationEnabled; 
  }
  SourcesFluent<?> fluent;
  Boolean validationEnabled;
  public Sources build() {
    Sources buildable = new Sources();
    buildable.setConfigMap(fluent.buildConfigMap());
    buildable.setDownwardAPI(fluent.buildDownwardAPI());
    buildable.setSecret(fluent.buildSecret());
    buildable.setServiceAccountToken(fluent.buildServiceAccountToken());
    return buildable;
  }
  
}