package io.apicurio.registry.operator.api.v1.model.apicurioregistryspec.deployment.podtemplatespecpreview.spec.volumes.projected.sources;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ConfigMapBuilder extends ConfigMapFluent<ConfigMapBuilder> implements VisitableBuilder<ConfigMap,ConfigMapBuilder>{
  public ConfigMapBuilder() {
    this(false);
  }
  public ConfigMapBuilder(Boolean validationEnabled) {
    this(new ConfigMap(), validationEnabled);
  }
  public ConfigMapBuilder(ConfigMapFluent<?> fluent) {
    this(fluent, false);
  }
  public ConfigMapBuilder(ConfigMapFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ConfigMap(), validationEnabled);
  }
  public ConfigMapBuilder(ConfigMapFluent<?> fluent,ConfigMap instance) {
    this(fluent, instance, false);
  }
  public ConfigMapBuilder(ConfigMapFluent<?> fluent,ConfigMap instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ConfigMap());

    if (instance != null) {
      fluent.withItems(instance.getItems());
      fluent.withName(instance.getName());
      fluent.withOptional(instance.getOptional());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ConfigMapBuilder(ConfigMap instance) {
    this(instance,false);
  }
  public ConfigMapBuilder(ConfigMap instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ConfigMap());

    if (instance != null) {
      this.withItems(instance.getItems());
      this.withName(instance.getName());
      this.withOptional(instance.getOptional());
    }
    this.validationEnabled = validationEnabled; 
  }
  ConfigMapFluent<?> fluent;
  Boolean validationEnabled;
  public ConfigMap build() {
    ConfigMap buildable = new ConfigMap();
    buildable.setItems(fluent.buildItems());
    buildable.setName(fluent.getName());
    buildable.setOptional(fluent.getOptional());
    return buildable;
  }
  
}