package io.apicurio.registry.operator.api.v1.model.apicurioregistryspec.deployment.podtemplatespecpreview.spec.volumes.projected.sources;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ServiceAccountTokenBuilder extends ServiceAccountTokenFluent<ServiceAccountTokenBuilder> implements VisitableBuilder<ServiceAccountToken,ServiceAccountTokenBuilder>{
  public ServiceAccountTokenBuilder() {
    this(false);
  }
  public ServiceAccountTokenBuilder(Boolean validationEnabled) {
    this(new ServiceAccountToken(), validationEnabled);
  }
  public ServiceAccountTokenBuilder(ServiceAccountTokenFluent<?> fluent) {
    this(fluent, false);
  }
  public ServiceAccountTokenBuilder(ServiceAccountTokenFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ServiceAccountToken(), validationEnabled);
  }
  public ServiceAccountTokenBuilder(ServiceAccountTokenFluent<?> fluent,ServiceAccountToken instance) {
    this(fluent, instance, false);
  }
  public ServiceAccountTokenBuilder(ServiceAccountTokenFluent<?> fluent,ServiceAccountToken instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ServiceAccountToken());

    if (instance != null) {
      fluent.withAudience(instance.getAudience());
      fluent.withExpirationSeconds(instance.getExpirationSeconds());
      fluent.withPath(instance.getPath());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ServiceAccountTokenBuilder(ServiceAccountToken instance) {
    this(instance,false);
  }
  public ServiceAccountTokenBuilder(ServiceAccountToken instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ServiceAccountToken());

    if (instance != null) {
      this.withAudience(instance.getAudience());
      this.withExpirationSeconds(instance.getExpirationSeconds());
      this.withPath(instance.getPath());
    }
    this.validationEnabled = validationEnabled; 
  }
  ServiceAccountTokenFluent<?> fluent;
  Boolean validationEnabled;
  public ServiceAccountToken build() {
    ServiceAccountToken buildable = new ServiceAccountToken();
    buildable.setAudience(fluent.getAudience());
    buildable.setExpirationSeconds(fluent.getExpirationSeconds());
    buildable.setPath(fluent.getPath());
    return buildable;
  }
  
}