package io.apicurio.registry.operator.api.v1.model.apicurioregistrystatus;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ConditionsBuilder extends ConditionsFluent<ConditionsBuilder> implements VisitableBuilder<Conditions,ConditionsBuilder>{
  public ConditionsBuilder() {
    this(false);
  }
  public ConditionsBuilder(Boolean validationEnabled) {
    this(new Conditions(), validationEnabled);
  }
  public ConditionsBuilder(ConditionsFluent<?> fluent) {
    this(fluent, false);
  }
  public ConditionsBuilder(ConditionsFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Conditions(), validationEnabled);
  }
  public ConditionsBuilder(ConditionsFluent<?> fluent,Conditions instance) {
    this(fluent, instance, false);
  }
  public ConditionsBuilder(ConditionsFluent<?> fluent,Conditions instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new Conditions());

    if (instance != null) {
      fluent.withLastTransitionTime(instance.getLastTransitionTime());
      fluent.withMessage(instance.getMessage());
      fluent.withObservedGeneration(instance.getObservedGeneration());
      fluent.withReason(instance.getReason());
      fluent.withStatus(instance.getStatus());
      fluent.withType(instance.getType());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ConditionsBuilder(Conditions instance) {
    this(instance,false);
  }
  public ConditionsBuilder(Conditions instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new Conditions());

    if (instance != null) {
      this.withLastTransitionTime(instance.getLastTransitionTime());
      this.withMessage(instance.getMessage());
      this.withObservedGeneration(instance.getObservedGeneration());
      this.withReason(instance.getReason());
      this.withStatus(instance.getStatus());
      this.withType(instance.getType());
    }
    this.validationEnabled = validationEnabled; 
  }
  ConditionsFluent<?> fluent;
  Boolean validationEnabled;
  public Conditions build() {
    Conditions buildable = new Conditions();
    buildable.setLastTransitionTime(fluent.getLastTransitionTime());
    buildable.setMessage(fluent.getMessage());
    buildable.setObservedGeneration(fluent.getObservedGeneration());
    buildable.setReason(fluent.getReason());
    buildable.setStatus(fluent.getStatus());
    buildable.setType(fluent.getType());
    return buildable;
  }
  
}