package io.apicurio.registry.operator.api.v1.model.apicurioregistrystatus;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class InfoBuilder extends InfoFluent<InfoBuilder> implements VisitableBuilder<Info,InfoBuilder>{
  public InfoBuilder() {
    this(false);
  }
  public InfoBuilder(Boolean validationEnabled) {
    this(new Info(), validationEnabled);
  }
  public InfoBuilder(InfoFluent<?> fluent) {
    this(fluent, false);
  }
  public InfoBuilder(InfoFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Info(), validationEnabled);
  }
  public InfoBuilder(InfoFluent<?> fluent,Info instance) {
    this(fluent, instance, false);
  }
  public InfoBuilder(InfoFluent<?> fluent,Info instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new Info());

    if (instance != null) {
      fluent.withHost(instance.getHost());
    }
    this.validationEnabled = validationEnabled; 
  }
  public InfoBuilder(Info instance) {
    this(instance,false);
  }
  public InfoBuilder(Info instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new Info());

    if (instance != null) {
      this.withHost(instance.getHost());
    }
    this.validationEnabled = validationEnabled; 
  }
  InfoFluent<?> fluent;
  Boolean validationEnabled;
  public Info build() {
    Info buildable = new Info();
    buildable.setHost(fluent.getHost());
    return buildable;
  }
  
}