package io.apicurio.registry.operator.api.v1.model.apicurioregistrystatus;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ManagedResourcesBuilder extends ManagedResourcesFluent<ManagedResourcesBuilder> implements VisitableBuilder<ManagedResources,ManagedResourcesBuilder>{
  public ManagedResourcesBuilder() {
    this(false);
  }
  public ManagedResourcesBuilder(Boolean validationEnabled) {
    this(new ManagedResources(), validationEnabled);
  }
  public ManagedResourcesBuilder(ManagedResourcesFluent<?> fluent) {
    this(fluent, false);
  }
  public ManagedResourcesBuilder(ManagedResourcesFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ManagedResources(), validationEnabled);
  }
  public ManagedResourcesBuilder(ManagedResourcesFluent<?> fluent,ManagedResources instance) {
    this(fluent, instance, false);
  }
  public ManagedResourcesBuilder(ManagedResourcesFluent<?> fluent,ManagedResources instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ManagedResources());

    if (instance != null) {
      fluent.withKind(instance.getKind());
      fluent.withName(instance.getName());
      fluent.withNamespace(instance.getNamespace());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ManagedResourcesBuilder(ManagedResources instance) {
    this(instance,false);
  }
  public ManagedResourcesBuilder(ManagedResources instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ManagedResources());

    if (instance != null) {
      this.withKind(instance.getKind());
      this.withName(instance.getName());
      this.withNamespace(instance.getNamespace());
    }
    this.validationEnabled = validationEnabled; 
  }
  ManagedResourcesFluent<?> fluent;
  Boolean validationEnabled;
  public ManagedResources build() {
    ManagedResources buildable = new ManagedResources();
    buildable.setKind(fluent.getKind());
    buildable.setName(fluent.getName());
    buildable.setNamespace(fluent.getNamespace());
    return buildable;
  }
  
}