/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.operator.api.v1.model;

import io.apicurio.registry.operator.api.v1.model.ApicurioRegistry;
import io.apicurio.registry.operator.api.v1.model.ApicurioRegistryBuilder;
import io.apicurio.registry.operator.api.v1.model.ApicurioRegistryFluent;
import io.apicurio.registry.operator.api.v1.model.ApicurioRegistryList;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class ApicurioRegistryListFluent<A extends ApicurioRegistryListFluent<A>>
extends BaseFluent<A> {
    private ListMeta metadata;
    private ArrayList<ApicurioRegistryBuilder> items;
    private String apiVersion;
    private String kind;

    public ApicurioRegistryListFluent() {
    }

    public ApicurioRegistryListFluent(ApicurioRegistryList instance) {
        ApicurioRegistryList apicurioRegistryList = instance = instance != null ? instance : new ApicurioRegistryList();
        if (instance != null) {
            this.withMetadata(instance.getMetadata());
            this.withItems(instance.getItems());
            this.withApiVersion(instance.getApiVersion());
            this.withKind(instance.getKind());
        }
    }

    public ListMeta getMetadata() {
        return this.metadata;
    }

    public A withMetadata(ListMeta metadata) {
        this.metadata = metadata;
        return (A)((Object)this);
    }

    public boolean hasMetadata() {
        return this.metadata != null;
    }

    public A withNewMetadata(String _continue, Long remainingItemCount, String resourceVersion, String selfLink) {
        return this.withMetadata(new ListMeta(_continue, remainingItemCount, resourceVersion, selfLink));
    }

    public A addToItems(int index, ApicurioRegistry item) {
        if (this.items == null) {
            this.items = new ArrayList();
        }
        ApicurioRegistryBuilder builder = new ApicurioRegistryBuilder(item);
        if (index < 0 || index >= this.items.size()) {
            this._visitables.get((Object)"items").add(builder);
            this.items.add(builder);
        } else {
            this._visitables.get((Object)"items").add(index, builder);
            this.items.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToItems(int index, ApicurioRegistry item) {
        if (this.items == null) {
            this.items = new ArrayList();
        }
        ApicurioRegistryBuilder builder = new ApicurioRegistryBuilder(item);
        if (index < 0 || index >= this.items.size()) {
            this._visitables.get((Object)"items").add(builder);
            this.items.add(builder);
        } else {
            this._visitables.get((Object)"items").set(index, builder);
            this.items.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToItems(ApicurioRegistry ... items) {
        if (this.items == null) {
            this.items = new ArrayList();
        }
        for (ApicurioRegistry item : items) {
            ApicurioRegistryBuilder builder = new ApicurioRegistryBuilder(item);
            this._visitables.get((Object)"items").add(builder);
            this.items.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToItems(Collection<ApicurioRegistry> items) {
        if (this.items == null) {
            this.items = new ArrayList();
        }
        for (ApicurioRegistry item : items) {
            ApicurioRegistryBuilder builder = new ApicurioRegistryBuilder(item);
            this._visitables.get((Object)"items").add(builder);
            this.items.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromItems(ApicurioRegistry ... items) {
        if (this.items == null) {
            return (A)((Object)this);
        }
        for (ApicurioRegistry item : items) {
            ApicurioRegistryBuilder builder = new ApicurioRegistryBuilder(item);
            this._visitables.get((Object)"items").remove((Object)builder);
            this.items.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromItems(Collection<ApicurioRegistry> items) {
        if (this.items == null) {
            return (A)((Object)this);
        }
        for (ApicurioRegistry item : items) {
            ApicurioRegistryBuilder builder = new ApicurioRegistryBuilder(item);
            this._visitables.get((Object)"items").remove((Object)builder);
            this.items.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromItems(Predicate<ApicurioRegistryBuilder> predicate) {
        if (this.items == null) {
            return (A)((Object)this);
        }
        Iterator<ApicurioRegistryBuilder> each = this.items.iterator();
        List visitables = this._visitables.get((Object)"items");
        while (each.hasNext()) {
            ApicurioRegistryBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<ApicurioRegistry> buildItems() {
        return this.items != null ? ApicurioRegistryListFluent.build(this.items) : null;
    }

    public ApicurioRegistry buildItem(int index) {
        return this.items.get(index).build();
    }

    public ApicurioRegistry buildFirstItem() {
        return this.items.get(0).build();
    }

    public ApicurioRegistry buildLastItem() {
        return this.items.get(this.items.size() - 1).build();
    }

    public ApicurioRegistry buildMatchingItem(Predicate<ApicurioRegistryBuilder> predicate) {
        for (ApicurioRegistryBuilder item : this.items) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingItem(Predicate<ApicurioRegistryBuilder> predicate) {
        for (ApicurioRegistryBuilder item : this.items) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withItems(List<ApicurioRegistry> items) {
        if (this.items != null) {
            this._visitables.get((Object)"items").clear();
        }
        if (items != null) {
            this.items = new ArrayList();
            for (ApicurioRegistry item : items) {
                this.addToItems(item);
            }
        } else {
            this.items = null;
        }
        return (A)((Object)this);
    }

    public A withItems(ApicurioRegistry ... items) {
        if (this.items != null) {
            this.items.clear();
            this._visitables.remove((Object)"items");
        }
        if (items != null) {
            for (ApicurioRegistry item : items) {
                this.addToItems(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasItems() {
        return this.items != null && !this.items.isEmpty();
    }

    public ItemsNested<A> addNewItem() {
        return new ItemsNested(-1, null);
    }

    public ItemsNested<A> addNewItemLike(ApicurioRegistry item) {
        return new ItemsNested(-1, item);
    }

    public ItemsNested<A> setNewItemLike(int index, ApicurioRegistry item) {
        return new ItemsNested(index, item);
    }

    public ItemsNested<A> editItem(int index) {
        if (this.items.size() <= index) {
            throw new RuntimeException("Can't edit items. Index exceeds size.");
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    public ItemsNested<A> editFirstItem() {
        if (this.items.size() == 0) {
            throw new RuntimeException("Can't edit first items. The list is empty.");
        }
        return this.setNewItemLike(0, this.buildItem(0));
    }

    public ItemsNested<A> editLastItem() {
        int index = this.items.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last items. The list is empty.");
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    public ItemsNested<A> editMatchingItem(Predicate<ApicurioRegistryBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.items.size(); ++i) {
            if (!predicate.test(this.items.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching items. No match found.");
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)((Object)this);
    }

    public boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    public String getKind() {
        return this.kind;
    }

    public A withKind(String kind) {
        this.kind = kind;
        return (A)((Object)this);
    }

    public boolean hasKind() {
        return this.kind != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ApicurioRegistryListFluent that = (ApicurioRegistryListFluent)((Object)o);
        if (!Objects.equals(this.metadata, that.metadata)) {
            return false;
        }
        if (!Objects.equals(this.items, that.items)) {
            return false;
        }
        if (!Objects.equals(this.apiVersion, that.apiVersion)) {
            return false;
        }
        return Objects.equals(this.kind, that.kind);
    }

    public int hashCode() {
        return Objects.hash(this.metadata, this.items, this.apiVersion, this.kind, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.metadata != null) {
            sb.append("metadata:");
            sb.append(this.metadata + ",");
        }
        if (this.items != null && !this.items.isEmpty()) {
            sb.append("items:");
            sb.append(this.items + ",");
        }
        if (this.apiVersion != null) {
            sb.append("apiVersion:");
            sb.append(this.apiVersion + ",");
        }
        if (this.kind != null) {
            sb.append("kind:");
            sb.append(this.kind);
        }
        sb.append("}");
        return sb.toString();
    }

    public class ItemsNested<N>
    extends ApicurioRegistryFluent<ItemsNested<N>>
    implements Nested<N> {
        ApicurioRegistryBuilder builder;
        int index;

        ItemsNested(int index, ApicurioRegistry item) {
            this.index = index;
            this.builder = new ApicurioRegistryBuilder(this, item);
        }

        public N and() {
            return (N)ApicurioRegistryListFluent.this.setToItems(this.index, this.builder.build());
        }

        public N endItem() {
            return this.and();
        }
    }
}

