/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.operator.api.v1.model.apicurioregistryspec.configuration;

import io.apicurio.registry.operator.api.v1.model.apicurioregistryspec.configuration.Kafkasql;
import io.apicurio.registry.operator.api.v1.model.apicurioregistryspec.configuration.kafkasql.Security;
import io.apicurio.registry.operator.api.v1.model.apicurioregistryspec.configuration.kafkasql.SecurityBuilder;
import io.apicurio.registry.operator.api.v1.model.apicurioregistryspec.configuration.kafkasql.SecurityFluent;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.Objects;
import java.util.Optional;

public class KafkasqlFluent<A extends KafkasqlFluent<A>>
extends BaseFluent<A> {
    private String bootstrapServers;
    private SecurityBuilder security;

    public KafkasqlFluent() {
    }

    public KafkasqlFluent(Kafkasql instance) {
        Kafkasql kafkasql = instance = instance != null ? instance : new Kafkasql();
        if (instance != null) {
            this.withBootstrapServers(instance.getBootstrapServers());
            this.withSecurity(instance.getSecurity());
        }
    }

    public String getBootstrapServers() {
        return this.bootstrapServers;
    }

    public A withBootstrapServers(String bootstrapServers) {
        this.bootstrapServers = bootstrapServers;
        return (A)((Object)this);
    }

    public boolean hasBootstrapServers() {
        return this.bootstrapServers != null;
    }

    public Security buildSecurity() {
        return this.security != null ? this.security.build() : null;
    }

    public A withSecurity(Security security) {
        this._visitables.get((Object)"security").remove((Object)this.security);
        if (security != null) {
            this.security = new SecurityBuilder(security);
            this._visitables.get((Object)"security").add(this.security);
        } else {
            this.security = null;
            this._visitables.get((Object)"security").remove((Object)this.security);
        }
        return (A)((Object)this);
    }

    public boolean hasSecurity() {
        return this.security != null;
    }

    public KafkasqlSecurityNested<A> withNewKafkasqlSecurity() {
        return new KafkasqlSecurityNested(null);
    }

    public KafkasqlSecurityNested<A> withNewSecurityLike(Security item) {
        return new KafkasqlSecurityNested(item);
    }

    public KafkasqlSecurityNested<A> editKafkasqlSecurity() {
        return this.withNewSecurityLike(Optional.ofNullable(this.buildSecurity()).orElse(null));
    }

    public KafkasqlSecurityNested<A> editOrNewSecurity() {
        return this.withNewSecurityLike(Optional.ofNullable(this.buildSecurity()).orElse(new SecurityBuilder().build()));
    }

    public KafkasqlSecurityNested<A> editOrNewSecurityLike(Security item) {
        return this.withNewSecurityLike(Optional.ofNullable(this.buildSecurity()).orElse(item));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        KafkasqlFluent that = (KafkasqlFluent)((Object)o);
        if (!Objects.equals(this.bootstrapServers, that.bootstrapServers)) {
            return false;
        }
        return Objects.equals((Object)this.security, (Object)that.security);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.bootstrapServers, this.security, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.bootstrapServers != null) {
            sb.append("bootstrapServers:");
            sb.append(this.bootstrapServers + ",");
        }
        if (this.security != null) {
            sb.append("security:");
            sb.append((Object)this.security);
        }
        sb.append("}");
        return sb.toString();
    }

    public class KafkasqlSecurityNested<N>
    extends SecurityFluent<KafkasqlSecurityNested<N>>
    implements Nested<N> {
        SecurityBuilder builder;

        KafkasqlSecurityNested(Security item) {
            this.builder = new SecurityBuilder(this, item);
        }

        public N and() {
            return (N)KafkasqlFluent.this.withSecurity(this.builder.build());
        }

        public N endKafkasqlSecurity() {
            return this.and();
        }
    }
}

