/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.operator.api.v1.model.apicurioregistryspec.deployment.podtemplatespecpreview.spec.topologyspreadconstraints.labelselector;

import io.apicurio.registry.operator.api.v1.model.apicurioregistryspec.deployment.podtemplatespecpreview.spec.topologyspreadconstraints.labelselector.MatchExpressions;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class MatchExpressionsFluent<A extends MatchExpressionsFluent<A>>
extends BaseFluent<A> {
    private String key;
    private String operator;
    private List<String> values;

    public MatchExpressionsFluent() {
    }

    public MatchExpressionsFluent(MatchExpressions instance) {
        MatchExpressions matchExpressions = instance = instance != null ? instance : new MatchExpressions();
        if (instance != null) {
            this.withKey(instance.getKey());
            this.withOperator(instance.getOperator());
            this.withValues(instance.getValues());
        }
    }

    public String getKey() {
        return this.key;
    }

    public A withKey(String key) {
        this.key = key;
        return (A)((Object)this);
    }

    public boolean hasKey() {
        return this.key != null;
    }

    public String getOperator() {
        return this.operator;
    }

    public A withOperator(String operator) {
        this.operator = operator;
        return (A)((Object)this);
    }

    public boolean hasOperator() {
        return this.operator != null;
    }

    public A addToValues(int index, String item) {
        if (this.values == null) {
            this.values = new ArrayList<String>();
        }
        this.values.add(index, item);
        return (A)((Object)this);
    }

    public A setToValues(int index, String item) {
        if (this.values == null) {
            this.values = new ArrayList<String>();
        }
        this.values.set(index, item);
        return (A)((Object)this);
    }

    public A addToValues(String ... items) {
        if (this.values == null) {
            this.values = new ArrayList<String>();
        }
        for (String item : items) {
            this.values.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToValues(Collection<String> items) {
        if (this.values == null) {
            this.values = new ArrayList<String>();
        }
        for (String item : items) {
            this.values.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromValues(String ... items) {
        if (this.values == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.values.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromValues(Collection<String> items) {
        if (this.values == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.values.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getValues() {
        return this.values;
    }

    public String getValue(int index) {
        return this.values.get(index);
    }

    public String getFirstValue() {
        return this.values.get(0);
    }

    public String getLastValue() {
        return this.values.get(this.values.size() - 1);
    }

    public String getMatchingValue(Predicate<String> predicate) {
        for (String item : this.values) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingValue(Predicate<String> predicate) {
        for (String item : this.values) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withValues(List<String> values) {
        if (values != null) {
            this.values = new ArrayList<String>();
            for (String item : values) {
                this.addToValues(item);
            }
        } else {
            this.values = null;
        }
        return (A)((Object)this);
    }

    public A withValues(String ... values) {
        if (this.values != null) {
            this.values.clear();
            this._visitables.remove((Object)"values");
        }
        if (values != null) {
            for (String item : values) {
                this.addToValues(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasValues() {
        return this.values != null && !this.values.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MatchExpressionsFluent that = (MatchExpressionsFluent)((Object)o);
        if (!Objects.equals(this.key, that.key)) {
            return false;
        }
        if (!Objects.equals(this.operator, that.operator)) {
            return false;
        }
        return Objects.equals(this.values, that.values);
    }

    public int hashCode() {
        return Objects.hash(this.key, this.operator, this.values, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.key != null) {
            sb.append("key:");
            sb.append(this.key + ",");
        }
        if (this.operator != null) {
            sb.append("operator:");
            sb.append(this.operator + ",");
        }
        if (this.values != null && !this.values.isEmpty()) {
            sb.append("values:");
            sb.append(this.values);
        }
        sb.append("}");
        return sb.toString();
    }
}

