/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.operator.api.v1.model.apicurioregistrystatus;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.generator.annotation.Min;
import io.fabric8.generator.annotation.Pattern;
import io.fabric8.generator.annotation.Required;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import java.time.ZonedDateTime;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"lastTransitionTime", "message", "observedGeneration", "reason", "status", "type"})
@JsonDeserialize(using=JsonDeserializer.None.class)
public class Conditions
implements KubernetesResource {
    @JsonProperty(value="lastTransitionTime")
    @Required
    @JsonPropertyDescription(value="lastTransitionTime is the last time the condition transitioned from one status to another. This should be when the underlying condition changed.  If that is not known, then using the time when the API field changed is acceptable.")
    @JsonSetter(nulls=Nulls.SKIP)
    private ZonedDateTime lastTransitionTime;
    @JsonProperty(value="message")
    @Required
    @JsonPropertyDescription(value="message is a human readable message indicating details about the transition. This may be an empty string.")
    @JsonSetter(nulls=Nulls.SKIP)
    private String message;
    @JsonProperty(value="observedGeneration")
    @Min(value=0.0)
    @JsonPropertyDescription(value="observedGeneration represents the .metadata.generation that the condition was set based upon. For instance, if .metadata.generation is currently 12, but the .status.conditions[x].observedGeneration is 9, the condition is out of date with respect to the current state of the instance.")
    @JsonSetter(nulls=Nulls.SKIP)
    private Long observedGeneration;
    @JsonProperty(value="reason")
    @Required
    @Pattern(value="^[A-Za-z]([A-Za-z0-9_,:]*[A-Za-z0-9_])?$")
    @JsonPropertyDescription(value="reason contains a programmatic identifier indicating the reason for the condition's last transition. Producers of specific condition types may define expected values and meanings for this field, and whether the values are considered a guaranteed API. The value should be a CamelCase string. This field may not be empty.")
    @JsonSetter(nulls=Nulls.SKIP)
    private String reason;
    @JsonProperty(value="status")
    @Required
    @JsonPropertyDescription(value="status of the condition, one of True, False, Unknown.")
    @JsonSetter(nulls=Nulls.SKIP)
    private Status status;
    @JsonProperty(value="type")
    @Required
    @Pattern(value="^([a-z0-9]([-a-z0-9]*[a-z0-9])?(\\.[a-z0-9]([-a-z0-9]*[a-z0-9])?)*/)?(([A-Za-z0-9][-A-Za-z0-9_.]*)?[A-Za-z0-9])$")
    @JsonPropertyDescription(value="type of condition in CamelCase or in foo.example.com/CamelCase. --- Many .condition.type values are consistent across resources like Available, but because arbitrary conditions can be useful (see .node.status.conditions), the ability to deconflict is important. The regex it matches is (dns1123SubdomainFmt/)?(qualifiedNameFmt)")
    @JsonSetter(nulls=Nulls.SKIP)
    private String type;

    @JsonFormat(pattern="yyyy-MM-dd'T'HH:mm:ssVV")
    public ZonedDateTime getLastTransitionTime() {
        return this.lastTransitionTime;
    }

    @JsonFormat(pattern="yyyy-MM-dd'T'HH:mm:ss[XXX][VV]")
    public void setLastTransitionTime(ZonedDateTime lastTransitionTime) {
        this.lastTransitionTime = lastTransitionTime;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public Long getObservedGeneration() {
        return this.observedGeneration;
    }

    public void setObservedGeneration(Long observedGeneration) {
        this.observedGeneration = observedGeneration;
    }

    public String getReason() {
        return this.reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String toString() {
        return "Conditions(lastTransitionTime=" + this.getLastTransitionTime() + ", message=" + this.getMessage() + ", observedGeneration=" + this.getObservedGeneration() + ", reason=" + this.getReason() + ", status=" + this.getStatus() + ", type=" + this.getType() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Conditions)) {
            return false;
        }
        Conditions other = (Conditions)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$observedGeneration = this.getObservedGeneration();
        Long other$observedGeneration = other.getObservedGeneration();
        if (this$observedGeneration == null ? other$observedGeneration != null : !((Object)this$observedGeneration).equals(other$observedGeneration)) {
            return false;
        }
        ZonedDateTime this$lastTransitionTime = this.getLastTransitionTime();
        ZonedDateTime other$lastTransitionTime = other.getLastTransitionTime();
        if (this$lastTransitionTime == null ? other$lastTransitionTime != null : !((Object)this$lastTransitionTime).equals(other$lastTransitionTime)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        String this$reason = this.getReason();
        String other$reason = other.getReason();
        if (this$reason == null ? other$reason != null : !this$reason.equals(other$reason)) {
            return false;
        }
        Status this$status = this.getStatus();
        Status other$status = other.getStatus();
        if (this$status == null ? other$status != null : !((Object)((Object)this$status)).equals((Object)other$status)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        return !(this$type == null ? other$type != null : !this$type.equals(other$type));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Conditions;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $observedGeneration = this.getObservedGeneration();
        result = result * 59 + ($observedGeneration == null ? 43 : ((Object)$observedGeneration).hashCode());
        ZonedDateTime $lastTransitionTime = this.getLastTransitionTime();
        result = result * 59 + ($lastTransitionTime == null ? 43 : ((Object)$lastTransitionTime).hashCode());
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        String $reason = this.getReason();
        result = result * 59 + ($reason == null ? 43 : $reason.hashCode());
        Status $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)((Object)$status)).hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        return result;
    }

    public static enum Status {
        TRUE("True"),
        FALSE("False"),
        UNKNOWN("Unknown");

        String value;

        private Status(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }
    }
}

