/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.operator.api.v1.model.apicurioregistryspec;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.apicurio.registry.operator.api.v1.model.apicurioregistryspec.deployment.Affinity;
import io.apicurio.registry.operator.api.v1.model.apicurioregistryspec.deployment.ImagePullSecrets;
import io.apicurio.registry.operator.api.v1.model.apicurioregistryspec.deployment.ManagedResources;
import io.apicurio.registry.operator.api.v1.model.apicurioregistryspec.deployment.Metadata;
import io.apicurio.registry.operator.api.v1.model.apicurioregistryspec.deployment.PodTemplateSpecPreview;
import io.apicurio.registry.operator.api.v1.model.apicurioregistryspec.deployment.Tolerations;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import java.util.List;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"affinity", "host", "image", "imagePullSecrets", "managedResources", "metadata", "podTemplateSpecPreview", "replicas", "tolerations"})
@JsonDeserialize(using=JsonDeserializer.None.class)
public class Deployment
implements KubernetesResource {
    @JsonProperty(value="affinity")
    @JsonPropertyDescription(value="Affinity")
    @JsonSetter(nulls=Nulls.SKIP)
    private Affinity affinity;
    @JsonProperty(value="host")
    @JsonPropertyDescription(value="Hostname: \n Apicurio Registry application hostname (part of the URL without the protocol and path).")
    @JsonSetter(nulls=Nulls.SKIP)
    private String host;
    @JsonProperty(value="image")
    @JsonPropertyDescription(value="Apicurio Registry image: \n Replaces the default Apicurio Registry application image. Overrides the values in the REGISTRY_IMAGE_MEM, REGISTRY_IMAGE_KAFKASQL and REGISTRY_IMAGE_SQL Operator environment variables.")
    @JsonSetter(nulls=Nulls.SKIP)
    private String image;
    @JsonProperty(value="imagePullSecrets")
    @JsonPropertyDescription(value="Apicurio Registry image pull secrets: \n List of Secrets to use when pulling the Apicurio Registry image.")
    @JsonSetter(nulls=Nulls.SKIP)
    private List<ImagePullSecrets> imagePullSecrets;
    @JsonProperty(value="managedResources")
    @JsonPropertyDescription(value="Apicurio Registry managed resources: \n Configure how the Operator manages Kubernetes resources.")
    @JsonSetter(nulls=Nulls.SKIP)
    private ManagedResources managedResources;
    @JsonProperty(value="metadata")
    @JsonPropertyDescription(value="Metadata of the Apicurio Registry pod")
    @JsonSetter(nulls=Nulls.SKIP)
    private Metadata metadata;
    @JsonProperty(value="podTemplateSpecPreview")
    @JsonSetter(nulls=Nulls.SKIP)
    private PodTemplateSpecPreview podTemplateSpecPreview;
    @JsonProperty(value="replicas")
    @JsonPropertyDescription(value="Replicas: \n The required number of Apicurio Registry pods. Default value is 1.")
    @JsonSetter(nulls=Nulls.SKIP)
    private Integer replicas;
    @JsonProperty(value="tolerations")
    @JsonPropertyDescription(value="Tolerations")
    @JsonSetter(nulls=Nulls.SKIP)
    private List<Tolerations> tolerations;

    public Affinity getAffinity() {
        return this.affinity;
    }

    public void setAffinity(Affinity affinity) {
        this.affinity = affinity;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getImage() {
        return this.image;
    }

    public void setImage(String image) {
        this.image = image;
    }

    public List<ImagePullSecrets> getImagePullSecrets() {
        return this.imagePullSecrets;
    }

    public void setImagePullSecrets(List<ImagePullSecrets> imagePullSecrets) {
        this.imagePullSecrets = imagePullSecrets;
    }

    public ManagedResources getManagedResources() {
        return this.managedResources;
    }

    public void setManagedResources(ManagedResources managedResources) {
        this.managedResources = managedResources;
    }

    public Metadata getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Metadata metadata) {
        this.metadata = metadata;
    }

    public PodTemplateSpecPreview getPodTemplateSpecPreview() {
        return this.podTemplateSpecPreview;
    }

    public void setPodTemplateSpecPreview(PodTemplateSpecPreview podTemplateSpecPreview) {
        this.podTemplateSpecPreview = podTemplateSpecPreview;
    }

    public Integer getReplicas() {
        return this.replicas;
    }

    public void setReplicas(Integer replicas) {
        this.replicas = replicas;
    }

    public List<Tolerations> getTolerations() {
        return this.tolerations;
    }

    public void setTolerations(List<Tolerations> tolerations) {
        this.tolerations = tolerations;
    }

    public String toString() {
        return "Deployment(affinity=" + this.getAffinity() + ", host=" + this.getHost() + ", image=" + this.getImage() + ", imagePullSecrets=" + this.getImagePullSecrets() + ", managedResources=" + this.getManagedResources() + ", metadata=" + this.getMetadata() + ", podTemplateSpecPreview=" + this.getPodTemplateSpecPreview() + ", replicas=" + this.getReplicas() + ", tolerations=" + this.getTolerations() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Deployment)) {
            return false;
        }
        Deployment other = (Deployment)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$replicas = this.getReplicas();
        Integer other$replicas = other.getReplicas();
        if (this$replicas == null ? other$replicas != null : !((Object)this$replicas).equals(other$replicas)) {
            return false;
        }
        Affinity this$affinity = this.getAffinity();
        Affinity other$affinity = other.getAffinity();
        if (this$affinity == null ? other$affinity != null : !((Object)this$affinity).equals(other$affinity)) {
            return false;
        }
        String this$host = this.getHost();
        String other$host = other.getHost();
        if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
            return false;
        }
        String this$image = this.getImage();
        String other$image = other.getImage();
        if (this$image == null ? other$image != null : !this$image.equals(other$image)) {
            return false;
        }
        List<ImagePullSecrets> this$imagePullSecrets = this.getImagePullSecrets();
        List<ImagePullSecrets> other$imagePullSecrets = other.getImagePullSecrets();
        if (this$imagePullSecrets == null ? other$imagePullSecrets != null : !((Object)this$imagePullSecrets).equals(other$imagePullSecrets)) {
            return false;
        }
        ManagedResources this$managedResources = this.getManagedResources();
        ManagedResources other$managedResources = other.getManagedResources();
        if (this$managedResources == null ? other$managedResources != null : !((Object)this$managedResources).equals(other$managedResources)) {
            return false;
        }
        Metadata this$metadata = this.getMetadata();
        Metadata other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
            return false;
        }
        PodTemplateSpecPreview this$podTemplateSpecPreview = this.getPodTemplateSpecPreview();
        PodTemplateSpecPreview other$podTemplateSpecPreview = other.getPodTemplateSpecPreview();
        if (this$podTemplateSpecPreview == null ? other$podTemplateSpecPreview != null : !((Object)this$podTemplateSpecPreview).equals(other$podTemplateSpecPreview)) {
            return false;
        }
        List<Tolerations> this$tolerations = this.getTolerations();
        List<Tolerations> other$tolerations = other.getTolerations();
        return !(this$tolerations == null ? other$tolerations != null : !((Object)this$tolerations).equals(other$tolerations));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Deployment;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $replicas = this.getReplicas();
        result = result * 59 + ($replicas == null ? 43 : ((Object)$replicas).hashCode());
        Affinity $affinity = this.getAffinity();
        result = result * 59 + ($affinity == null ? 43 : ((Object)$affinity).hashCode());
        String $host = this.getHost();
        result = result * 59 + ($host == null ? 43 : $host.hashCode());
        String $image = this.getImage();
        result = result * 59 + ($image == null ? 43 : $image.hashCode());
        List<ImagePullSecrets> $imagePullSecrets = this.getImagePullSecrets();
        result = result * 59 + ($imagePullSecrets == null ? 43 : ((Object)$imagePullSecrets).hashCode());
        ManagedResources $managedResources = this.getManagedResources();
        result = result * 59 + ($managedResources == null ? 43 : ((Object)$managedResources).hashCode());
        Metadata $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        PodTemplateSpecPreview $podTemplateSpecPreview = this.getPodTemplateSpecPreview();
        result = result * 59 + ($podTemplateSpecPreview == null ? 43 : ((Object)$podTemplateSpecPreview).hashCode());
        List<Tolerations> $tolerations = this.getTolerations();
        result = result * 59 + ($tolerations == null ? 43 : ((Object)$tolerations).hashCode());
        return result;
    }
}

