/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.operator.api.v1.model.apicurioregistryspec.deployment.podtemplatespecpreview.spec;

import io.apicurio.registry.operator.api.v1.model.apicurioregistryspec.deployment.podtemplatespecpreview.spec.DnsConfig;
import io.apicurio.registry.operator.api.v1.model.apicurioregistryspec.deployment.podtemplatespecpreview.spec.dnsconfig.Options;
import io.apicurio.registry.operator.api.v1.model.apicurioregistryspec.deployment.podtemplatespecpreview.spec.dnsconfig.OptionsBuilder;
import io.apicurio.registry.operator.api.v1.model.apicurioregistryspec.deployment.podtemplatespecpreview.spec.dnsconfig.OptionsFluent;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class DnsConfigFluent<A extends DnsConfigFluent<A>>
extends BaseFluent<A> {
    private List<String> nameservers;
    private ArrayList<OptionsBuilder> options;
    private List<String> searches;

    public DnsConfigFluent() {
    }

    public DnsConfigFluent(DnsConfig instance) {
        DnsConfig dnsConfig = instance = instance != null ? instance : new DnsConfig();
        if (instance != null) {
            this.withNameservers(instance.getNameservers());
            this.withOptions(instance.getOptions());
            this.withSearches(instance.getSearches());
        }
    }

    public A addToNameservers(int index, String item) {
        if (this.nameservers == null) {
            this.nameservers = new ArrayList<String>();
        }
        this.nameservers.add(index, item);
        return (A)((Object)this);
    }

    public A setToNameservers(int index, String item) {
        if (this.nameservers == null) {
            this.nameservers = new ArrayList<String>();
        }
        this.nameservers.set(index, item);
        return (A)((Object)this);
    }

    public A addToNameservers(String ... items) {
        if (this.nameservers == null) {
            this.nameservers = new ArrayList<String>();
        }
        for (String item : items) {
            this.nameservers.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToNameservers(Collection<String> items) {
        if (this.nameservers == null) {
            this.nameservers = new ArrayList<String>();
        }
        for (String item : items) {
            this.nameservers.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromNameservers(String ... items) {
        if (this.nameservers == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.nameservers.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromNameservers(Collection<String> items) {
        if (this.nameservers == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.nameservers.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getNameservers() {
        return this.nameservers;
    }

    public String getNameserver(int index) {
        return this.nameservers.get(index);
    }

    public String getFirstNameserver() {
        return this.nameservers.get(0);
    }

    public String getLastNameserver() {
        return this.nameservers.get(this.nameservers.size() - 1);
    }

    public String getMatchingNameserver(Predicate<String> predicate) {
        for (String item : this.nameservers) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingNameserver(Predicate<String> predicate) {
        for (String item : this.nameservers) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withNameservers(List<String> nameservers) {
        if (nameservers != null) {
            this.nameservers = new ArrayList<String>();
            for (String item : nameservers) {
                this.addToNameservers(item);
            }
        } else {
            this.nameservers = null;
        }
        return (A)((Object)this);
    }

    public A withNameservers(String ... nameservers) {
        if (this.nameservers != null) {
            this.nameservers.clear();
            this._visitables.remove((Object)"nameservers");
        }
        if (nameservers != null) {
            for (String item : nameservers) {
                this.addToNameservers(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasNameservers() {
        return this.nameservers != null && !this.nameservers.isEmpty();
    }

    public A addToOptions(int index, Options item) {
        if (this.options == null) {
            this.options = new ArrayList();
        }
        OptionsBuilder builder = new OptionsBuilder(item);
        if (index < 0 || index >= this.options.size()) {
            this._visitables.get((Object)"options").add(builder);
            this.options.add(builder);
        } else {
            this._visitables.get((Object)"options").add(index, builder);
            this.options.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToOptions(int index, Options item) {
        if (this.options == null) {
            this.options = new ArrayList();
        }
        OptionsBuilder builder = new OptionsBuilder(item);
        if (index < 0 || index >= this.options.size()) {
            this._visitables.get((Object)"options").add(builder);
            this.options.add(builder);
        } else {
            this._visitables.get((Object)"options").set(index, builder);
            this.options.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToOptions(Options ... items) {
        if (this.options == null) {
            this.options = new ArrayList();
        }
        for (Options item : items) {
            OptionsBuilder builder = new OptionsBuilder(item);
            this._visitables.get((Object)"options").add(builder);
            this.options.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToOptions(Collection<Options> items) {
        if (this.options == null) {
            this.options = new ArrayList();
        }
        for (Options item : items) {
            OptionsBuilder builder = new OptionsBuilder(item);
            this._visitables.get((Object)"options").add(builder);
            this.options.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromOptions(Options ... items) {
        if (this.options == null) {
            return (A)((Object)this);
        }
        for (Options item : items) {
            OptionsBuilder builder = new OptionsBuilder(item);
            this._visitables.get((Object)"options").remove((Object)builder);
            this.options.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromOptions(Collection<Options> items) {
        if (this.options == null) {
            return (A)((Object)this);
        }
        for (Options item : items) {
            OptionsBuilder builder = new OptionsBuilder(item);
            this._visitables.get((Object)"options").remove((Object)builder);
            this.options.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromOptions(Predicate<OptionsBuilder> predicate) {
        if (this.options == null) {
            return (A)((Object)this);
        }
        Iterator<OptionsBuilder> each = this.options.iterator();
        List visitables = this._visitables.get((Object)"options");
        while (each.hasNext()) {
            OptionsBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<Options> buildOptions() {
        return this.options != null ? DnsConfigFluent.build(this.options) : null;
    }

    public Options buildOption(int index) {
        return this.options.get(index).build();
    }

    public Options buildFirstOption() {
        return this.options.get(0).build();
    }

    public Options buildLastOption() {
        return this.options.get(this.options.size() - 1).build();
    }

    public Options buildMatchingOption(Predicate<OptionsBuilder> predicate) {
        for (OptionsBuilder item : this.options) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingOption(Predicate<OptionsBuilder> predicate) {
        for (OptionsBuilder item : this.options) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withOptions(List<Options> options) {
        if (this.options != null) {
            this._visitables.get((Object)"options").clear();
        }
        if (options != null) {
            this.options = new ArrayList();
            for (Options item : options) {
                this.addToOptions(item);
            }
        } else {
            this.options = null;
        }
        return (A)((Object)this);
    }

    public A withOptions(Options ... options) {
        if (this.options != null) {
            this.options.clear();
            this._visitables.remove((Object)"options");
        }
        if (options != null) {
            for (Options item : options) {
                this.addToOptions(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasOptions() {
        return this.options != null && !this.options.isEmpty();
    }

    public OptionsNested<A> addNewOption() {
        return new OptionsNested(-1, null);
    }

    public OptionsNested<A> addNewOptionLike(Options item) {
        return new OptionsNested(-1, item);
    }

    public OptionsNested<A> setNewOptionLike(int index, Options item) {
        return new OptionsNested(index, item);
    }

    public OptionsNested<A> editOption(int index) {
        if (this.options.size() <= index) {
            throw new RuntimeException("Can't edit options. Index exceeds size.");
        }
        return this.setNewOptionLike(index, this.buildOption(index));
    }

    public OptionsNested<A> editFirstOption() {
        if (this.options.size() == 0) {
            throw new RuntimeException("Can't edit first options. The list is empty.");
        }
        return this.setNewOptionLike(0, this.buildOption(0));
    }

    public OptionsNested<A> editLastOption() {
        int index = this.options.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last options. The list is empty.");
        }
        return this.setNewOptionLike(index, this.buildOption(index));
    }

    public OptionsNested<A> editMatchingOption(Predicate<OptionsBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.options.size(); ++i) {
            if (!predicate.test(this.options.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching options. No match found.");
        }
        return this.setNewOptionLike(index, this.buildOption(index));
    }

    public A addToSearches(int index, String item) {
        if (this.searches == null) {
            this.searches = new ArrayList<String>();
        }
        this.searches.add(index, item);
        return (A)((Object)this);
    }

    public A setToSearches(int index, String item) {
        if (this.searches == null) {
            this.searches = new ArrayList<String>();
        }
        this.searches.set(index, item);
        return (A)((Object)this);
    }

    public A addToSearches(String ... items) {
        if (this.searches == null) {
            this.searches = new ArrayList<String>();
        }
        for (String item : items) {
            this.searches.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToSearches(Collection<String> items) {
        if (this.searches == null) {
            this.searches = new ArrayList<String>();
        }
        for (String item : items) {
            this.searches.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromSearches(String ... items) {
        if (this.searches == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.searches.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromSearches(Collection<String> items) {
        if (this.searches == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.searches.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getSearches() {
        return this.searches;
    }

    public String getSearch(int index) {
        return this.searches.get(index);
    }

    public String getFirstSearch() {
        return this.searches.get(0);
    }

    public String getLastSearch() {
        return this.searches.get(this.searches.size() - 1);
    }

    public String getMatchingSearch(Predicate<String> predicate) {
        for (String item : this.searches) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingSearch(Predicate<String> predicate) {
        for (String item : this.searches) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withSearches(List<String> searches) {
        if (searches != null) {
            this.searches = new ArrayList<String>();
            for (String item : searches) {
                this.addToSearches(item);
            }
        } else {
            this.searches = null;
        }
        return (A)((Object)this);
    }

    public A withSearches(String ... searches) {
        if (this.searches != null) {
            this.searches.clear();
            this._visitables.remove((Object)"searches");
        }
        if (searches != null) {
            for (String item : searches) {
                this.addToSearches(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasSearches() {
        return this.searches != null && !this.searches.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DnsConfigFluent that = (DnsConfigFluent)((Object)o);
        if (!Objects.equals(this.nameservers, that.nameservers)) {
            return false;
        }
        if (!Objects.equals(this.options, that.options)) {
            return false;
        }
        return Objects.equals(this.searches, that.searches);
    }

    public int hashCode() {
        return Objects.hash(this.nameservers, this.options, this.searches, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.nameservers != null && !this.nameservers.isEmpty()) {
            sb.append("nameservers:");
            sb.append(this.nameservers + ",");
        }
        if (this.options != null && !this.options.isEmpty()) {
            sb.append("options:");
            sb.append(this.options + ",");
        }
        if (this.searches != null && !this.searches.isEmpty()) {
            sb.append("searches:");
            sb.append(this.searches);
        }
        sb.append("}");
        return sb.toString();
    }

    public class OptionsNested<N>
    extends OptionsFluent<OptionsNested<N>>
    implements Nested<N> {
        OptionsBuilder builder;
        int index;

        OptionsNested(int index, Options item) {
            this.index = index;
            this.builder = new OptionsBuilder(this, item);
        }

        public N and() {
            return (N)DnsConfigFluent.this.setToOptions(this.index, this.builder.build());
        }

        public N endOption() {
            return this.and();
        }
    }
}

