/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.operator.api.v1.model.apicurioregistryspec.deployment.podtemplatespecpreview.spec.volumes;

import io.apicurio.registry.operator.api.v1.model.apicurioregistryspec.deployment.podtemplatespecpreview.spec.volumes.Iscsi;
import io.apicurio.registry.operator.api.v1.model.apicurioregistryspec.deployment.podtemplatespecpreview.spec.volumes.iscsi.SecretRef;
import io.apicurio.registry.operator.api.v1.model.apicurioregistryspec.deployment.podtemplatespecpreview.spec.volumes.iscsi.SecretRefBuilder;
import io.apicurio.registry.operator.api.v1.model.apicurioregistryspec.deployment.podtemplatespecpreview.spec.volumes.iscsi.SecretRefFluent;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class IscsiFluent<A extends IscsiFluent<A>>
extends BaseFluent<A> {
    private Boolean chapAuthDiscovery;
    private Boolean chapAuthSession;
    private String fsType;
    private String initiatorName;
    private String iqn;
    private String iscsiInterface;
    private Integer lun;
    private List<String> portals;
    private Boolean readOnly;
    private SecretRefBuilder secretRef;
    private String targetPortal;

    public IscsiFluent() {
    }

    public IscsiFluent(Iscsi instance) {
        Iscsi iscsi = instance = instance != null ? instance : new Iscsi();
        if (instance != null) {
            this.withChapAuthDiscovery(instance.getChapAuthDiscovery());
            this.withChapAuthSession(instance.getChapAuthSession());
            this.withFsType(instance.getFsType());
            this.withInitiatorName(instance.getInitiatorName());
            this.withIqn(instance.getIqn());
            this.withIscsiInterface(instance.getIscsiInterface());
            this.withLun(instance.getLun());
            this.withPortals(instance.getPortals());
            this.withReadOnly(instance.getReadOnly());
            this.withSecretRef(instance.getSecretRef());
            this.withTargetPortal(instance.getTargetPortal());
        }
    }

    public Boolean getChapAuthDiscovery() {
        return this.chapAuthDiscovery;
    }

    public A withChapAuthDiscovery(Boolean chapAuthDiscovery) {
        this.chapAuthDiscovery = chapAuthDiscovery;
        return (A)((Object)this);
    }

    public boolean hasChapAuthDiscovery() {
        return this.chapAuthDiscovery != null;
    }

    public Boolean getChapAuthSession() {
        return this.chapAuthSession;
    }

    public A withChapAuthSession(Boolean chapAuthSession) {
        this.chapAuthSession = chapAuthSession;
        return (A)((Object)this);
    }

    public boolean hasChapAuthSession() {
        return this.chapAuthSession != null;
    }

    public String getFsType() {
        return this.fsType;
    }

    public A withFsType(String fsType) {
        this.fsType = fsType;
        return (A)((Object)this);
    }

    public boolean hasFsType() {
        return this.fsType != null;
    }

    public String getInitiatorName() {
        return this.initiatorName;
    }

    public A withInitiatorName(String initiatorName) {
        this.initiatorName = initiatorName;
        return (A)((Object)this);
    }

    public boolean hasInitiatorName() {
        return this.initiatorName != null;
    }

    public String getIqn() {
        return this.iqn;
    }

    public A withIqn(String iqn) {
        this.iqn = iqn;
        return (A)((Object)this);
    }

    public boolean hasIqn() {
        return this.iqn != null;
    }

    public String getIscsiInterface() {
        return this.iscsiInterface;
    }

    public A withIscsiInterface(String iscsiInterface) {
        this.iscsiInterface = iscsiInterface;
        return (A)((Object)this);
    }

    public boolean hasIscsiInterface() {
        return this.iscsiInterface != null;
    }

    public Integer getLun() {
        return this.lun;
    }

    public A withLun(Integer lun) {
        this.lun = lun;
        return (A)((Object)this);
    }

    public boolean hasLun() {
        return this.lun != null;
    }

    public A addToPortals(int index, String item) {
        if (this.portals == null) {
            this.portals = new ArrayList<String>();
        }
        this.portals.add(index, item);
        return (A)((Object)this);
    }

    public A setToPortals(int index, String item) {
        if (this.portals == null) {
            this.portals = new ArrayList<String>();
        }
        this.portals.set(index, item);
        return (A)((Object)this);
    }

    public A addToPortals(String ... items) {
        if (this.portals == null) {
            this.portals = new ArrayList<String>();
        }
        for (String item : items) {
            this.portals.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToPortals(Collection<String> items) {
        if (this.portals == null) {
            this.portals = new ArrayList<String>();
        }
        for (String item : items) {
            this.portals.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromPortals(String ... items) {
        if (this.portals == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.portals.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromPortals(Collection<String> items) {
        if (this.portals == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.portals.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getPortals() {
        return this.portals;
    }

    public String getPortal(int index) {
        return this.portals.get(index);
    }

    public String getFirstPortal() {
        return this.portals.get(0);
    }

    public String getLastPortal() {
        return this.portals.get(this.portals.size() - 1);
    }

    public String getMatchingPortal(Predicate<String> predicate) {
        for (String item : this.portals) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingPortal(Predicate<String> predicate) {
        for (String item : this.portals) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withPortals(List<String> portals) {
        if (portals != null) {
            this.portals = new ArrayList<String>();
            for (String item : portals) {
                this.addToPortals(item);
            }
        } else {
            this.portals = null;
        }
        return (A)((Object)this);
    }

    public A withPortals(String ... portals) {
        if (this.portals != null) {
            this.portals.clear();
            this._visitables.remove((Object)"portals");
        }
        if (portals != null) {
            for (String item : portals) {
                this.addToPortals(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasPortals() {
        return this.portals != null && !this.portals.isEmpty();
    }

    public Boolean getReadOnly() {
        return this.readOnly;
    }

    public A withReadOnly(Boolean readOnly) {
        this.readOnly = readOnly;
        return (A)((Object)this);
    }

    public boolean hasReadOnly() {
        return this.readOnly != null;
    }

    public SecretRef buildSecretRef() {
        return this.secretRef != null ? this.secretRef.build() : null;
    }

    public A withSecretRef(SecretRef secretRef) {
        this._visitables.get((Object)"secretRef").remove((Object)this.secretRef);
        if (secretRef != null) {
            this.secretRef = new SecretRefBuilder(secretRef);
            this._visitables.get((Object)"secretRef").add(this.secretRef);
        } else {
            this.secretRef = null;
            this._visitables.get((Object)"secretRef").remove((Object)this.secretRef);
        }
        return (A)((Object)this);
    }

    public boolean hasSecretRef() {
        return this.secretRef != null;
    }

    public IscsiSecretRefNested<A> withNewIscsiSecretRef() {
        return new IscsiSecretRefNested(null);
    }

    public IscsiSecretRefNested<A> withNewSecretRefLike(SecretRef item) {
        return new IscsiSecretRefNested(item);
    }

    public IscsiSecretRefNested<A> editIscsiSecretRef() {
        return this.withNewSecretRefLike(Optional.ofNullable(this.buildSecretRef()).orElse(null));
    }

    public IscsiSecretRefNested<A> editOrNewSecretRef() {
        return this.withNewSecretRefLike(Optional.ofNullable(this.buildSecretRef()).orElse(new SecretRefBuilder().build()));
    }

    public IscsiSecretRefNested<A> editOrNewSecretRefLike(SecretRef item) {
        return this.withNewSecretRefLike(Optional.ofNullable(this.buildSecretRef()).orElse(item));
    }

    public String getTargetPortal() {
        return this.targetPortal;
    }

    public A withTargetPortal(String targetPortal) {
        this.targetPortal = targetPortal;
        return (A)((Object)this);
    }

    public boolean hasTargetPortal() {
        return this.targetPortal != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        IscsiFluent that = (IscsiFluent)((Object)o);
        if (!Objects.equals(this.chapAuthDiscovery, that.chapAuthDiscovery)) {
            return false;
        }
        if (!Objects.equals(this.chapAuthSession, that.chapAuthSession)) {
            return false;
        }
        if (!Objects.equals(this.fsType, that.fsType)) {
            return false;
        }
        if (!Objects.equals(this.initiatorName, that.initiatorName)) {
            return false;
        }
        if (!Objects.equals(this.iqn, that.iqn)) {
            return false;
        }
        if (!Objects.equals(this.iscsiInterface, that.iscsiInterface)) {
            return false;
        }
        if (!Objects.equals(this.lun, that.lun)) {
            return false;
        }
        if (!Objects.equals(this.portals, that.portals)) {
            return false;
        }
        if (!Objects.equals(this.readOnly, that.readOnly)) {
            return false;
        }
        if (!Objects.equals((Object)this.secretRef, (Object)that.secretRef)) {
            return false;
        }
        return Objects.equals(this.targetPortal, that.targetPortal);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.chapAuthDiscovery, this.chapAuthSession, this.fsType, this.initiatorName, this.iqn, this.iscsiInterface, this.lun, this.portals, this.readOnly, this.secretRef, this.targetPortal, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.chapAuthDiscovery != null) {
            sb.append("chapAuthDiscovery:");
            sb.append(this.chapAuthDiscovery + ",");
        }
        if (this.chapAuthSession != null) {
            sb.append("chapAuthSession:");
            sb.append(this.chapAuthSession + ",");
        }
        if (this.fsType != null) {
            sb.append("fsType:");
            sb.append(this.fsType + ",");
        }
        if (this.initiatorName != null) {
            sb.append("initiatorName:");
            sb.append(this.initiatorName + ",");
        }
        if (this.iqn != null) {
            sb.append("iqn:");
            sb.append(this.iqn + ",");
        }
        if (this.iscsiInterface != null) {
            sb.append("iscsiInterface:");
            sb.append(this.iscsiInterface + ",");
        }
        if (this.lun != null) {
            sb.append("lun:");
            sb.append(this.lun + ",");
        }
        if (this.portals != null && !this.portals.isEmpty()) {
            sb.append("portals:");
            sb.append(this.portals + ",");
        }
        if (this.readOnly != null) {
            sb.append("readOnly:");
            sb.append(this.readOnly + ",");
        }
        if (this.secretRef != null) {
            sb.append("secretRef:");
            sb.append(this.secretRef + ",");
        }
        if (this.targetPortal != null) {
            sb.append("targetPortal:");
            sb.append(this.targetPortal);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withChapAuthDiscovery() {
        return this.withChapAuthDiscovery(true);
    }

    public A withChapAuthSession() {
        return this.withChapAuthSession(true);
    }

    public A withReadOnly() {
        return this.withReadOnly(true);
    }

    public class IscsiSecretRefNested<N>
    extends SecretRefFluent<IscsiSecretRefNested<N>>
    implements Nested<N> {
        SecretRefBuilder builder;

        IscsiSecretRefNested(SecretRef item) {
            this.builder = new SecretRefBuilder(this, item);
        }

        public N and() {
            return (N)IscsiFluent.this.withSecretRef(this.builder.build());
        }

        public N endIscsiSecretRef() {
            return this.and();
        }
    }
}

