/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.operator.api.v1.model.apicurioregistryspec.deployment.podtemplatespecpreview.spec.volumes;

import io.apicurio.registry.operator.api.v1.model.apicurioregistryspec.deployment.podtemplatespecpreview.spec.volumes.Rbd;
import io.apicurio.registry.operator.api.v1.model.apicurioregistryspec.deployment.podtemplatespecpreview.spec.volumes.rbd.SecretRef;
import io.apicurio.registry.operator.api.v1.model.apicurioregistryspec.deployment.podtemplatespecpreview.spec.volumes.rbd.SecretRefBuilder;
import io.apicurio.registry.operator.api.v1.model.apicurioregistryspec.deployment.podtemplatespecpreview.spec.volumes.rbd.SecretRefFluent;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class RbdFluent<A extends RbdFluent<A>>
extends BaseFluent<A> {
    private String fsType;
    private String image;
    private String keyring;
    private List<String> monitors;
    private String pool;
    private Boolean readOnly;
    private SecretRefBuilder secretRef;
    private String user;

    public RbdFluent() {
    }

    public RbdFluent(Rbd instance) {
        Rbd rbd = instance = instance != null ? instance : new Rbd();
        if (instance != null) {
            this.withFsType(instance.getFsType());
            this.withImage(instance.getImage());
            this.withKeyring(instance.getKeyring());
            this.withMonitors(instance.getMonitors());
            this.withPool(instance.getPool());
            this.withReadOnly(instance.getReadOnly());
            this.withSecretRef(instance.getSecretRef());
            this.withUser(instance.getUser());
        }
    }

    public String getFsType() {
        return this.fsType;
    }

    public A withFsType(String fsType) {
        this.fsType = fsType;
        return (A)((Object)this);
    }

    public boolean hasFsType() {
        return this.fsType != null;
    }

    public String getImage() {
        return this.image;
    }

    public A withImage(String image) {
        this.image = image;
        return (A)((Object)this);
    }

    public boolean hasImage() {
        return this.image != null;
    }

    public String getKeyring() {
        return this.keyring;
    }

    public A withKeyring(String keyring) {
        this.keyring = keyring;
        return (A)((Object)this);
    }

    public boolean hasKeyring() {
        return this.keyring != null;
    }

    public A addToMonitors(int index, String item) {
        if (this.monitors == null) {
            this.monitors = new ArrayList<String>();
        }
        this.monitors.add(index, item);
        return (A)((Object)this);
    }

    public A setToMonitors(int index, String item) {
        if (this.monitors == null) {
            this.monitors = new ArrayList<String>();
        }
        this.monitors.set(index, item);
        return (A)((Object)this);
    }

    public A addToMonitors(String ... items) {
        if (this.monitors == null) {
            this.monitors = new ArrayList<String>();
        }
        for (String item : items) {
            this.monitors.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToMonitors(Collection<String> items) {
        if (this.monitors == null) {
            this.monitors = new ArrayList<String>();
        }
        for (String item : items) {
            this.monitors.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromMonitors(String ... items) {
        if (this.monitors == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.monitors.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromMonitors(Collection<String> items) {
        if (this.monitors == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.monitors.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getMonitors() {
        return this.monitors;
    }

    public String getMonitor(int index) {
        return this.monitors.get(index);
    }

    public String getFirstMonitor() {
        return this.monitors.get(0);
    }

    public String getLastMonitor() {
        return this.monitors.get(this.monitors.size() - 1);
    }

    public String getMatchingMonitor(Predicate<String> predicate) {
        for (String item : this.monitors) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingMonitor(Predicate<String> predicate) {
        for (String item : this.monitors) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withMonitors(List<String> monitors) {
        if (monitors != null) {
            this.monitors = new ArrayList<String>();
            for (String item : monitors) {
                this.addToMonitors(item);
            }
        } else {
            this.monitors = null;
        }
        return (A)((Object)this);
    }

    public A withMonitors(String ... monitors) {
        if (this.monitors != null) {
            this.monitors.clear();
            this._visitables.remove((Object)"monitors");
        }
        if (monitors != null) {
            for (String item : monitors) {
                this.addToMonitors(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasMonitors() {
        return this.monitors != null && !this.monitors.isEmpty();
    }

    public String getPool() {
        return this.pool;
    }

    public A withPool(String pool) {
        this.pool = pool;
        return (A)((Object)this);
    }

    public boolean hasPool() {
        return this.pool != null;
    }

    public Boolean getReadOnly() {
        return this.readOnly;
    }

    public A withReadOnly(Boolean readOnly) {
        this.readOnly = readOnly;
        return (A)((Object)this);
    }

    public boolean hasReadOnly() {
        return this.readOnly != null;
    }

    public SecretRef buildSecretRef() {
        return this.secretRef != null ? this.secretRef.build() : null;
    }

    public A withSecretRef(SecretRef secretRef) {
        this._visitables.get((Object)"secretRef").remove((Object)this.secretRef);
        if (secretRef != null) {
            this.secretRef = new SecretRefBuilder(secretRef);
            this._visitables.get((Object)"secretRef").add(this.secretRef);
        } else {
            this.secretRef = null;
            this._visitables.get((Object)"secretRef").remove((Object)this.secretRef);
        }
        return (A)((Object)this);
    }

    public boolean hasSecretRef() {
        return this.secretRef != null;
    }

    public RbdSecretRefNested<A> withNewRbdSecretRef() {
        return new RbdSecretRefNested(null);
    }

    public RbdSecretRefNested<A> withNewSecretRefLike(SecretRef item) {
        return new RbdSecretRefNested(item);
    }

    public RbdSecretRefNested<A> editRbdSecretRef() {
        return this.withNewSecretRefLike(Optional.ofNullable(this.buildSecretRef()).orElse(null));
    }

    public RbdSecretRefNested<A> editOrNewSecretRef() {
        return this.withNewSecretRefLike(Optional.ofNullable(this.buildSecretRef()).orElse(new SecretRefBuilder().build()));
    }

    public RbdSecretRefNested<A> editOrNewSecretRefLike(SecretRef item) {
        return this.withNewSecretRefLike(Optional.ofNullable(this.buildSecretRef()).orElse(item));
    }

    public String getUser() {
        return this.user;
    }

    public A withUser(String user) {
        this.user = user;
        return (A)((Object)this);
    }

    public boolean hasUser() {
        return this.user != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RbdFluent that = (RbdFluent)((Object)o);
        if (!Objects.equals(this.fsType, that.fsType)) {
            return false;
        }
        if (!Objects.equals(this.image, that.image)) {
            return false;
        }
        if (!Objects.equals(this.keyring, that.keyring)) {
            return false;
        }
        if (!Objects.equals(this.monitors, that.monitors)) {
            return false;
        }
        if (!Objects.equals(this.pool, that.pool)) {
            return false;
        }
        if (!Objects.equals(this.readOnly, that.readOnly)) {
            return false;
        }
        if (!Objects.equals((Object)this.secretRef, (Object)that.secretRef)) {
            return false;
        }
        return Objects.equals(this.user, that.user);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.fsType, this.image, this.keyring, this.monitors, this.pool, this.readOnly, this.secretRef, this.user, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.fsType != null) {
            sb.append("fsType:");
            sb.append(this.fsType + ",");
        }
        if (this.image != null) {
            sb.append("image:");
            sb.append(this.image + ",");
        }
        if (this.keyring != null) {
            sb.append("keyring:");
            sb.append(this.keyring + ",");
        }
        if (this.monitors != null && !this.monitors.isEmpty()) {
            sb.append("monitors:");
            sb.append(this.monitors + ",");
        }
        if (this.pool != null) {
            sb.append("pool:");
            sb.append(this.pool + ",");
        }
        if (this.readOnly != null) {
            sb.append("readOnly:");
            sb.append(this.readOnly + ",");
        }
        if (this.secretRef != null) {
            sb.append("secretRef:");
            sb.append(this.secretRef + ",");
        }
        if (this.user != null) {
            sb.append("user:");
            sb.append(this.user);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withReadOnly() {
        return this.withReadOnly(true);
    }

    public class RbdSecretRefNested<N>
    extends SecretRefFluent<RbdSecretRefNested<N>>
    implements Nested<N> {
        SecretRefBuilder builder;

        RbdSecretRefNested(SecretRef item) {
            this.builder = new SecretRefBuilder(this, item);
        }

        public N and() {
            return (N)RbdFluent.this.withSecretRef(this.builder.build());
        }

        public N endRbdSecretRef() {
            return this.and();
        }
    }
}

