package io.apicurio.registry.operator.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Long;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class ApicurioRegistryListFluentImpl<A extends io.apicurio.registry.operator.api.model.ApicurioRegistryListFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.apicurio.registry.operator.api.model.ApicurioRegistryListFluent<A> {

    private java.lang.String kind;
    private java.lang.String apiVersion;
    private io.fabric8.kubernetes.api.model.ListMeta metadata;
    private java.util.List<io.apicurio.registry.operator.api.model.ApicurioRegistryBuilder> items;

    public ApicurioRegistryListFluentImpl() {
    }

    public ApicurioRegistryListFluentImpl(io.apicurio.registry.operator.api.model.ApicurioRegistryList instance) {
        this.withKind(instance.getKind()); 
        this.withApiVersion(instance.getApiVersion()); 
        this.withMetadata(instance.getMetadata());
        
        this.withItems(instance.getItems());
    }

    public java.lang.String getKind() {
        return this.kind;
    }

    public A withKind(java.lang.String kind) {
        this.kind=kind; return (A) this;
    }

    public java.lang.Boolean hasKind() {
        return this.kind != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withKind instead.
     */
        public A withNewKind(java.lang.String original) {
        return (A)withKind(new String(original));
    }

    public java.lang.String getApiVersion() {
        return this.apiVersion;
    }

    public A withApiVersion(java.lang.String apiVersion) {
        this.apiVersion=apiVersion; return (A) this;
    }

    public java.lang.Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withApiVersion instead.
     */
        public A withNewApiVersion(java.lang.String original) {
        return (A)withApiVersion(new String(original));
    }

    public io.fabric8.kubernetes.api.model.ListMeta getMetadata() {
        return this.metadata;
    }

    public A withMetadata(io.fabric8.kubernetes.api.model.ListMeta metadata) {
        this.metadata=metadata; return (A) this;
    }

    public java.lang.Boolean hasMetadata() {
        return this.metadata != null;
    }

    public A withNewMetadata(java.lang.String _continue,java.lang.Long remainingItemCount,java.lang.String resourceVersion,java.lang.String selfLink) {
        return (A)withMetadata(new ListMeta(_continue, remainingItemCount, resourceVersion, selfLink));
    }

    public A addToItems(int index,io.apicurio.registry.operator.api.model.ApicurioRegistry item) {
        if (this.items == null) {this.items = new java.util.ArrayList<io.apicurio.registry.operator.api.model.ApicurioRegistryBuilder>();}
        io.apicurio.registry.operator.api.model.ApicurioRegistryBuilder builder = new io.apicurio.registry.operator.api.model.ApicurioRegistryBuilder(item);_visitables.get("items").add(index >= 0 ? index : _visitables.get("items").size(), builder);this.items.add(index >= 0 ? index : items.size(), builder); return (A)this;
    }

    public A setToItems(int index,io.apicurio.registry.operator.api.model.ApicurioRegistry item) {
        if (this.items == null) {this.items = new java.util.ArrayList<io.apicurio.registry.operator.api.model.ApicurioRegistryBuilder>();}
        io.apicurio.registry.operator.api.model.ApicurioRegistryBuilder builder = new io.apicurio.registry.operator.api.model.ApicurioRegistryBuilder(item);
        if (index < 0 || index >= _visitables.get("items").size()) { _visitables.get("items").add(builder); } else { _visitables.get("items").set(index, builder);}
        if (index < 0 || index >= items.size()) { items.add(builder); } else { items.set(index, builder);}
         return (A)this;
    }

    public A addToItems(io.apicurio.registry.operator.api.model.ApicurioRegistry... items) {
        if (this.items == null) {this.items = new java.util.ArrayList<io.apicurio.registry.operator.api.model.ApicurioRegistryBuilder>();}
        for (io.apicurio.registry.operator.api.model.ApicurioRegistry item : items) {io.apicurio.registry.operator.api.model.ApicurioRegistryBuilder builder = new io.apicurio.registry.operator.api.model.ApicurioRegistryBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
    }

    public A addAllToItems(java.util.Collection<io.apicurio.registry.operator.api.model.ApicurioRegistry> items) {
        if (this.items == null) {this.items = new java.util.ArrayList<io.apicurio.registry.operator.api.model.ApicurioRegistryBuilder>();}
        for (io.apicurio.registry.operator.api.model.ApicurioRegistry item : items) {io.apicurio.registry.operator.api.model.ApicurioRegistryBuilder builder = new io.apicurio.registry.operator.api.model.ApicurioRegistryBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
    }

    public A removeFromItems(io.apicurio.registry.operator.api.model.ApicurioRegistry... items) {
        for (io.apicurio.registry.operator.api.model.ApicurioRegistry item : items) {io.apicurio.registry.operator.api.model.ApicurioRegistryBuilder builder = new io.apicurio.registry.operator.api.model.ApicurioRegistryBuilder(item);_visitables.get("items").remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
    }

    public A removeAllFromItems(java.util.Collection<io.apicurio.registry.operator.api.model.ApicurioRegistry> items) {
        for (io.apicurio.registry.operator.api.model.ApicurioRegistry item : items) {io.apicurio.registry.operator.api.model.ApicurioRegistryBuilder builder = new io.apicurio.registry.operator.api.model.ApicurioRegistryBuilder(item);_visitables.get("items").remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromItems(java.util.function.Predicate<io.apicurio.registry.operator.api.model.ApicurioRegistryBuilder> predicate) {
        if (items == null) return (A) this;
        final Iterator<io.apicurio.registry.operator.api.model.ApicurioRegistryBuilder> each = items.iterator();
        final List visitables = _visitables.get("items");
        while (each.hasNext()) {
          io.apicurio.registry.operator.api.model.ApicurioRegistryBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildItems instead.
     * @return The buildable object.
     */
        public java.util.List<io.apicurio.registry.operator.api.model.ApicurioRegistry> getItems() {
        return build(items);
    }

    public java.util.List<io.apicurio.registry.operator.api.model.ApicurioRegistry> buildItems() {
        return build(items);
    }

    public io.apicurio.registry.operator.api.model.ApicurioRegistry buildItem(int index) {
        return this.items.get(index).build();
    }

    public io.apicurio.registry.operator.api.model.ApicurioRegistry buildFirstItem() {
        return this.items.get(0).build();
    }

    public io.apicurio.registry.operator.api.model.ApicurioRegistry buildLastItem() {
        return this.items.get(items.size() - 1).build();
    }

    public io.apicurio.registry.operator.api.model.ApicurioRegistry buildMatchingItem(java.util.function.Predicate<io.apicurio.registry.operator.api.model.ApicurioRegistryBuilder> predicate) {
        for (io.apicurio.registry.operator.api.model.ApicurioRegistryBuilder item: items) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public java.lang.Boolean hasMatchingItem(java.util.function.Predicate<io.apicurio.registry.operator.api.model.ApicurioRegistryBuilder> predicate) {
        for (io.apicurio.registry.operator.api.model.ApicurioRegistryBuilder item: items) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withItems(java.util.List<io.apicurio.registry.operator.api.model.ApicurioRegistry> items) {
        if (this.items != null) { _visitables.get("items").removeAll(this.items);}
        if (items != null) {this.items = new java.util.ArrayList<io.apicurio.registry.operator.api.model.ApicurioRegistryBuilder>(); for (io.apicurio.registry.operator.api.model.ApicurioRegistry item : items){this.addToItems(item);}} else { this.items = null;} return (A) this;
    }

    public A withItems(io.apicurio.registry.operator.api.model.ApicurioRegistry... items) {
        if (this.items != null) {this.items.clear();}
        if (items != null) {for (io.apicurio.registry.operator.api.model.ApicurioRegistry item :items){ this.addToItems(item);}} return (A) this;
    }

    public java.lang.Boolean hasItems() {
        return items != null && !items.isEmpty();
    }

    public io.apicurio.registry.operator.api.model.ApicurioRegistryListFluent.ItemsNested<A> addNewItem() {
        return new io.apicurio.registry.operator.api.model.ApicurioRegistryListFluentImpl.ItemsNestedImpl();
    }

    public io.apicurio.registry.operator.api.model.ApicurioRegistryListFluent.ItemsNested<A> addNewItemLike(io.apicurio.registry.operator.api.model.ApicurioRegistry item) {
        return new io.apicurio.registry.operator.api.model.ApicurioRegistryListFluentImpl.ItemsNestedImpl(-1, item);
    }

    public io.apicurio.registry.operator.api.model.ApicurioRegistryListFluent.ItemsNested<A> setNewItemLike(int index,io.apicurio.registry.operator.api.model.ApicurioRegistry item) {
        return new io.apicurio.registry.operator.api.model.ApicurioRegistryListFluentImpl.ItemsNestedImpl(index, item);
    }

    public io.apicurio.registry.operator.api.model.ApicurioRegistryListFluent.ItemsNested<A> editItem(int index) {
        if (items.size() <= index) throw new RuntimeException("Can't edit items. Index exceeds size.");
        return setNewItemLike(index, buildItem(index));
    }

    public io.apicurio.registry.operator.api.model.ApicurioRegistryListFluent.ItemsNested<A> editFirstItem() {
        if (items.size() == 0) throw new RuntimeException("Can't edit first items. The list is empty.");
        return setNewItemLike(0, buildItem(0));
    }

    public io.apicurio.registry.operator.api.model.ApicurioRegistryListFluent.ItemsNested<A> editLastItem() {
        int index = items.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last items. The list is empty.");
        return setNewItemLike(index, buildItem(index));
    }

    public io.apicurio.registry.operator.api.model.ApicurioRegistryListFluent.ItemsNested<A> editMatchingItem(java.util.function.Predicate<io.apicurio.registry.operator.api.model.ApicurioRegistryBuilder> predicate) {
        int index = -1;
        for (int i=0;i<items.size();i++) { 
        if (predicate.test(items.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching items. No match found.");
        return setNewItemLike(index, buildItem(index));
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        ApicurioRegistryListFluentImpl that = (ApicurioRegistryListFluentImpl) o;
        if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
        if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
        if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
        if (items != null ? !items.equals(that.items) :that.items != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(kind,  apiVersion,  metadata,  items,  super.hashCode());
    }

    public class ItemsNestedImpl<N> extends io.apicurio.registry.operator.api.model.ApicurioRegistryFluentImpl<io.apicurio.registry.operator.api.model.ApicurioRegistryListFluent.ItemsNested<N>> implements io.apicurio.registry.operator.api.model.ApicurioRegistryListFluent.ItemsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.apicurio.registry.operator.api.model.ApicurioRegistryBuilder builder;
        private final int index;

            ItemsNestedImpl(int index,io.apicurio.registry.operator.api.model.ApicurioRegistry item) {
                this.index = index;
                this.builder = new io.apicurio.registry.operator.api.model.ApicurioRegistryBuilder(this, item);
                        
            }

            ItemsNestedImpl() {
                this.index = -1;
                this.builder = new io.apicurio.registry.operator.api.model.ApicurioRegistryBuilder(this);
                        
            }

            public N and() {
                return (N) ApicurioRegistryListFluentImpl.this.setToItems(index,builder.build());
            }

            public N endItem() {
                return and();
            }
    }


}
