package io.apicurio.registry.operator.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ApicurioRegistrySpecConfigurationBuilder extends io.apicurio.registry.operator.api.model.ApicurioRegistrySpecConfigurationFluentImpl<io.apicurio.registry.operator.api.model.ApicurioRegistrySpecConfigurationBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.apicurio.registry.operator.api.model.ApicurioRegistrySpecConfiguration,io.apicurio.registry.operator.api.model.ApicurioRegistrySpecConfigurationBuilder> {

    io.apicurio.registry.operator.api.model.ApicurioRegistrySpecConfigurationFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public ApicurioRegistrySpecConfigurationBuilder() {
        this(true);
    }

    public ApicurioRegistrySpecConfigurationBuilder(java.lang.Boolean validationEnabled) {
        this(new ApicurioRegistrySpecConfiguration(), validationEnabled);
    }

    public ApicurioRegistrySpecConfigurationBuilder(io.apicurio.registry.operator.api.model.ApicurioRegistrySpecConfigurationFluent<?> fluent) {
        this(fluent, true);
    }

    public ApicurioRegistrySpecConfigurationBuilder(io.apicurio.registry.operator.api.model.ApicurioRegistrySpecConfigurationFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new ApicurioRegistrySpecConfiguration(), validationEnabled);
    }

    public ApicurioRegistrySpecConfigurationBuilder(io.apicurio.registry.operator.api.model.ApicurioRegistrySpecConfigurationFluent<?> fluent,io.apicurio.registry.operator.api.model.ApicurioRegistrySpecConfiguration instance) {
        this(fluent, instance, true);
    }

    public ApicurioRegistrySpecConfigurationBuilder(io.apicurio.registry.operator.api.model.ApicurioRegistrySpecConfigurationFluent<?> fluent,io.apicurio.registry.operator.api.model.ApicurioRegistrySpecConfiguration instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withPersistence(instance.getPersistence());
        
        fluent.withSql(instance.getSql());
        
        fluent.withKafkasql(instance.getKafkasql());
        
        fluent.withUi(instance.getUi());
        
        fluent.withLogLevel(instance.getLogLevel());
        
        fluent.withSecurity(instance.getSecurity());
        
        this.validationEnabled = validationEnabled; 
    }

    public ApicurioRegistrySpecConfigurationBuilder(io.apicurio.registry.operator.api.model.ApicurioRegistrySpecConfiguration instance) {
        this(instance,true);
    }

    public ApicurioRegistrySpecConfigurationBuilder(io.apicurio.registry.operator.api.model.ApicurioRegistrySpecConfiguration instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withPersistence(instance.getPersistence());
        
        this.withSql(instance.getSql());
        
        this.withKafkasql(instance.getKafkasql());
        
        this.withUi(instance.getUi());
        
        this.withLogLevel(instance.getLogLevel());
        
        this.withSecurity(instance.getSecurity());
        
        this.validationEnabled = validationEnabled; 
    }

    public io.apicurio.registry.operator.api.model.ApicurioRegistrySpecConfiguration build() {
        ApicurioRegistrySpecConfiguration buildable = new ApicurioRegistrySpecConfiguration();
        buildable.setPersistence(fluent.getPersistence());
        buildable.setSql(fluent.getSql());
        buildable.setKafkasql(fluent.getKafkasql());
        buildable.setUi(fluent.getUi());
        buildable.setLogLevel(fluent.getLogLevel());
        buildable.setSecurity(fluent.getSecurity());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ApicurioRegistrySpecConfigurationBuilder that = (ApicurioRegistrySpecConfigurationBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
