package io.apicurio.registry.operator.api.v1.model;

import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.EnvVar;
import java.util.List;
import java.lang.Boolean;
import java.util.Collection;
import java.lang.Object;

public class ApicurioRegistrySpecConfigurationFluentImpl<A extends io.apicurio.registry.operator.api.v1.model.ApicurioRegistrySpecConfigurationFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.apicurio.registry.operator.api.v1.model.ApicurioRegistrySpecConfigurationFluent<A> {

    private java.lang.String persistence;
    private io.apicurio.registry.operator.api.v1.model.ApicurioRegistrySpecConfigurationSqlBuilder sql;
    private io.apicurio.registry.operator.api.v1.model.ApicurioRegistrySpecConfigurationKafkasqlBuilder kafkasql;
    private io.apicurio.registry.operator.api.v1.model.ApicurioRegistrySpecConfigurationUIBuilder ui;
    private java.lang.String logLevel;
    private java.lang.String registryLogLevel;
    private io.apicurio.registry.operator.api.v1.model.ApicurioRegistrySpecConfigurationSecurityBuilder security;
    private java.util.List<io.fabric8.kubernetes.api.model.EnvVar> env;

    public ApicurioRegistrySpecConfigurationFluentImpl() {
    }

    public ApicurioRegistrySpecConfigurationFluentImpl(io.apicurio.registry.operator.api.v1.model.ApicurioRegistrySpecConfiguration instance) {
        this.withPersistence(instance.getPersistence());
        
        this.withSql(instance.getSql());
        
        this.withKafkasql(instance.getKafkasql());
        
        this.withUi(instance.getUi());
        
        this.withLogLevel(instance.getLogLevel());
        
        this.withRegistryLogLevel(instance.getRegistryLogLevel());
        
        this.withSecurity(instance.getSecurity());
        
        this.withEnv(instance.getEnv());
    }

    public java.lang.String getPersistence() {
        return this.persistence;
    }

    public A withPersistence(java.lang.String persistence) {
        this.persistence=persistence; return (A) this;
    }

    public java.lang.Boolean hasPersistence() {
        return this.persistence != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withPersistence instead.
     */
        public A withNewPersistence(java.lang.String original) {
        return (A)withPersistence(new String(original));
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildSql instead.
     * @return The buildable object.
     */
        public io.apicurio.registry.operator.api.v1.model.ApicurioRegistrySpecConfigurationSql getSql() {
        return this.sql!=null?this.sql.build():null;
    }

    public io.apicurio.registry.operator.api.v1.model.ApicurioRegistrySpecConfigurationSql buildSql() {
        return this.sql!=null?this.sql.build():null;
    }

    public A withSql(io.apicurio.registry.operator.api.v1.model.ApicurioRegistrySpecConfigurationSql sql) {
        _visitables.get("sql").remove(this.sql);
        if (sql!=null){ this.sql= new io.apicurio.registry.operator.api.v1.model.ApicurioRegistrySpecConfigurationSqlBuilder(sql); _visitables.get("sql").add(this.sql);} return (A) this;
    }

    public java.lang.Boolean hasSql() {
        return this.sql != null;
    }

    public io.apicurio.registry.operator.api.v1.model.ApicurioRegistrySpecConfigurationFluent.SqlNested<A> withNewSql() {
        return new io.apicurio.registry.operator.api.v1.model.ApicurioRegistrySpecConfigurationFluentImpl.SqlNestedImpl();
    }

    public io.apicurio.registry.operator.api.v1.model.ApicurioRegistrySpecConfigurationFluent.SqlNested<A> withNewSqlLike(io.apicurio.registry.operator.api.v1.model.ApicurioRegistrySpecConfigurationSql item) {
        return new io.apicurio.registry.operator.api.v1.model.ApicurioRegistrySpecConfigurationFluentImpl.SqlNestedImpl(item);
    }

    public io.apicurio.registry.operator.api.v1.model.ApicurioRegistrySpecConfigurationFluent.SqlNested<A> editSql() {
        return withNewSqlLike(getSql());
    }

    public io.apicurio.registry.operator.api.v1.model.ApicurioRegistrySpecConfigurationFluent.SqlNested<A> editOrNewSql() {
        return withNewSqlLike(getSql() != null ? getSql(): new io.apicurio.registry.operator.api.v1.model.ApicurioRegistrySpecConfigurationSqlBuilder().build());
    }

    public io.apicurio.registry.operator.api.v1.model.ApicurioRegistrySpecConfigurationFluent.SqlNested<A> editOrNewSqlLike(io.apicurio.registry.operator.api.v1.model.ApicurioRegistrySpecConfigurationSql item) {
        return withNewSqlLike(getSql() != null ? getSql(): item);
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildKafkasql instead.
     * @return The buildable object.
     */
        public io.apicurio.registry.operator.api.v1.model.ApicurioRegistrySpecConfigurationKafkasql getKafkasql() {
        return this.kafkasql!=null?this.kafkasql.build():null;
    }

    public io.apicurio.registry.operator.api.v1.model.ApicurioRegistrySpecConfigurationKafkasql buildKafkasql() {
        return this.kafkasql!=null?this.kafkasql.build():null;
    }

    public A withKafkasql(io.apicurio.registry.operator.api.v1.model.ApicurioRegistrySpecConfigurationKafkasql kafkasql) {
        _visitables.get("kafkasql").remove(this.kafkasql);
        if (kafkasql!=null){ this.kafkasql= new io.apicurio.registry.operator.api.v1.model.ApicurioRegistrySpecConfigurationKafkasqlBuilder(kafkasql); _visitables.get("kafkasql").add(this.kafkasql);} return (A) this;
    }

    public java.lang.Boolean hasKafkasql() {
        return this.kafkasql != null;
    }

    public io.apicurio.registry.operator.api.v1.model.ApicurioRegistrySpecConfigurationFluent.KafkasqlNested<A> withNewKafkasql() {
        return new io.apicurio.registry.operator.api.v1.model.ApicurioRegistrySpecConfigurationFluentImpl.KafkasqlNestedImpl();
    }

    public io.apicurio.registry.operator.api.v1.model.ApicurioRegistrySpecConfigurationFluent.KafkasqlNested<A> withNewKafkasqlLike(io.apicurio.registry.operator.api.v1.model.ApicurioRegistrySpecConfigurationKafkasql item) {
        return new io.apicurio.registry.operator.api.v1.model.ApicurioRegistrySpecConfigurationFluentImpl.KafkasqlNestedImpl(item);
    }

    public io.apicurio.registry.operator.api.v1.model.ApicurioRegistrySpecConfigurationFluent.KafkasqlNested<A> editKafkasql() {
        return withNewKafkasqlLike(getKafkasql());
    }

    public io.apicurio.registry.operator.api.v1.model.ApicurioRegistrySpecConfigurationFluent.KafkasqlNested<A> editOrNewKafkasql() {
        return withNewKafkasqlLike(getKafkasql() != null ? getKafkasql(): new io.apicurio.registry.operator.api.v1.model.ApicurioRegistrySpecConfigurationKafkasqlBuilder().build());
    }

    public io.apicurio.registry.operator.api.v1.model.ApicurioRegistrySpecConfigurationFluent.KafkasqlNested<A> editOrNewKafkasqlLike(io.apicurio.registry.operator.api.v1.model.ApicurioRegistrySpecConfigurationKafkasql item) {
        return withNewKafkasqlLike(getKafkasql() != null ? getKafkasql(): item);
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildUi instead.
     * @return The buildable object.
     */
        public io.apicurio.registry.operator.api.v1.model.ApicurioRegistrySpecConfigurationUI getUi() {
        return this.ui!=null?this.ui.build():null;
    }

    public io.apicurio.registry.operator.api.v1.model.ApicurioRegistrySpecConfigurationUI buildUi() {
        return this.ui!=null?this.ui.build():null;
    }

    public A withUi(io.apicurio.registry.operator.api.v1.model.ApicurioRegistrySpecConfigurationUI ui) {
        _visitables.get("ui").remove(this.ui);
        if (ui!=null){ this.ui= new io.apicurio.registry.operator.api.v1.model.ApicurioRegistrySpecConfigurationUIBuilder(ui); _visitables.get("ui").add(this.ui);} return (A) this;
    }

    public java.lang.Boolean hasUi() {
        return this.ui != null;
    }

    public io.apicurio.registry.operator.api.v1.model.ApicurioRegistrySpecConfigurationFluent.UiNested<A> withNewUi() {
        return new io.apicurio.registry.operator.api.v1.model.ApicurioRegistrySpecConfigurationFluentImpl.UiNestedImpl();
    }

    public io.apicurio.registry.operator.api.v1.model.ApicurioRegistrySpecConfigurationFluent.UiNested<A> withNewUiLike(io.apicurio.registry.operator.api.v1.model.ApicurioRegistrySpecConfigurationUI item) {
        return new io.apicurio.registry.operator.api.v1.model.ApicurioRegistrySpecConfigurationFluentImpl.UiNestedImpl(item);
    }

    public io.apicurio.registry.operator.api.v1.model.ApicurioRegistrySpecConfigurationFluent.UiNested<A> editUi() {
        return withNewUiLike(getUi());
    }

    public io.apicurio.registry.operator.api.v1.model.ApicurioRegistrySpecConfigurationFluent.UiNested<A> editOrNewUi() {
        return withNewUiLike(getUi() != null ? getUi(): new io.apicurio.registry.operator.api.v1.model.ApicurioRegistrySpecConfigurationUIBuilder().build());
    }

    public io.apicurio.registry.operator.api.v1.model.ApicurioRegistrySpecConfigurationFluent.UiNested<A> editOrNewUiLike(io.apicurio.registry.operator.api.v1.model.ApicurioRegistrySpecConfigurationUI item) {
        return withNewUiLike(getUi() != null ? getUi(): item);
    }

    public java.lang.String getLogLevel() {
        return this.logLevel;
    }

    public A withLogLevel(java.lang.String logLevel) {
        this.logLevel=logLevel; return (A) this;
    }

    public java.lang.Boolean hasLogLevel() {
        return this.logLevel != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withLogLevel instead.
     */
        public A withNewLogLevel(java.lang.String original) {
        return (A)withLogLevel(new String(original));
    }

    public java.lang.String getRegistryLogLevel() {
        return this.registryLogLevel;
    }

    public A withRegistryLogLevel(java.lang.String registryLogLevel) {
        this.registryLogLevel=registryLogLevel; return (A) this;
    }

    public java.lang.Boolean hasRegistryLogLevel() {
        return this.registryLogLevel != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withRegistryLogLevel instead.
     */
        public A withNewRegistryLogLevel(java.lang.String original) {
        return (A)withRegistryLogLevel(new String(original));
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildSecurity instead.
     * @return The buildable object.
     */
        public io.apicurio.registry.operator.api.v1.model.ApicurioRegistrySpecConfigurationSecurity getSecurity() {
        return this.security!=null?this.security.build():null;
    }

    public io.apicurio.registry.operator.api.v1.model.ApicurioRegistrySpecConfigurationSecurity buildSecurity() {
        return this.security!=null?this.security.build():null;
    }

    public A withSecurity(io.apicurio.registry.operator.api.v1.model.ApicurioRegistrySpecConfigurationSecurity security) {
        _visitables.get("security").remove(this.security);
        if (security!=null){ this.security= new io.apicurio.registry.operator.api.v1.model.ApicurioRegistrySpecConfigurationSecurityBuilder(security); _visitables.get("security").add(this.security);} return (A) this;
    }

    public java.lang.Boolean hasSecurity() {
        return this.security != null;
    }

    public io.apicurio.registry.operator.api.v1.model.ApicurioRegistrySpecConfigurationFluent.SecurityNested<A> withNewSecurity() {
        return new io.apicurio.registry.operator.api.v1.model.ApicurioRegistrySpecConfigurationFluentImpl.SecurityNestedImpl();
    }

    public io.apicurio.registry.operator.api.v1.model.ApicurioRegistrySpecConfigurationFluent.SecurityNested<A> withNewSecurityLike(io.apicurio.registry.operator.api.v1.model.ApicurioRegistrySpecConfigurationSecurity item) {
        return new io.apicurio.registry.operator.api.v1.model.ApicurioRegistrySpecConfigurationFluentImpl.SecurityNestedImpl(item);
    }

    public io.apicurio.registry.operator.api.v1.model.ApicurioRegistrySpecConfigurationFluent.SecurityNested<A> editSecurity() {
        return withNewSecurityLike(getSecurity());
    }

    public io.apicurio.registry.operator.api.v1.model.ApicurioRegistrySpecConfigurationFluent.SecurityNested<A> editOrNewSecurity() {
        return withNewSecurityLike(getSecurity() != null ? getSecurity(): new io.apicurio.registry.operator.api.v1.model.ApicurioRegistrySpecConfigurationSecurityBuilder().build());
    }

    public io.apicurio.registry.operator.api.v1.model.ApicurioRegistrySpecConfigurationFluent.SecurityNested<A> editOrNewSecurityLike(io.apicurio.registry.operator.api.v1.model.ApicurioRegistrySpecConfigurationSecurity item) {
        return withNewSecurityLike(getSecurity() != null ? getSecurity(): item);
    }

    public A addToEnv(int index,io.fabric8.kubernetes.api.model.EnvVar item) {
        if (this.env == null) {this.env = new java.util.ArrayList<io.fabric8.kubernetes.api.model.EnvVar>();}
        this.env.add(index, item);
        return (A)this;
    }

    public A setToEnv(int index,io.fabric8.kubernetes.api.model.EnvVar item) {
        if (this.env == null) {this.env = new java.util.ArrayList<io.fabric8.kubernetes.api.model.EnvVar>();}
        this.env.set(index, item); return (A)this;
    }

    public A addToEnv(io.fabric8.kubernetes.api.model.EnvVar... items) {
        if (this.env == null) {this.env = new java.util.ArrayList<io.fabric8.kubernetes.api.model.EnvVar>();}
        for (io.fabric8.kubernetes.api.model.EnvVar item : items) {this.env.add(item);} return (A)this;
    }

    public A addAllToEnv(java.util.Collection<io.fabric8.kubernetes.api.model.EnvVar> items) {
        if (this.env == null) {this.env = new java.util.ArrayList<io.fabric8.kubernetes.api.model.EnvVar>();}
        for (io.fabric8.kubernetes.api.model.EnvVar item : items) {this.env.add(item);} return (A)this;
    }

    public A removeFromEnv(io.fabric8.kubernetes.api.model.EnvVar... items) {
        for (io.fabric8.kubernetes.api.model.EnvVar item : items) {if (this.env!= null){ this.env.remove(item);}} return (A)this;
    }

    public A removeAllFromEnv(java.util.Collection<io.fabric8.kubernetes.api.model.EnvVar> items) {
        for (io.fabric8.kubernetes.api.model.EnvVar item : items) {if (this.env!= null){ this.env.remove(item);}} return (A)this;
    }

    public java.util.List<io.fabric8.kubernetes.api.model.EnvVar> getEnv() {
        return this.env;
    }

    public io.fabric8.kubernetes.api.model.EnvVar getEnv(int index) {
        return this.env.get(index);
    }

    public io.fabric8.kubernetes.api.model.EnvVar getFirstEnv() {
        return this.env.get(0);
    }

    public io.fabric8.kubernetes.api.model.EnvVar getLastEnv() {
        return this.env.get(env.size() - 1);
    }

    public io.fabric8.kubernetes.api.model.EnvVar getMatchingEnv(java.util.function.Predicate<io.fabric8.kubernetes.api.model.EnvVar> predicate) {
        for (io.fabric8.kubernetes.api.model.EnvVar item: env) { if(predicate.test(item)){ return item;} } return null;
    }

    public java.lang.Boolean hasMatchingEnv(java.util.function.Predicate<io.fabric8.kubernetes.api.model.EnvVar> predicate) {
        for (io.fabric8.kubernetes.api.model.EnvVar item: env) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withEnv(java.util.List<io.fabric8.kubernetes.api.model.EnvVar> env) {
        if (this.env != null) { _visitables.get("env").removeAll(this.env);}
        if (env != null) {this.env = new java.util.ArrayList<io.fabric8.kubernetes.api.model.EnvVar>(); for (io.fabric8.kubernetes.api.model.EnvVar item : env){this.addToEnv(item);}} else { this.env = null;} return (A) this;
    }

    public A withEnv(io.fabric8.kubernetes.api.model.EnvVar... env) {
        if (this.env != null) {this.env.clear();}
        if (env != null) {for (io.fabric8.kubernetes.api.model.EnvVar item :env){ this.addToEnv(item);}} return (A) this;
    }

    public java.lang.Boolean hasEnv() {
        return env != null && !env.isEmpty();
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        ApicurioRegistrySpecConfigurationFluentImpl that = (ApicurioRegistrySpecConfigurationFluentImpl) o;
        if (persistence != null ? !persistence.equals(that.persistence) :that.persistence != null) return false;
        if (sql != null ? !sql.equals(that.sql) :that.sql != null) return false;
        if (kafkasql != null ? !kafkasql.equals(that.kafkasql) :that.kafkasql != null) return false;
        if (ui != null ? !ui.equals(that.ui) :that.ui != null) return false;
        if (logLevel != null ? !logLevel.equals(that.logLevel) :that.logLevel != null) return false;
        if (registryLogLevel != null ? !registryLogLevel.equals(that.registryLogLevel) :that.registryLogLevel != null) return false;
        if (security != null ? !security.equals(that.security) :that.security != null) return false;
        if (env != null ? !env.equals(that.env) :that.env != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(persistence,  sql,  kafkasql,  ui,  logLevel,  registryLogLevel,  security,  env,  super.hashCode());
    }

    public class SqlNestedImpl<N> extends io.apicurio.registry.operator.api.v1.model.ApicurioRegistrySpecConfigurationSqlFluentImpl<io.apicurio.registry.operator.api.v1.model.ApicurioRegistrySpecConfigurationFluent.SqlNested<N>> implements io.apicurio.registry.operator.api.v1.model.ApicurioRegistrySpecConfigurationFluent.SqlNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.apicurio.registry.operator.api.v1.model.ApicurioRegistrySpecConfigurationSqlBuilder builder;

            SqlNestedImpl(io.apicurio.registry.operator.api.v1.model.ApicurioRegistrySpecConfigurationSql item) {
                this.builder = new io.apicurio.registry.operator.api.v1.model.ApicurioRegistrySpecConfigurationSqlBuilder(this, item);
                        
            }

            SqlNestedImpl() {
                this.builder = new io.apicurio.registry.operator.api.v1.model.ApicurioRegistrySpecConfigurationSqlBuilder(this);
                        
            }

            public N and() {
                return (N) ApicurioRegistrySpecConfigurationFluentImpl.this.withSql(builder.build());
            }

            public N endSql() {
                return and();
            }
    }


    public class KafkasqlNestedImpl<N> extends io.apicurio.registry.operator.api.v1.model.ApicurioRegistrySpecConfigurationKafkasqlFluentImpl<io.apicurio.registry.operator.api.v1.model.ApicurioRegistrySpecConfigurationFluent.KafkasqlNested<N>> implements io.apicurio.registry.operator.api.v1.model.ApicurioRegistrySpecConfigurationFluent.KafkasqlNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.apicurio.registry.operator.api.v1.model.ApicurioRegistrySpecConfigurationKafkasqlBuilder builder;

            KafkasqlNestedImpl(io.apicurio.registry.operator.api.v1.model.ApicurioRegistrySpecConfigurationKafkasql item) {
                this.builder = new io.apicurio.registry.operator.api.v1.model.ApicurioRegistrySpecConfigurationKafkasqlBuilder(this, item);
                        
            }

            KafkasqlNestedImpl() {
                this.builder = new io.apicurio.registry.operator.api.v1.model.ApicurioRegistrySpecConfigurationKafkasqlBuilder(this);
                        
            }

            public N and() {
                return (N) ApicurioRegistrySpecConfigurationFluentImpl.this.withKafkasql(builder.build());
            }

            public N endKafkasql() {
                return and();
            }
    }


    public class UiNestedImpl<N> extends io.apicurio.registry.operator.api.v1.model.ApicurioRegistrySpecConfigurationUIFluentImpl<io.apicurio.registry.operator.api.v1.model.ApicurioRegistrySpecConfigurationFluent.UiNested<N>> implements io.apicurio.registry.operator.api.v1.model.ApicurioRegistrySpecConfigurationFluent.UiNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.apicurio.registry.operator.api.v1.model.ApicurioRegistrySpecConfigurationUIBuilder builder;

            UiNestedImpl(io.apicurio.registry.operator.api.v1.model.ApicurioRegistrySpecConfigurationUI item) {
                this.builder = new io.apicurio.registry.operator.api.v1.model.ApicurioRegistrySpecConfigurationUIBuilder(this, item);
                        
            }

            UiNestedImpl() {
                this.builder = new io.apicurio.registry.operator.api.v1.model.ApicurioRegistrySpecConfigurationUIBuilder(this);
                        
            }

            public N and() {
                return (N) ApicurioRegistrySpecConfigurationFluentImpl.this.withUi(builder.build());
            }

            public N endUi() {
                return and();
            }
    }


    public class SecurityNestedImpl<N> extends io.apicurio.registry.operator.api.v1.model.ApicurioRegistrySpecConfigurationSecurityFluentImpl<io.apicurio.registry.operator.api.v1.model.ApicurioRegistrySpecConfigurationFluent.SecurityNested<N>> implements io.apicurio.registry.operator.api.v1.model.ApicurioRegistrySpecConfigurationFluent.SecurityNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.apicurio.registry.operator.api.v1.model.ApicurioRegistrySpecConfigurationSecurityBuilder builder;

            SecurityNestedImpl(io.apicurio.registry.operator.api.v1.model.ApicurioRegistrySpecConfigurationSecurity item) {
                this.builder = new io.apicurio.registry.operator.api.v1.model.ApicurioRegistrySpecConfigurationSecurityBuilder(this, item);
                        
            }

            SecurityNestedImpl() {
                this.builder = new io.apicurio.registry.operator.api.v1.model.ApicurioRegistrySpecConfigurationSecurityBuilder(this);
                        
            }

            public N and() {
                return (N) ApicurioRegistrySpecConfigurationFluentImpl.this.withSecurity(builder.build());
            }

            public N endSecurity() {
                return and();
            }
    }


}
