/*
 * Copyright 2022 Red Hat
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package io.apicurio.registry.operator.api.v1.model;

import io.fabric8.kubernetes.api.model.Affinity;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import io.fabric8.kubernetes.api.model.Toleration;
import io.sundr.builder.annotations.Buildable;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.util.List;

@Buildable(
        editableEnabled = false,
        builderPackage = Constants.FABRIC8_KUBERNETES_API
)
@EqualsAndHashCode
@ToString
// NOTE: We can not use Lombok @Getter and @Setter because it does not work with fabric8 generator.
public class ApicurioRegistrySpecDeployment {

    private Integer replicas;

    private String host;

    private Affinity affinity;

    private List<Toleration> tolerations;

    private ApicurioRegistrySpecDeploymentMetadata metadata;

    private String image;

    private List<LocalObjectReference> imagePullSecrets;

    private ApicurioRegistrySpecDeploymentManagedResources managedResources;

    private PodTemplateSpec podTemplateSpecPreview;

    public Integer getReplicas() {
        return replicas;
    }

    public void setReplicas(Integer replicas) {
        this.replicas = replicas;
    }

    public String getHost() {
        return host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public Affinity getAffinity() {
        return affinity;
    }

    public void setAffinity(Affinity affinity) {
        this.affinity = affinity;
    }

    public List<Toleration> getTolerations() {
        return tolerations;
    }

    public void setTolerations(List<Toleration> tolerations) {
        this.tolerations = tolerations;
    }

    public ApicurioRegistrySpecDeploymentMetadata getMetadata() {
        return metadata;
    }

    public void setMetadata(ApicurioRegistrySpecDeploymentMetadata metadata) {
        this.metadata = metadata;
    }

    public String getImage() {
        return image;
    }

    public void setImage(String image) {
        this.image = image;
    }

    public List<LocalObjectReference> getImagePullSecrets() {
        return imagePullSecrets;
    }

    public void setImagePullSecrets(List<LocalObjectReference> imagePullSecrets) {
        this.imagePullSecrets = imagePullSecrets;
    }

    public ApicurioRegistrySpecDeploymentManagedResources getManagedResources() {
        return managedResources;
    }

    public void setManagedResources(ApicurioRegistrySpecDeploymentManagedResources managedResources) {
        this.managedResources = managedResources;
    }

    public PodTemplateSpec getPodTemplateSpecPreview() {
        return podTemplateSpecPreview;
    }

    public void setPodTemplateSpecPreview(PodTemplateSpec podTemplateSpecPreview) {
        this.podTemplateSpecPreview = podTemplateSpecPreview;
    }
}
