package io.apicurio.registry.operator.api.v1.model;

import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.List;
import java.lang.Boolean;
import java.lang.Integer;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.model.Toleration;
import java.lang.Long;
import io.fabric8.kubernetes.api.model.Affinity;
import java.util.Collection;
import java.lang.Object;

public class ApicurioRegistrySpecDeploymentFluentImpl<A extends io.apicurio.registry.operator.api.v1.model.ApicurioRegistrySpecDeploymentFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.apicurio.registry.operator.api.v1.model.ApicurioRegistrySpecDeploymentFluent<A> {

    private java.lang.Integer replicas;
    private java.lang.String host;
    private io.fabric8.kubernetes.api.model.Affinity affinity;
    private java.util.List<io.fabric8.kubernetes.api.model.Toleration> tolerations;
    private io.apicurio.registry.operator.api.v1.model.ApicurioRegistrySpecDeploymentMetadataBuilder metadata;
    private java.lang.String image;
    private java.util.List<io.fabric8.kubernetes.api.model.LocalObjectReference> imagePullSecrets;
    private io.apicurio.registry.operator.api.v1.model.ApicurioRegistrySpecDeploymentManagedResourcesBuilder managedResources;
    private io.fabric8.kubernetes.api.model.PodTemplateSpec podTemplateSpecPreview;

    public ApicurioRegistrySpecDeploymentFluentImpl() {
    }

    public ApicurioRegistrySpecDeploymentFluentImpl(io.apicurio.registry.operator.api.v1.model.ApicurioRegistrySpecDeployment instance) {
        this.withReplicas(instance.getReplicas());
        
        this.withHost(instance.getHost());
        
        this.withAffinity(instance.getAffinity());
        
        this.withTolerations(instance.getTolerations());
        
        this.withMetadata(instance.getMetadata());
        
        this.withImage(instance.getImage());
        
        this.withImagePullSecrets(instance.getImagePullSecrets());
        
        this.withManagedResources(instance.getManagedResources());
        
        this.withPodTemplateSpecPreview(instance.getPodTemplateSpecPreview());
    }

    public java.lang.Integer getReplicas() {
        return this.replicas;
    }

    public A withReplicas(java.lang.Integer replicas) {
        this.replicas=replicas; return (A) this;
    }

    public java.lang.Boolean hasReplicas() {
        return this.replicas != null;
    }

    public java.lang.String getHost() {
        return this.host;
    }

    public A withHost(java.lang.String host) {
        this.host=host; return (A) this;
    }

    public java.lang.Boolean hasHost() {
        return this.host != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withHost instead.
     */
        public A withNewHost(java.lang.String original) {
        return (A)withHost(new String(original));
    }

    public io.fabric8.kubernetes.api.model.Affinity getAffinity() {
        return this.affinity;
    }

    public A withAffinity(io.fabric8.kubernetes.api.model.Affinity affinity) {
        this.affinity=affinity; return (A) this;
    }

    public java.lang.Boolean hasAffinity() {
        return this.affinity != null;
    }

    public A addToTolerations(int index,io.fabric8.kubernetes.api.model.Toleration item) {
        if (this.tolerations == null) {this.tolerations = new java.util.ArrayList<io.fabric8.kubernetes.api.model.Toleration>();}
        this.tolerations.add(index, item);
        return (A)this;
    }

    public A setToTolerations(int index,io.fabric8.kubernetes.api.model.Toleration item) {
        if (this.tolerations == null) {this.tolerations = new java.util.ArrayList<io.fabric8.kubernetes.api.model.Toleration>();}
        this.tolerations.set(index, item); return (A)this;
    }

    public A addToTolerations(io.fabric8.kubernetes.api.model.Toleration... items) {
        if (this.tolerations == null) {this.tolerations = new java.util.ArrayList<io.fabric8.kubernetes.api.model.Toleration>();}
        for (io.fabric8.kubernetes.api.model.Toleration item : items) {this.tolerations.add(item);} return (A)this;
    }

    public A addAllToTolerations(java.util.Collection<io.fabric8.kubernetes.api.model.Toleration> items) {
        if (this.tolerations == null) {this.tolerations = new java.util.ArrayList<io.fabric8.kubernetes.api.model.Toleration>();}
        for (io.fabric8.kubernetes.api.model.Toleration item : items) {this.tolerations.add(item);} return (A)this;
    }

    public A removeFromTolerations(io.fabric8.kubernetes.api.model.Toleration... items) {
        for (io.fabric8.kubernetes.api.model.Toleration item : items) {if (this.tolerations!= null){ this.tolerations.remove(item);}} return (A)this;
    }

    public A removeAllFromTolerations(java.util.Collection<io.fabric8.kubernetes.api.model.Toleration> items) {
        for (io.fabric8.kubernetes.api.model.Toleration item : items) {if (this.tolerations!= null){ this.tolerations.remove(item);}} return (A)this;
    }

    public java.util.List<io.fabric8.kubernetes.api.model.Toleration> getTolerations() {
        return this.tolerations;
    }

    public io.fabric8.kubernetes.api.model.Toleration getToleration(int index) {
        return this.tolerations.get(index);
    }

    public io.fabric8.kubernetes.api.model.Toleration getFirstToleration() {
        return this.tolerations.get(0);
    }

    public io.fabric8.kubernetes.api.model.Toleration getLastToleration() {
        return this.tolerations.get(tolerations.size() - 1);
    }

    public io.fabric8.kubernetes.api.model.Toleration getMatchingToleration(java.util.function.Predicate<io.fabric8.kubernetes.api.model.Toleration> predicate) {
        for (io.fabric8.kubernetes.api.model.Toleration item: tolerations) { if(predicate.test(item)){ return item;} } return null;
    }

    public java.lang.Boolean hasMatchingToleration(java.util.function.Predicate<io.fabric8.kubernetes.api.model.Toleration> predicate) {
        for (io.fabric8.kubernetes.api.model.Toleration item: tolerations) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withTolerations(java.util.List<io.fabric8.kubernetes.api.model.Toleration> tolerations) {
        if (this.tolerations != null) { _visitables.get("tolerations").removeAll(this.tolerations);}
        if (tolerations != null) {this.tolerations = new java.util.ArrayList<io.fabric8.kubernetes.api.model.Toleration>(); for (io.fabric8.kubernetes.api.model.Toleration item : tolerations){this.addToTolerations(item);}} else { this.tolerations = null;} return (A) this;
    }

    public A withTolerations(io.fabric8.kubernetes.api.model.Toleration... tolerations) {
        if (this.tolerations != null) {this.tolerations.clear();}
        if (tolerations != null) {for (io.fabric8.kubernetes.api.model.Toleration item :tolerations){ this.addToTolerations(item);}} return (A) this;
    }

    public java.lang.Boolean hasTolerations() {
        return tolerations != null && !tolerations.isEmpty();
    }

    public A addNewToleration(java.lang.String effect,java.lang.String key,java.lang.String operator,java.lang.Long tolerationSeconds,java.lang.String value) {
        return (A)addToTolerations(new Toleration(effect, key, operator, tolerationSeconds, value));
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildMetadata instead.
     * @return The buildable object.
     */
        public io.apicurio.registry.operator.api.v1.model.ApicurioRegistrySpecDeploymentMetadata getMetadata() {
        return this.metadata!=null?this.metadata.build():null;
    }

    public io.apicurio.registry.operator.api.v1.model.ApicurioRegistrySpecDeploymentMetadata buildMetadata() {
        return this.metadata!=null?this.metadata.build():null;
    }

    public A withMetadata(io.apicurio.registry.operator.api.v1.model.ApicurioRegistrySpecDeploymentMetadata metadata) {
        _visitables.get("metadata").remove(this.metadata);
        if (metadata!=null){ this.metadata= new io.apicurio.registry.operator.api.v1.model.ApicurioRegistrySpecDeploymentMetadataBuilder(metadata); _visitables.get("metadata").add(this.metadata);} return (A) this;
    }

    public java.lang.Boolean hasMetadata() {
        return this.metadata != null;
    }

    public io.apicurio.registry.operator.api.v1.model.ApicurioRegistrySpecDeploymentFluent.MetadataNested<A> withNewMetadata() {
        return new io.apicurio.registry.operator.api.v1.model.ApicurioRegistrySpecDeploymentFluentImpl.MetadataNestedImpl();
    }

    public io.apicurio.registry.operator.api.v1.model.ApicurioRegistrySpecDeploymentFluent.MetadataNested<A> withNewMetadataLike(io.apicurio.registry.operator.api.v1.model.ApicurioRegistrySpecDeploymentMetadata item) {
        return new io.apicurio.registry.operator.api.v1.model.ApicurioRegistrySpecDeploymentFluentImpl.MetadataNestedImpl(item);
    }

    public io.apicurio.registry.operator.api.v1.model.ApicurioRegistrySpecDeploymentFluent.MetadataNested<A> editMetadata() {
        return withNewMetadataLike(getMetadata());
    }

    public io.apicurio.registry.operator.api.v1.model.ApicurioRegistrySpecDeploymentFluent.MetadataNested<A> editOrNewMetadata() {
        return withNewMetadataLike(getMetadata() != null ? getMetadata(): new io.apicurio.registry.operator.api.v1.model.ApicurioRegistrySpecDeploymentMetadataBuilder().build());
    }

    public io.apicurio.registry.operator.api.v1.model.ApicurioRegistrySpecDeploymentFluent.MetadataNested<A> editOrNewMetadataLike(io.apicurio.registry.operator.api.v1.model.ApicurioRegistrySpecDeploymentMetadata item) {
        return withNewMetadataLike(getMetadata() != null ? getMetadata(): item);
    }

    public java.lang.String getImage() {
        return this.image;
    }

    public A withImage(java.lang.String image) {
        this.image=image; return (A) this;
    }

    public java.lang.Boolean hasImage() {
        return this.image != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withImage instead.
     */
        public A withNewImage(java.lang.String original) {
        return (A)withImage(new String(original));
    }

    public A addToImagePullSecrets(int index,io.fabric8.kubernetes.api.model.LocalObjectReference item) {
        if (this.imagePullSecrets == null) {this.imagePullSecrets = new java.util.ArrayList<io.fabric8.kubernetes.api.model.LocalObjectReference>();}
        this.imagePullSecrets.add(index, item);
        return (A)this;
    }

    public A setToImagePullSecrets(int index,io.fabric8.kubernetes.api.model.LocalObjectReference item) {
        if (this.imagePullSecrets == null) {this.imagePullSecrets = new java.util.ArrayList<io.fabric8.kubernetes.api.model.LocalObjectReference>();}
        this.imagePullSecrets.set(index, item); return (A)this;
    }

    public A addToImagePullSecrets(io.fabric8.kubernetes.api.model.LocalObjectReference... items) {
        if (this.imagePullSecrets == null) {this.imagePullSecrets = new java.util.ArrayList<io.fabric8.kubernetes.api.model.LocalObjectReference>();}
        for (io.fabric8.kubernetes.api.model.LocalObjectReference item : items) {this.imagePullSecrets.add(item);} return (A)this;
    }

    public A addAllToImagePullSecrets(java.util.Collection<io.fabric8.kubernetes.api.model.LocalObjectReference> items) {
        if (this.imagePullSecrets == null) {this.imagePullSecrets = new java.util.ArrayList<io.fabric8.kubernetes.api.model.LocalObjectReference>();}
        for (io.fabric8.kubernetes.api.model.LocalObjectReference item : items) {this.imagePullSecrets.add(item);} return (A)this;
    }

    public A removeFromImagePullSecrets(io.fabric8.kubernetes.api.model.LocalObjectReference... items) {
        for (io.fabric8.kubernetes.api.model.LocalObjectReference item : items) {if (this.imagePullSecrets!= null){ this.imagePullSecrets.remove(item);}} return (A)this;
    }

    public A removeAllFromImagePullSecrets(java.util.Collection<io.fabric8.kubernetes.api.model.LocalObjectReference> items) {
        for (io.fabric8.kubernetes.api.model.LocalObjectReference item : items) {if (this.imagePullSecrets!= null){ this.imagePullSecrets.remove(item);}} return (A)this;
    }

    public java.util.List<io.fabric8.kubernetes.api.model.LocalObjectReference> getImagePullSecrets() {
        return this.imagePullSecrets;
    }

    public io.fabric8.kubernetes.api.model.LocalObjectReference getImagePullSecret(int index) {
        return this.imagePullSecrets.get(index);
    }

    public io.fabric8.kubernetes.api.model.LocalObjectReference getFirstImagePullSecret() {
        return this.imagePullSecrets.get(0);
    }

    public io.fabric8.kubernetes.api.model.LocalObjectReference getLastImagePullSecret() {
        return this.imagePullSecrets.get(imagePullSecrets.size() - 1);
    }

    public io.fabric8.kubernetes.api.model.LocalObjectReference getMatchingImagePullSecret(java.util.function.Predicate<io.fabric8.kubernetes.api.model.LocalObjectReference> predicate) {
        for (io.fabric8.kubernetes.api.model.LocalObjectReference item: imagePullSecrets) { if(predicate.test(item)){ return item;} } return null;
    }

    public java.lang.Boolean hasMatchingImagePullSecret(java.util.function.Predicate<io.fabric8.kubernetes.api.model.LocalObjectReference> predicate) {
        for (io.fabric8.kubernetes.api.model.LocalObjectReference item: imagePullSecrets) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withImagePullSecrets(java.util.List<io.fabric8.kubernetes.api.model.LocalObjectReference> imagePullSecrets) {
        if (this.imagePullSecrets != null) { _visitables.get("imagePullSecrets").removeAll(this.imagePullSecrets);}
        if (imagePullSecrets != null) {this.imagePullSecrets = new java.util.ArrayList<io.fabric8.kubernetes.api.model.LocalObjectReference>(); for (io.fabric8.kubernetes.api.model.LocalObjectReference item : imagePullSecrets){this.addToImagePullSecrets(item);}} else { this.imagePullSecrets = null;} return (A) this;
    }

    public A withImagePullSecrets(io.fabric8.kubernetes.api.model.LocalObjectReference... imagePullSecrets) {
        if (this.imagePullSecrets != null) {this.imagePullSecrets.clear();}
        if (imagePullSecrets != null) {for (io.fabric8.kubernetes.api.model.LocalObjectReference item :imagePullSecrets){ this.addToImagePullSecrets(item);}} return (A) this;
    }

    public java.lang.Boolean hasImagePullSecrets() {
        return imagePullSecrets != null && !imagePullSecrets.isEmpty();
    }

    public A addNewImagePullSecret(java.lang.String name) {
        return (A)addToImagePullSecrets(new LocalObjectReference(name));
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildManagedResources instead.
     * @return The buildable object.
     */
        public io.apicurio.registry.operator.api.v1.model.ApicurioRegistrySpecDeploymentManagedResources getManagedResources() {
        return this.managedResources!=null?this.managedResources.build():null;
    }

    public io.apicurio.registry.operator.api.v1.model.ApicurioRegistrySpecDeploymentManagedResources buildManagedResources() {
        return this.managedResources!=null?this.managedResources.build():null;
    }

    public A withManagedResources(io.apicurio.registry.operator.api.v1.model.ApicurioRegistrySpecDeploymentManagedResources managedResources) {
        _visitables.get("managedResources").remove(this.managedResources);
        if (managedResources!=null){ this.managedResources= new io.apicurio.registry.operator.api.v1.model.ApicurioRegistrySpecDeploymentManagedResourcesBuilder(managedResources); _visitables.get("managedResources").add(this.managedResources);} return (A) this;
    }

    public java.lang.Boolean hasManagedResources() {
        return this.managedResources != null;
    }

    public io.apicurio.registry.operator.api.v1.model.ApicurioRegistrySpecDeploymentFluent.ManagedResourcesNested<A> withNewManagedResources() {
        return new io.apicurio.registry.operator.api.v1.model.ApicurioRegistrySpecDeploymentFluentImpl.ManagedResourcesNestedImpl();
    }

    public io.apicurio.registry.operator.api.v1.model.ApicurioRegistrySpecDeploymentFluent.ManagedResourcesNested<A> withNewManagedResourcesLike(io.apicurio.registry.operator.api.v1.model.ApicurioRegistrySpecDeploymentManagedResources item) {
        return new io.apicurio.registry.operator.api.v1.model.ApicurioRegistrySpecDeploymentFluentImpl.ManagedResourcesNestedImpl(item);
    }

    public io.apicurio.registry.operator.api.v1.model.ApicurioRegistrySpecDeploymentFluent.ManagedResourcesNested<A> editManagedResources() {
        return withNewManagedResourcesLike(getManagedResources());
    }

    public io.apicurio.registry.operator.api.v1.model.ApicurioRegistrySpecDeploymentFluent.ManagedResourcesNested<A> editOrNewManagedResources() {
        return withNewManagedResourcesLike(getManagedResources() != null ? getManagedResources(): new io.apicurio.registry.operator.api.v1.model.ApicurioRegistrySpecDeploymentManagedResourcesBuilder().build());
    }

    public io.apicurio.registry.operator.api.v1.model.ApicurioRegistrySpecDeploymentFluent.ManagedResourcesNested<A> editOrNewManagedResourcesLike(io.apicurio.registry.operator.api.v1.model.ApicurioRegistrySpecDeploymentManagedResources item) {
        return withNewManagedResourcesLike(getManagedResources() != null ? getManagedResources(): item);
    }

    public io.fabric8.kubernetes.api.model.PodTemplateSpec getPodTemplateSpecPreview() {
        return this.podTemplateSpecPreview;
    }

    public A withPodTemplateSpecPreview(io.fabric8.kubernetes.api.model.PodTemplateSpec podTemplateSpecPreview) {
        this.podTemplateSpecPreview=podTemplateSpecPreview; return (A) this;
    }

    public java.lang.Boolean hasPodTemplateSpecPreview() {
        return this.podTemplateSpecPreview != null;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        ApicurioRegistrySpecDeploymentFluentImpl that = (ApicurioRegistrySpecDeploymentFluentImpl) o;
        if (replicas != null ? !replicas.equals(that.replicas) :that.replicas != null) return false;
        if (host != null ? !host.equals(that.host) :that.host != null) return false;
        if (affinity != null ? !affinity.equals(that.affinity) :that.affinity != null) return false;
        if (tolerations != null ? !tolerations.equals(that.tolerations) :that.tolerations != null) return false;
        if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
        if (image != null ? !image.equals(that.image) :that.image != null) return false;
        if (imagePullSecrets != null ? !imagePullSecrets.equals(that.imagePullSecrets) :that.imagePullSecrets != null) return false;
        if (managedResources != null ? !managedResources.equals(that.managedResources) :that.managedResources != null) return false;
        if (podTemplateSpecPreview != null ? !podTemplateSpecPreview.equals(that.podTemplateSpecPreview) :that.podTemplateSpecPreview != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(replicas,  host,  affinity,  tolerations,  metadata,  image,  imagePullSecrets,  managedResources,  podTemplateSpecPreview,  super.hashCode());
    }

    public class MetadataNestedImpl<N> extends io.apicurio.registry.operator.api.v1.model.ApicurioRegistrySpecDeploymentMetadataFluentImpl<io.apicurio.registry.operator.api.v1.model.ApicurioRegistrySpecDeploymentFluent.MetadataNested<N>> implements io.apicurio.registry.operator.api.v1.model.ApicurioRegistrySpecDeploymentFluent.MetadataNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.apicurio.registry.operator.api.v1.model.ApicurioRegistrySpecDeploymentMetadataBuilder builder;

            MetadataNestedImpl(io.apicurio.registry.operator.api.v1.model.ApicurioRegistrySpecDeploymentMetadata item) {
                this.builder = new io.apicurio.registry.operator.api.v1.model.ApicurioRegistrySpecDeploymentMetadataBuilder(this, item);
                        
            }

            MetadataNestedImpl() {
                this.builder = new io.apicurio.registry.operator.api.v1.model.ApicurioRegistrySpecDeploymentMetadataBuilder(this);
                        
            }

            public N and() {
                return (N) ApicurioRegistrySpecDeploymentFluentImpl.this.withMetadata(builder.build());
            }

            public N endMetadata() {
                return and();
            }
    }


    public class ManagedResourcesNestedImpl<N> extends io.apicurio.registry.operator.api.v1.model.ApicurioRegistrySpecDeploymentManagedResourcesFluentImpl<io.apicurio.registry.operator.api.v1.model.ApicurioRegistrySpecDeploymentFluent.ManagedResourcesNested<N>> implements io.apicurio.registry.operator.api.v1.model.ApicurioRegistrySpecDeploymentFluent.ManagedResourcesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.apicurio.registry.operator.api.v1.model.ApicurioRegistrySpecDeploymentManagedResourcesBuilder builder;

            ManagedResourcesNestedImpl(io.apicurio.registry.operator.api.v1.model.ApicurioRegistrySpecDeploymentManagedResources item) {
                this.builder = new io.apicurio.registry.operator.api.v1.model.ApicurioRegistrySpecDeploymentManagedResourcesBuilder(this, item);
                        
            }

            ManagedResourcesNestedImpl() {
                this.builder = new io.apicurio.registry.operator.api.v1.model.ApicurioRegistrySpecDeploymentManagedResourcesBuilder(this);
                        
            }

            public N and() {
                return (N) ApicurioRegistrySpecDeploymentFluentImpl.this.withManagedResources(builder.build());
            }

            public N endManagedResources() {
                return and();
            }
    }


}
