package io.apicurio.registry.operator.api.v1.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.Condition;
import java.util.Collection;
import java.lang.Object;

public class ApicurioRegistryStatusFluentImpl<A extends io.apicurio.registry.operator.api.v1.model.ApicurioRegistryStatusFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.apicurio.registry.operator.api.v1.model.ApicurioRegistryStatusFluent<A> {

    private io.apicurio.registry.operator.api.v1.model.ApicurioRegistryStatusInfoBuilder info;
    private java.util.List<io.fabric8.kubernetes.api.model.Condition> conditions;
    private java.util.List<io.apicurio.registry.operator.api.v1.model.ApicurioRegistryStatusManagedResourceBuilder> managedResources;

    public ApicurioRegistryStatusFluentImpl() {
    }

    public ApicurioRegistryStatusFluentImpl(io.apicurio.registry.operator.api.v1.model.ApicurioRegistryStatus instance) {
        this.withInfo(instance.getInfo());
        
        this.withConditions(instance.getConditions());
        
        this.withManagedResources(instance.getManagedResources());
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildInfo instead.
     * @return The buildable object.
     */
        public io.apicurio.registry.operator.api.v1.model.ApicurioRegistryStatusInfo getInfo() {
        return this.info!=null?this.info.build():null;
    }

    public io.apicurio.registry.operator.api.v1.model.ApicurioRegistryStatusInfo buildInfo() {
        return this.info!=null?this.info.build():null;
    }

    public A withInfo(io.apicurio.registry.operator.api.v1.model.ApicurioRegistryStatusInfo info) {
        _visitables.get("info").remove(this.info);
        if (info!=null){ this.info= new io.apicurio.registry.operator.api.v1.model.ApicurioRegistryStatusInfoBuilder(info); _visitables.get("info").add(this.info);} return (A) this;
    }

    public java.lang.Boolean hasInfo() {
        return this.info != null;
    }

    public io.apicurio.registry.operator.api.v1.model.ApicurioRegistryStatusFluent.InfoNested<A> withNewInfo() {
        return new io.apicurio.registry.operator.api.v1.model.ApicurioRegistryStatusFluentImpl.InfoNestedImpl();
    }

    public io.apicurio.registry.operator.api.v1.model.ApicurioRegistryStatusFluent.InfoNested<A> withNewInfoLike(io.apicurio.registry.operator.api.v1.model.ApicurioRegistryStatusInfo item) {
        return new io.apicurio.registry.operator.api.v1.model.ApicurioRegistryStatusFluentImpl.InfoNestedImpl(item);
    }

    public io.apicurio.registry.operator.api.v1.model.ApicurioRegistryStatusFluent.InfoNested<A> editInfo() {
        return withNewInfoLike(getInfo());
    }

    public io.apicurio.registry.operator.api.v1.model.ApicurioRegistryStatusFluent.InfoNested<A> editOrNewInfo() {
        return withNewInfoLike(getInfo() != null ? getInfo(): new io.apicurio.registry.operator.api.v1.model.ApicurioRegistryStatusInfoBuilder().build());
    }

    public io.apicurio.registry.operator.api.v1.model.ApicurioRegistryStatusFluent.InfoNested<A> editOrNewInfoLike(io.apicurio.registry.operator.api.v1.model.ApicurioRegistryStatusInfo item) {
        return withNewInfoLike(getInfo() != null ? getInfo(): item);
    }

    public A addToConditions(int index,io.fabric8.kubernetes.api.model.Condition item) {
        if (this.conditions == null) {this.conditions = new java.util.ArrayList<io.fabric8.kubernetes.api.model.Condition>();}
        this.conditions.add(index, item);
        return (A)this;
    }

    public A setToConditions(int index,io.fabric8.kubernetes.api.model.Condition item) {
        if (this.conditions == null) {this.conditions = new java.util.ArrayList<io.fabric8.kubernetes.api.model.Condition>();}
        this.conditions.set(index, item); return (A)this;
    }

    public A addToConditions(io.fabric8.kubernetes.api.model.Condition... items) {
        if (this.conditions == null) {this.conditions = new java.util.ArrayList<io.fabric8.kubernetes.api.model.Condition>();}
        for (io.fabric8.kubernetes.api.model.Condition item : items) {this.conditions.add(item);} return (A)this;
    }

    public A addAllToConditions(java.util.Collection<io.fabric8.kubernetes.api.model.Condition> items) {
        if (this.conditions == null) {this.conditions = new java.util.ArrayList<io.fabric8.kubernetes.api.model.Condition>();}
        for (io.fabric8.kubernetes.api.model.Condition item : items) {this.conditions.add(item);} return (A)this;
    }

    public A removeFromConditions(io.fabric8.kubernetes.api.model.Condition... items) {
        for (io.fabric8.kubernetes.api.model.Condition item : items) {if (this.conditions!= null){ this.conditions.remove(item);}} return (A)this;
    }

    public A removeAllFromConditions(java.util.Collection<io.fabric8.kubernetes.api.model.Condition> items) {
        for (io.fabric8.kubernetes.api.model.Condition item : items) {if (this.conditions!= null){ this.conditions.remove(item);}} return (A)this;
    }

    public java.util.List<io.fabric8.kubernetes.api.model.Condition> getConditions() {
        return this.conditions;
    }

    public io.fabric8.kubernetes.api.model.Condition getCondition(int index) {
        return this.conditions.get(index);
    }

    public io.fabric8.kubernetes.api.model.Condition getFirstCondition() {
        return this.conditions.get(0);
    }

    public io.fabric8.kubernetes.api.model.Condition getLastCondition() {
        return this.conditions.get(conditions.size() - 1);
    }

    public io.fabric8.kubernetes.api.model.Condition getMatchingCondition(java.util.function.Predicate<io.fabric8.kubernetes.api.model.Condition> predicate) {
        for (io.fabric8.kubernetes.api.model.Condition item: conditions) { if(predicate.test(item)){ return item;} } return null;
    }

    public java.lang.Boolean hasMatchingCondition(java.util.function.Predicate<io.fabric8.kubernetes.api.model.Condition> predicate) {
        for (io.fabric8.kubernetes.api.model.Condition item: conditions) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withConditions(java.util.List<io.fabric8.kubernetes.api.model.Condition> conditions) {
        if (this.conditions != null) { _visitables.get("conditions").removeAll(this.conditions);}
        if (conditions != null) {this.conditions = new java.util.ArrayList<io.fabric8.kubernetes.api.model.Condition>(); for (io.fabric8.kubernetes.api.model.Condition item : conditions){this.addToConditions(item);}} else { this.conditions = null;} return (A) this;
    }

    public A withConditions(io.fabric8.kubernetes.api.model.Condition... conditions) {
        if (this.conditions != null) {this.conditions.clear();}
        if (conditions != null) {for (io.fabric8.kubernetes.api.model.Condition item :conditions){ this.addToConditions(item);}} return (A) this;
    }

    public java.lang.Boolean hasConditions() {
        return conditions != null && !conditions.isEmpty();
    }

    public A addToManagedResources(int index,io.apicurio.registry.operator.api.v1.model.ApicurioRegistryStatusManagedResource item) {
        if (this.managedResources == null) {this.managedResources = new java.util.ArrayList<io.apicurio.registry.operator.api.v1.model.ApicurioRegistryStatusManagedResourceBuilder>();}
        io.apicurio.registry.operator.api.v1.model.ApicurioRegistryStatusManagedResourceBuilder builder = new io.apicurio.registry.operator.api.v1.model.ApicurioRegistryStatusManagedResourceBuilder(item);_visitables.get("managedResources").add(index >= 0 ? index : _visitables.get("managedResources").size(), builder);this.managedResources.add(index >= 0 ? index : managedResources.size(), builder); return (A)this;
    }

    public A setToManagedResources(int index,io.apicurio.registry.operator.api.v1.model.ApicurioRegistryStatusManagedResource item) {
        if (this.managedResources == null) {this.managedResources = new java.util.ArrayList<io.apicurio.registry.operator.api.v1.model.ApicurioRegistryStatusManagedResourceBuilder>();}
        io.apicurio.registry.operator.api.v1.model.ApicurioRegistryStatusManagedResourceBuilder builder = new io.apicurio.registry.operator.api.v1.model.ApicurioRegistryStatusManagedResourceBuilder(item);
        if (index < 0 || index >= _visitables.get("managedResources").size()) { _visitables.get("managedResources").add(builder); } else { _visitables.get("managedResources").set(index, builder);}
        if (index < 0 || index >= managedResources.size()) { managedResources.add(builder); } else { managedResources.set(index, builder);}
         return (A)this;
    }

    public A addToManagedResources(io.apicurio.registry.operator.api.v1.model.ApicurioRegistryStatusManagedResource... items) {
        if (this.managedResources == null) {this.managedResources = new java.util.ArrayList<io.apicurio.registry.operator.api.v1.model.ApicurioRegistryStatusManagedResourceBuilder>();}
        for (io.apicurio.registry.operator.api.v1.model.ApicurioRegistryStatusManagedResource item : items) {io.apicurio.registry.operator.api.v1.model.ApicurioRegistryStatusManagedResourceBuilder builder = new io.apicurio.registry.operator.api.v1.model.ApicurioRegistryStatusManagedResourceBuilder(item);_visitables.get("managedResources").add(builder);this.managedResources.add(builder);} return (A)this;
    }

    public A addAllToManagedResources(java.util.Collection<io.apicurio.registry.operator.api.v1.model.ApicurioRegistryStatusManagedResource> items) {
        if (this.managedResources == null) {this.managedResources = new java.util.ArrayList<io.apicurio.registry.operator.api.v1.model.ApicurioRegistryStatusManagedResourceBuilder>();}
        for (io.apicurio.registry.operator.api.v1.model.ApicurioRegistryStatusManagedResource item : items) {io.apicurio.registry.operator.api.v1.model.ApicurioRegistryStatusManagedResourceBuilder builder = new io.apicurio.registry.operator.api.v1.model.ApicurioRegistryStatusManagedResourceBuilder(item);_visitables.get("managedResources").add(builder);this.managedResources.add(builder);} return (A)this;
    }

    public A removeFromManagedResources(io.apicurio.registry.operator.api.v1.model.ApicurioRegistryStatusManagedResource... items) {
        for (io.apicurio.registry.operator.api.v1.model.ApicurioRegistryStatusManagedResource item : items) {io.apicurio.registry.operator.api.v1.model.ApicurioRegistryStatusManagedResourceBuilder builder = new io.apicurio.registry.operator.api.v1.model.ApicurioRegistryStatusManagedResourceBuilder(item);_visitables.get("managedResources").remove(builder);if (this.managedResources != null) {this.managedResources.remove(builder);}} return (A)this;
    }

    public A removeAllFromManagedResources(java.util.Collection<io.apicurio.registry.operator.api.v1.model.ApicurioRegistryStatusManagedResource> items) {
        for (io.apicurio.registry.operator.api.v1.model.ApicurioRegistryStatusManagedResource item : items) {io.apicurio.registry.operator.api.v1.model.ApicurioRegistryStatusManagedResourceBuilder builder = new io.apicurio.registry.operator.api.v1.model.ApicurioRegistryStatusManagedResourceBuilder(item);_visitables.get("managedResources").remove(builder);if (this.managedResources != null) {this.managedResources.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromManagedResources(java.util.function.Predicate<io.apicurio.registry.operator.api.v1.model.ApicurioRegistryStatusManagedResourceBuilder> predicate) {
        if (managedResources == null) return (A) this;
        final Iterator<io.apicurio.registry.operator.api.v1.model.ApicurioRegistryStatusManagedResourceBuilder> each = managedResources.iterator();
        final List visitables = _visitables.get("managedResources");
        while (each.hasNext()) {
          io.apicurio.registry.operator.api.v1.model.ApicurioRegistryStatusManagedResourceBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildManagedResources instead.
     * @return The buildable object.
     */
        public java.util.List<io.apicurio.registry.operator.api.v1.model.ApicurioRegistryStatusManagedResource> getManagedResources() {
        return build(managedResources);
    }

    public java.util.List<io.apicurio.registry.operator.api.v1.model.ApicurioRegistryStatusManagedResource> buildManagedResources() {
        return build(managedResources);
    }

    public io.apicurio.registry.operator.api.v1.model.ApicurioRegistryStatusManagedResource buildManagedResource(int index) {
        return this.managedResources.get(index).build();
    }

    public io.apicurio.registry.operator.api.v1.model.ApicurioRegistryStatusManagedResource buildFirstManagedResource() {
        return this.managedResources.get(0).build();
    }

    public io.apicurio.registry.operator.api.v1.model.ApicurioRegistryStatusManagedResource buildLastManagedResource() {
        return this.managedResources.get(managedResources.size() - 1).build();
    }

    public io.apicurio.registry.operator.api.v1.model.ApicurioRegistryStatusManagedResource buildMatchingManagedResource(java.util.function.Predicate<io.apicurio.registry.operator.api.v1.model.ApicurioRegistryStatusManagedResourceBuilder> predicate) {
        for (io.apicurio.registry.operator.api.v1.model.ApicurioRegistryStatusManagedResourceBuilder item: managedResources) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public java.lang.Boolean hasMatchingManagedResource(java.util.function.Predicate<io.apicurio.registry.operator.api.v1.model.ApicurioRegistryStatusManagedResourceBuilder> predicate) {
        for (io.apicurio.registry.operator.api.v1.model.ApicurioRegistryStatusManagedResourceBuilder item: managedResources) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withManagedResources(java.util.List<io.apicurio.registry.operator.api.v1.model.ApicurioRegistryStatusManagedResource> managedResources) {
        if (this.managedResources != null) { _visitables.get("managedResources").removeAll(this.managedResources);}
        if (managedResources != null) {this.managedResources = new java.util.ArrayList<io.apicurio.registry.operator.api.v1.model.ApicurioRegistryStatusManagedResourceBuilder>(); for (io.apicurio.registry.operator.api.v1.model.ApicurioRegistryStatusManagedResource item : managedResources){this.addToManagedResources(item);}} else { this.managedResources = null;} return (A) this;
    }

    public A withManagedResources(io.apicurio.registry.operator.api.v1.model.ApicurioRegistryStatusManagedResource... managedResources) {
        if (this.managedResources != null) {this.managedResources.clear();}
        if (managedResources != null) {for (io.apicurio.registry.operator.api.v1.model.ApicurioRegistryStatusManagedResource item :managedResources){ this.addToManagedResources(item);}} return (A) this;
    }

    public java.lang.Boolean hasManagedResources() {
        return managedResources != null && !managedResources.isEmpty();
    }

    public io.apicurio.registry.operator.api.v1.model.ApicurioRegistryStatusFluent.ManagedResourcesNested<A> addNewManagedResource() {
        return new io.apicurio.registry.operator.api.v1.model.ApicurioRegistryStatusFluentImpl.ManagedResourcesNestedImpl();
    }

    public io.apicurio.registry.operator.api.v1.model.ApicurioRegistryStatusFluent.ManagedResourcesNested<A> addNewManagedResourceLike(io.apicurio.registry.operator.api.v1.model.ApicurioRegistryStatusManagedResource item) {
        return new io.apicurio.registry.operator.api.v1.model.ApicurioRegistryStatusFluentImpl.ManagedResourcesNestedImpl(-1, item);
    }

    public io.apicurio.registry.operator.api.v1.model.ApicurioRegistryStatusFluent.ManagedResourcesNested<A> setNewManagedResourceLike(int index,io.apicurio.registry.operator.api.v1.model.ApicurioRegistryStatusManagedResource item) {
        return new io.apicurio.registry.operator.api.v1.model.ApicurioRegistryStatusFluentImpl.ManagedResourcesNestedImpl(index, item);
    }

    public io.apicurio.registry.operator.api.v1.model.ApicurioRegistryStatusFluent.ManagedResourcesNested<A> editManagedResource(int index) {
        if (managedResources.size() <= index) throw new RuntimeException("Can't edit managedResources. Index exceeds size.");
        return setNewManagedResourceLike(index, buildManagedResource(index));
    }

    public io.apicurio.registry.operator.api.v1.model.ApicurioRegistryStatusFluent.ManagedResourcesNested<A> editFirstManagedResource() {
        if (managedResources.size() == 0) throw new RuntimeException("Can't edit first managedResources. The list is empty.");
        return setNewManagedResourceLike(0, buildManagedResource(0));
    }

    public io.apicurio.registry.operator.api.v1.model.ApicurioRegistryStatusFluent.ManagedResourcesNested<A> editLastManagedResource() {
        int index = managedResources.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last managedResources. The list is empty.");
        return setNewManagedResourceLike(index, buildManagedResource(index));
    }

    public io.apicurio.registry.operator.api.v1.model.ApicurioRegistryStatusFluent.ManagedResourcesNested<A> editMatchingManagedResource(java.util.function.Predicate<io.apicurio.registry.operator.api.v1.model.ApicurioRegistryStatusManagedResourceBuilder> predicate) {
        int index = -1;
        for (int i=0;i<managedResources.size();i++) { 
        if (predicate.test(managedResources.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching managedResources. No match found.");
        return setNewManagedResourceLike(index, buildManagedResource(index));
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        ApicurioRegistryStatusFluentImpl that = (ApicurioRegistryStatusFluentImpl) o;
        if (info != null ? !info.equals(that.info) :that.info != null) return false;
        if (conditions != null ? !conditions.equals(that.conditions) :that.conditions != null) return false;
        if (managedResources != null ? !managedResources.equals(that.managedResources) :that.managedResources != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(info,  conditions,  managedResources,  super.hashCode());
    }

    public class InfoNestedImpl<N> extends io.apicurio.registry.operator.api.v1.model.ApicurioRegistryStatusInfoFluentImpl<io.apicurio.registry.operator.api.v1.model.ApicurioRegistryStatusFluent.InfoNested<N>> implements io.apicurio.registry.operator.api.v1.model.ApicurioRegistryStatusFluent.InfoNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.apicurio.registry.operator.api.v1.model.ApicurioRegistryStatusInfoBuilder builder;

            InfoNestedImpl(io.apicurio.registry.operator.api.v1.model.ApicurioRegistryStatusInfo item) {
                this.builder = new io.apicurio.registry.operator.api.v1.model.ApicurioRegistryStatusInfoBuilder(this, item);
                        
            }

            InfoNestedImpl() {
                this.builder = new io.apicurio.registry.operator.api.v1.model.ApicurioRegistryStatusInfoBuilder(this);
                        
            }

            public N and() {
                return (N) ApicurioRegistryStatusFluentImpl.this.withInfo(builder.build());
            }

            public N endInfo() {
                return and();
            }
    }


    public class ManagedResourcesNestedImpl<N> extends io.apicurio.registry.operator.api.v1.model.ApicurioRegistryStatusManagedResourceFluentImpl<io.apicurio.registry.operator.api.v1.model.ApicurioRegistryStatusFluent.ManagedResourcesNested<N>> implements io.apicurio.registry.operator.api.v1.model.ApicurioRegistryStatusFluent.ManagedResourcesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.apicurio.registry.operator.api.v1.model.ApicurioRegistryStatusManagedResourceBuilder builder;
        private final int index;

            ManagedResourcesNestedImpl(int index,io.apicurio.registry.operator.api.v1.model.ApicurioRegistryStatusManagedResource item) {
                this.index = index;
                this.builder = new io.apicurio.registry.operator.api.v1.model.ApicurioRegistryStatusManagedResourceBuilder(this, item);
                        
            }

            ManagedResourcesNestedImpl() {
                this.index = -1;
                this.builder = new io.apicurio.registry.operator.api.v1.model.ApicurioRegistryStatusManagedResourceBuilder(this);
                        
            }

            public N and() {
                return (N) ApicurioRegistryStatusFluentImpl.this.setToManagedResources(index,builder.build());
            }

            public N endManagedResource() {
                return and();
            }
    }


}
