/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.operator.api.v1.model;

import io.apicurio.registry.operator.api.v1.model.ApicurioRegistry;
import io.apicurio.registry.operator.api.v1.model.ApicurioRegistryBuilder;
import io.apicurio.registry.operator.api.v1.model.ApicurioRegistryFluentImpl;
import io.apicurio.registry.operator.api.v1.model.ApicurioRegistryList;
import io.apicurio.registry.operator.api.v1.model.ApicurioRegistryListFluent;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class ApicurioRegistryListFluentImpl<A extends ApicurioRegistryListFluent<A>>
extends BaseFluent<A>
implements ApicurioRegistryListFluent<A> {
    private ListMeta metadata;
    private List<ApicurioRegistryBuilder> items;

    public ApicurioRegistryListFluentImpl() {
    }

    public ApicurioRegistryListFluentImpl(ApicurioRegistryList instance) {
        this.withMetadata(instance.getMetadata());
        this.withItems(instance.getItems());
    }

    @Override
    public ListMeta getMetadata() {
        return this.metadata;
    }

    @Override
    public A withMetadata(ListMeta metadata) {
        this.metadata = metadata;
        return (A)this;
    }

    @Override
    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    @Override
    public A withNewMetadata(String _continue, Long remainingItemCount, String resourceVersion, String selfLink) {
        return this.withMetadata(new ListMeta(_continue, remainingItemCount, resourceVersion, selfLink));
    }

    @Override
    public A addToItems(int index, ApicurioRegistry item) {
        if (this.items == null) {
            this.items = new ArrayList<ApicurioRegistryBuilder>();
        }
        ApicurioRegistryBuilder builder = new ApicurioRegistryBuilder(item);
        this._visitables.get((Object)"items").add(index >= 0 ? index : this._visitables.get((Object)"items").size(), builder);
        this.items.add(index >= 0 ? index : this.items.size(), builder);
        return (A)this;
    }

    @Override
    public A setToItems(int index, ApicurioRegistry item) {
        if (this.items == null) {
            this.items = new ArrayList<ApicurioRegistryBuilder>();
        }
        ApicurioRegistryBuilder builder = new ApicurioRegistryBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"items").size()) {
            this._visitables.get((Object)"items").add(builder);
        } else {
            this._visitables.get((Object)"items").set(index, builder);
        }
        if (index < 0 || index >= this.items.size()) {
            this.items.add(builder);
        } else {
            this.items.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToItems(ApicurioRegistry ... items) {
        if (this.items == null) {
            this.items = new ArrayList<ApicurioRegistryBuilder>();
        }
        for (ApicurioRegistry item : items) {
            ApicurioRegistryBuilder builder = new ApicurioRegistryBuilder(item);
            this._visitables.get((Object)"items").add(builder);
            this.items.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToItems(Collection<ApicurioRegistry> items) {
        if (this.items == null) {
            this.items = new ArrayList<ApicurioRegistryBuilder>();
        }
        for (ApicurioRegistry item : items) {
            ApicurioRegistryBuilder builder = new ApicurioRegistryBuilder(item);
            this._visitables.get((Object)"items").add(builder);
            this.items.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromItems(ApicurioRegistry ... items) {
        for (ApicurioRegistry item : items) {
            ApicurioRegistryBuilder builder = new ApicurioRegistryBuilder(item);
            this._visitables.get((Object)"items").remove(builder);
            if (this.items == null) continue;
            this.items.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromItems(Collection<ApicurioRegistry> items) {
        for (ApicurioRegistry item : items) {
            ApicurioRegistryBuilder builder = new ApicurioRegistryBuilder(item);
            this._visitables.get((Object)"items").remove(builder);
            if (this.items == null) continue;
            this.items.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromItems(Predicate<ApicurioRegistryBuilder> predicate) {
        if (this.items == null) {
            return (A)this;
        }
        Iterator<ApicurioRegistryBuilder> each = this.items.iterator();
        List visitables = this._visitables.get((Object)"items");
        while (each.hasNext()) {
            ApicurioRegistryBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<ApicurioRegistry> getItems() {
        return ApicurioRegistryListFluentImpl.build(this.items);
    }

    @Override
    public List<ApicurioRegistry> buildItems() {
        return ApicurioRegistryListFluentImpl.build(this.items);
    }

    @Override
    public ApicurioRegistry buildItem(int index) {
        return this.items.get(index).build();
    }

    @Override
    public ApicurioRegistry buildFirstItem() {
        return this.items.get(0).build();
    }

    @Override
    public ApicurioRegistry buildLastItem() {
        return this.items.get(this.items.size() - 1).build();
    }

    @Override
    public ApicurioRegistry buildMatchingItem(Predicate<ApicurioRegistryBuilder> predicate) {
        for (ApicurioRegistryBuilder item : this.items) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingItem(Predicate<ApicurioRegistryBuilder> predicate) {
        for (ApicurioRegistryBuilder item : this.items) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withItems(List<ApicurioRegistry> items) {
        if (this.items != null) {
            this._visitables.get((Object)"items").removeAll(this.items);
        }
        if (items != null) {
            this.items = new ArrayList<ApicurioRegistryBuilder>();
            for (ApicurioRegistry item : items) {
                this.addToItems(item);
            }
        } else {
            this.items = null;
        }
        return (A)this;
    }

    @Override
    public A withItems(ApicurioRegistry ... items) {
        if (this.items != null) {
            this.items.clear();
        }
        if (items != null) {
            for (ApicurioRegistry item : items) {
                this.addToItems(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasItems() {
        return this.items != null && !this.items.isEmpty();
    }

    @Override
    public ApicurioRegistryListFluent.ItemsNested<A> addNewItem() {
        return new ItemsNestedImpl();
    }

    @Override
    public ApicurioRegistryListFluent.ItemsNested<A> addNewItemLike(ApicurioRegistry item) {
        return new ItemsNestedImpl(-1, item);
    }

    @Override
    public ApicurioRegistryListFluent.ItemsNested<A> setNewItemLike(int index, ApicurioRegistry item) {
        return new ItemsNestedImpl(index, item);
    }

    @Override
    public ApicurioRegistryListFluent.ItemsNested<A> editItem(int index) {
        if (this.items.size() <= index) {
            throw new RuntimeException("Can't edit items. Index exceeds size.");
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    @Override
    public ApicurioRegistryListFluent.ItemsNested<A> editFirstItem() {
        if (this.items.size() == 0) {
            throw new RuntimeException("Can't edit first items. The list is empty.");
        }
        return this.setNewItemLike(0, this.buildItem(0));
    }

    @Override
    public ApicurioRegistryListFluent.ItemsNested<A> editLastItem() {
        int index = this.items.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last items. The list is empty.");
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    @Override
    public ApicurioRegistryListFluent.ItemsNested<A> editMatchingItem(Predicate<ApicurioRegistryBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.items.size(); ++i) {
            if (!predicate.test(this.items.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching items. No match found.");
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApicurioRegistryListFluentImpl that = (ApicurioRegistryListFluentImpl)o;
        if (this.metadata != null ? !this.metadata.equals((Object)that.metadata) : that.metadata != null) {
            return false;
        }
        return !(this.items != null ? !this.items.equals(that.items) : that.items != null);
    }

    public int hashCode() {
        return Objects.hash(this.metadata, this.items, super.hashCode());
    }

    public class ItemsNestedImpl<N>
    extends ApicurioRegistryFluentImpl<ApicurioRegistryListFluent.ItemsNested<N>>
    implements ApicurioRegistryListFluent.ItemsNested<N>,
    Nested<N> {
        private final ApicurioRegistryBuilder builder;
        private final int index;

        ItemsNestedImpl(int index, ApicurioRegistry item) {
            this.index = index;
            this.builder = new ApicurioRegistryBuilder(this, item);
        }

        ItemsNestedImpl() {
            this.index = -1;
            this.builder = new ApicurioRegistryBuilder(this);
        }

        @Override
        public N and() {
            return (N)ApicurioRegistryListFluentImpl.this.setToItems(this.index, this.builder.build());
        }

        @Override
        public N endItem() {
            return this.and();
        }
    }
}

