/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.client.service;

import io.apicurio.registry.rest.beans.ArtifactMetaData;
import io.apicurio.registry.rest.beans.EditableMetaData;
import io.apicurio.registry.rest.beans.IfExistsType;
import io.apicurio.registry.rest.beans.Rule;
import io.apicurio.registry.rest.beans.UpdateState;
import io.apicurio.registry.rest.beans.VersionMetaData;
import io.apicurio.registry.types.ArtifactType;
import io.apicurio.registry.types.RuleType;
import java.util.List;
import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import retrofit2.Call;
import retrofit2.http.Body;
import retrofit2.http.DELETE;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.POST;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;

public interface ArtifactsService {
    @GET(value="artifacts")
    public Call<List<String>> listArtifacts();

    @POST(value="artifacts")
    public Call<ArtifactMetaData> createArtifact(@Header(value="X-Registry-ArtifactType") ArtifactType var1, @Header(value="X-Registry-Artifactid") String var2, @Query(value="ifExists") IfExistsType var3, @Body RequestBody var4);

    @GET(value="artifacts/{artifactId}")
    public Call<ResponseBody> getLatestArtifact(@Path(value="artifactId") String var1);

    @PUT(value="artifacts/{artifactId}")
    public Call<ArtifactMetaData> updateArtifact(@Path(value="artifactId") String var1, @Header(value="X-Registry-ArtifactType") ArtifactType var2, @Body RequestBody var3);

    @DELETE(value="artifacts/{artifactId}")
    public Call<Void> deleteArtifact(@Path(value="artifactId") String var1);

    @PUT(value="artifacts/{artifactId}/state")
    public Call<Void> updateArtifactState(@Path(value="artifactId") String var1, @Body UpdateState var2);

    @GET(value="artifacts/{artifactId}/meta")
    public Call<ArtifactMetaData> getArtifactMetaData(@Path(value="artifactId") String var1);

    @PUT(value="artifacts/{artifactId}/meta")
    public Call<Void> updateArtifactMetaData(@Path(value="artifactId") String var1, @Body EditableMetaData var2);

    @POST(value="artifacts/{artifactId}/meta")
    public Call<ArtifactMetaData> getArtifactMetaDataByContent(@Path(value="artifactId") String var1, @Body RequestBody var2);

    @GET(value="artifacts/{artifactId}/versions")
    public Call<List<Long>> listArtifactVersions(@Path(value="artifactId") String var1);

    @POST(value="artifacts/{artifactId}/versions")
    public Call<VersionMetaData> createArtifactVersion(@Path(value="artifactId") String var1, @Header(value="X-Registry-ArtifactType") ArtifactType var2, @Body RequestBody var3);

    @GET(value="artifacts/{artifactId}/versions/{version}")
    public Call<ResponseBody> getArtifactVersion(@Path(value="version") Integer var1, @Path(value="artifactId") String var2);

    @PUT(value="artifacts/{artifactId}/versions/{version}/state")
    public Call<Void> updateArtifactVersionState(@Path(value="version") Integer var1, @Path(value="artifactId") String var2, @Body UpdateState var3);

    @GET(value="artifacts/{artifactId}/versions/{version}/meta")
    public Call<VersionMetaData> getArtifactVersionMetaData(@Path(value="version") Integer var1, @Path(value="artifactId") String var2);

    @PUT(value="artifacts/{artifactId}/versions/{version}/meta")
    public Call<Void> updateArtifactVersionMetaData(@Path(value="version") Integer var1, @Path(value="artifactId") String var2, @Body EditableMetaData var3);

    @DELETE(value="artifacts/{artifactId}/versions/{version}/meta")
    public Call<Void> deleteArtifactVersionMetaData(@Path(value="version") Integer var1, @Path(value="artifactId") String var2);

    @GET(value="artifacts/{artifactId}/rules")
    public Call<List<RuleType>> listArtifactRules(@Path(value="artifactId") String var1);

    @POST(value="artifacts/{artifactId}/rules")
    public Call<Void> createArtifactRule(@Path(value="artifactId") String var1, @Body Rule var2);

    @DELETE(value="artifacts/{artifactId}/rules")
    public Call<Void> deleteArtifactRules(@Path(value="artifactId") String var1);

    @GET(value="artifacts/{artifactId}/rules/{rule}")
    public Call<Rule> getArtifactRuleConfig(@Path(value="rule") RuleType var1, @Path(value="artifactId") String var2);

    @PUT(value="artifacts/{artifactId}/rules/{rule}")
    public Call<Rule> updateArtifactRuleConfig(@Path(value="rule") RuleType var1, @Path(value="artifactId") String var2, @Body Rule var3);

    @DELETE(value="artifacts/{artifactId}/rules/{rule}")
    public Call<Void> deleteArtifactRule(@Path(value="rule") RuleType var1, @Path(value="artifactId") String var2);

    @PUT(value="artifacts/{artifactId}/test")
    public Call<Void> testUpdateArtifact(@Path(value="artifactId") String var1, @Header(value="X-Registry-ArtifactType") ArtifactType var2, @Body RequestBody var3);
}

