/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.rules.compatibility.jsonschema.diff;

import io.apicurio.registry.rules.compatibility.jsonschema.JsonSchemaWrapperVisitor;
import io.apicurio.registry.rules.compatibility.jsonschema.diff.DiffContext;
import io.apicurio.registry.rules.compatibility.jsonschema.diff.DiffType;
import io.apicurio.registry.rules.compatibility.jsonschema.diff.DiffUtil;
import io.apicurio.registry.rules.compatibility.jsonschema.diff.SchemaDiffVisitor;
import io.apicurio.registry.rules.compatibility.jsonschema.wrapper.ObjectSchemaWrapper;
import io.apicurio.registry.rules.compatibility.jsonschema.wrapper.SchemaWrapper;
import io.apicurio.registry.rules.compatibility.jsonschema.wrapper.WrapUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.everit.json.schema.ObjectSchema;
import org.everit.json.schema.Schema;

public class ObjectSchemaDiffVisitor
extends JsonSchemaWrapperVisitor {
    private final DiffContext ctx;
    private final ObjectSchema original;
    private ObjectSchemaWrapper schema;

    public ObjectSchemaDiffVisitor(DiffContext ctx, ObjectSchema original) {
        this.ctx = ctx;
        this.original = original;
    }

    @Override
    public void visitObjectSchema(ObjectSchemaWrapper objectSchema) {
        this.ctx.log("Visiting " + objectSchema + " at " + objectSchema.getWrapped().getLocation());
        this.schema = objectSchema;
        super.visitObjectSchema(objectSchema);
    }

    @Override
    public void visitRequiredPropertyName(String requiredPropName) {
        super.visitRequiredPropertyName(requiredPropName);
    }

    @Override
    public void visitRequiredProperties(List<String> requiredProperties) {
        DiffUtil.diffSetChanged(this.ctx.sub("required"), new HashSet(this.original.getRequiredProperties()), new HashSet<String>(requiredProperties), DiffType.OBJECT_TYPE_REQUIRED_PROPERTIES_ADDED, DiffType.OBJECT_TYPE_REQUIRED_PROPERTIES_REMOVED, DiffType.OBJECT_TYPE_REQUIRED_PROPERTIES_CHANGED, DiffType.OBJECT_TYPE_REQUIRED_PROPERTIES_MEMBER_ADDED, DiffType.OBJECT_TYPE_REQUIRED_PROPERTIES_MEMBER_REMOVED);
        super.visitRequiredProperties(requiredProperties);
    }

    @Override
    public void visitPropertyNameSchema(SchemaWrapper propertyNameSchema) {
        DiffContext subCtx = this.ctx.sub("properties");
        if (DiffUtil.diffSubschemaAddedRemoved(subCtx, this.original.getPropertyNameSchema(), propertyNameSchema, DiffType.OBJECT_TYPE_PROPERTY_SCHEMA_ADDED, DiffType.OBJECT_TYPE_PROPERTY_SCHEMA_REMOVED)) {
            propertyNameSchema.accept(new SchemaDiffVisitor(subCtx, this.original.getPropertyNameSchema()));
        }
        super.visitPropertyNameSchema(propertyNameSchema);
    }

    @Override
    public void visitMinProperties(Integer minProperties) {
        DiffUtil.diffInteger(this.ctx.sub("minProperties"), this.original.getMinProperties(), minProperties, DiffType.OBJECT_TYPE_MIN_PROPERTIES_ADDED, DiffType.OBJECT_TYPE_MIN_PROPERTIES_REMOVED, DiffType.OBJECT_TYPE_MIN_PROPERTIES_INCREASED, DiffType.OBJECT_TYPE_MIN_PROPERTIES_DECREASED);
        super.visitMinProperties(minProperties);
    }

    @Override
    public void visitMaxProperties(Integer maxProperties) {
        DiffUtil.diffInteger(this.ctx.sub("maxProperties"), this.original.getMaxProperties(), maxProperties, DiffType.OBJECT_TYPE_MAX_PROPERTIES_ADDED, DiffType.OBJECT_TYPE_MAX_PROPERTIES_REMOVED, DiffType.OBJECT_TYPE_MAX_PROPERTIES_INCREASED, DiffType.OBJECT_TYPE_MAX_PROPERTIES_DECREASED);
        super.visitMaxProperties(maxProperties);
    }

    @Override
    public void visitAllPropertyDependencies(Map<String, Set<String>> propertyDependencies) {
        DiffUtil.diffSetChanged(this.ctx.sub("dependencies"), new HashSet(this.original.getPropertyDependencies().keySet()), new HashSet<String>(propertyDependencies.keySet()), DiffType.OBJECT_TYPE_PROPERTY_DEPENDENCIES_KEYS_ADDED, DiffType.OBJECT_TYPE_PROPERTY_DEPENDENCIES_KEYS_REMOVED, DiffType.OBJECT_TYPE_PROPERTY_DEPENDENCIES_KEYS_CHANGED, DiffType.OBJECT_TYPE_PROPERTY_DEPENDENCIES_KEYS_MEMBER_ADDED, DiffType.OBJECT_TYPE_PROPERTY_DEPENDENCIES_KEYS_MEMBER_REMOVED);
        super.visitAllPropertyDependencies(propertyDependencies);
    }

    @Override
    public void visitPropertyDependencies(String ifPresent, Set<String> allMustBePresent) {
        if (this.original.getPropertyDependencies().containsKey(ifPresent)) {
            DiffUtil.diffSetChanged(this.ctx.sub("dependencies/" + ifPresent), (Set)this.original.getPropertyDependencies().get(ifPresent), allMustBePresent, DiffType.UNDEFINED_UNUSED, DiffType.UNDEFINED_UNUSED, DiffType.OBJECT_TYPE_PROPERTY_DEPENDENCIES_VALUE_MEMBER_CHANGED, DiffType.OBJECT_TYPE_PROPERTY_DEPENDENCIES_VALUE_MEMBER_ADDED, DiffType.OBJECT_TYPE_PROPERTY_DEPENDENCIES_VALUE_MEMBER_REMOVED);
        }
        super.visitPropertyDependencies(ifPresent, allMustBePresent);
    }

    @Override
    public void visitAdditionalProperties(boolean permitsAdditionalProperties) {
        if (DiffUtil.diffBooleanTransition(this.ctx.sub("additionalProperties"), this.original.permitsAdditionalProperties(), permitsAdditionalProperties, true, DiffType.OBJECT_TYPE_ADDITIONAL_PROPERTIES_FALSE_TO_TRUE, DiffType.OBJECT_TYPE_ADDITIONAL_PROPERTIES_TRUE_TO_FALSE, DiffType.OBJECT_TYPE_ADDITIONAL_PROPERTIES_BOOLEAN_UNCHANGED) && permitsAdditionalProperties) {
            Schema updatedAdditionalProperties = this.schema.getSchemaOfAdditionalProperties() == null ? null : this.schema.getSchemaOfAdditionalProperties().getWrapped();
            DiffUtil.diffSchemaOrTrue(this.ctx.sub("schemaOfAdditionalItems"), this.original.getSchemaOfAdditionalProperties(), updatedAdditionalProperties, DiffType.OBJECT_TYPE_ADDITIONAL_PROPERTIES_SCHEMA_UNCHANGED, DiffType.OBJECT_TYPE_ADDITIONAL_PROPERTIES_EXTENDED, DiffType.OBJECT_TYPE_ADDITIONAL_PROPERTIES_NARROWED, DiffType.OBJECT_TYPE_ADDITIONAL_PROPERTIES_SCHEMA_CHANGED);
        }
        super.visitAdditionalProperties(permitsAdditionalProperties);
    }

    @Override
    public void visitSchemaOfAdditionalProperties(SchemaWrapper schemaOfAdditionalProperties) {
        super.visitSchemaOfAdditionalProperties(schemaOfAdditionalProperties);
    }

    @Override
    public void visitPatternProperties(Map<Pattern, SchemaWrapper> patternProperties) {
        DiffUtil.diffSetChanged(this.ctx.sub("patternProperties"), this.original.getPatternProperties().keySet().stream().map(Pattern::toString).collect(Collectors.toSet()), patternProperties.keySet().stream().map(Pattern::toString).collect(Collectors.toSet()), DiffType.OBJECT_TYPE_PATTERN_PROPERTY_KEYS_ADDED, DiffType.OBJECT_TYPE_PATTERN_PROPERTY_KEYS_REMOVED, DiffType.OBJECT_TYPE_PATTERN_PROPERTY_KEYS_CHANGED, DiffType.OBJECT_TYPE_PATTERN_PROPERTY_KEYS_MEMBER_ADDED, DiffType.OBJECT_TYPE_PATTERN_PROPERTY_KEYS_MEMBER_REMOVED);
        super.visitPatternProperties(patternProperties);
    }

    @Override
    public void visitPatternPropertySchema(Pattern propertyNamePattern, SchemaWrapper schema) {
        Map<String, Schema> stringifiedOriginal = this.original.getPatternProperties().entrySet().stream().collect(Collectors.toMap(e -> ((Pattern)e.getKey()).toString(), Map.Entry::getValue));
        if (stringifiedOriginal.containsKey(propertyNamePattern.toString())) {
            schema.accept(new SchemaDiffVisitor(this.ctx.sub("patternProperties/" + propertyNamePattern), stringifiedOriginal.get(propertyNamePattern.toString())));
        }
        super.visitPatternPropertySchema(propertyNamePattern, schema);
    }

    @Override
    public void visitSchemaDependencies(Map<String, SchemaWrapper> schemaDependencies) {
        DiffUtil.diffSetChanged(this.ctx.sub("dependencies"), new HashSet(this.original.getSchemaDependencies().keySet()), new HashSet<String>(schemaDependencies.keySet()), DiffType.OBJECT_TYPE_SCHEMA_DEPENDENCIES_ADDED, DiffType.OBJECT_TYPE_SCHEMA_DEPENDENCIES_REMOVED, DiffType.OBJECT_TYPE_SCHEMA_DEPENDENCIES_CHANGED, DiffType.OBJECT_TYPE_SCHEMA_DEPENDENCIES_MEMBER_ADDED, DiffType.OBJECT_TYPE_SCHEMA_DEPENDENCIES_MEMBER_REMOVED);
        super.visitSchemaDependencies(schemaDependencies);
    }

    @Override
    public void visitSchemaDependency(String propName, SchemaWrapper schema) {
        if (this.original.getSchemaDependencies().containsKey(propName)) {
            schema.accept(new SchemaDiffVisitor(this.ctx.sub("dependencies/" + propName), (Schema)this.original.getSchemaDependencies().get(propName)));
        }
        super.visitSchemaDependency(propName, schema);
    }

    @Override
    public void visitPropertySchemas(Map<String, SchemaWrapper> propertySchemas) {
        HashSet<String> allPropertySchemaNames = new HashSet<String>(){
            {
                this.addAll(ObjectSchemaDiffVisitor.this.original.getPropertySchemas().keySet());
                this.addAll(ObjectSchemaDiffVisitor.this.schema.getPropertySchemas().keySet());
            }
        };
        ArrayList<SchemaWrapper> addedPropertySchemas = new ArrayList<SchemaWrapper>();
        ArrayList<SchemaWrapper> removedPropertySchemas = new ArrayList<SchemaWrapper>();
        for (String propertySchemaName : allPropertySchemaNames) {
            boolean existInOriginal = this.original.getPropertySchemas().containsKey(propertySchemaName);
            boolean existInUpdated = propertySchemas.containsKey(propertySchemaName);
            if (!existInOriginal && existInUpdated) {
                addedPropertySchemas.add(propertySchemas.get(propertySchemaName));
                continue;
            }
            if (existInOriginal && !existInUpdated) {
                removedPropertySchemas.add(WrapUtil.wrap((Schema)this.original.getPropertySchemas().get(propertySchemaName)));
                continue;
            }
            if (!existInOriginal || !existInUpdated) continue;
            this.visitPropertySchema(propertySchemaName, propertySchemas.get(propertySchemaName));
        }
        if (!addedPropertySchemas.isEmpty()) {
            DiffUtil.diffSubSchemasAdded(this.ctx.sub("propertySchemasAdded"), addedPropertySchemas, this.original.permitsAdditionalProperties(), WrapUtil.wrap(this.original.getSchemaOfAdditionalProperties()), this.schema.permitsAdditionalProperties(), DiffType.OBJECT_TYPE_PROPERTY_SCHEMAS_EXTENDED, DiffType.OBJECT_TYPE_PROPERTY_SCHEMAS_NARROWED, DiffType.OBJECT_TYPE_PROPERTY_SCHEMAS_CHANGED);
        }
        if (!removedPropertySchemas.isEmpty()) {
            DiffUtil.diffSubSchemasRemoved(this.ctx.sub("propertySchemasRemoved"), removedPropertySchemas, this.schema.permitsAdditionalProperties(), this.schema.getSchemaOfAdditionalProperties(), this.original.permitsAdditionalProperties(), DiffType.OBJECT_TYPE_PROPERTY_SCHEMAS_NARROWED, DiffType.OBJECT_TYPE_PROPERTY_SCHEMAS_EXTENDED, DiffType.OBJECT_TYPE_PROPERTY_SCHEMAS_CHANGED);
        }
        super.visitPropertySchemas(propertySchemas);
    }

    @Override
    public void visitPropertySchema(String propertyName, SchemaWrapper schema) {
        if (this.original.getPropertySchemas().containsKey(propertyName)) {
            schema.accept(new SchemaDiffVisitor(this.ctx.sub("properties/" + propertyName), (Schema)this.original.getPropertySchemas().get(propertyName)));
        }
        super.visitPropertySchema(propertyName, schema);
    }
}

