/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.rules.compatibility.protobuf;

import com.squareup.wire.schema.internal.parser.EnumConstantElement;
import com.squareup.wire.schema.internal.parser.FieldElement;
import io.apicurio.registry.protobuf.ProtobufDifference;
import io.apicurio.registry.utils.protobuf.schema.ProtobufFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class ProtobufCompatibilityCheckerLibrary {
    private final ProtobufFile fileBefore;
    private final ProtobufFile fileAfter;

    public ProtobufCompatibilityCheckerLibrary(ProtobufFile fileBefore, ProtobufFile fileAfter) {
        this.fileBefore = fileBefore;
        this.fileAfter = fileAfter;
    }

    public boolean validate() {
        return this.findDifferences().isEmpty();
    }

    public List<ProtobufDifference> findDifferences() {
        ArrayList<ProtobufDifference> totalIssues = new ArrayList<ProtobufDifference>();
        totalIssues.addAll(this.checkNoUsingReservedFields());
        totalIssues.addAll(this.checkNoRemovingReservedFields());
        totalIssues.addAll(this.checkNoRemovingFieldsWithoutReserve());
        totalIssues.addAll(this.checkNoChangingFieldIDs());
        totalIssues.addAll(this.checkNoChangingFieldTypes());
        totalIssues.addAll(this.checkNoChangingFieldNames());
        totalIssues.addAll(this.checkNoRemovingServiceRPCs());
        totalIssues.addAll(this.checkNoChangingRPCSignature());
        return totalIssues;
    }

    public List<ProtobufDifference> checkNoUsingReservedFields() {
        ArrayList<ProtobufDifference> issues = new ArrayList<ProtobufDifference>();
        Map reservedFields = this.fileBefore.getReservedFields();
        Map nonReservedFields = this.fileAfter.getNonReservedFields();
        for (Map.Entry entry : nonReservedFields.entrySet()) {
            Set old = (Set)reservedFields.get(entry.getKey());
            if (old == null) continue;
            HashSet intersection = new HashSet((Collection)entry.getValue());
            intersection.retainAll(old);
            if (intersection.isEmpty()) continue;
            issues.add(ProtobufDifference.from(String.format("Conflict of reserved %d fields, message %s", intersection.size(), entry.getKey())));
        }
        return issues;
    }

    public List<ProtobufDifference> checkNoRemovingReservedFields() {
        ArrayList<ProtobufDifference> issues = new ArrayList<ProtobufDifference>();
        Map before = this.fileBefore.getReservedFields();
        Map after = this.fileAfter.getReservedFields();
        for (Map.Entry entry : before.entrySet()) {
            Set afterKeys = (Set)after.get(entry.getKey());
            if (afterKeys != null) {
                HashSet intersection = new HashSet((Collection)entry.getValue());
                intersection.retainAll(afterKeys);
                int diff = ((Set)entry.getValue()).size() - intersection.size();
                if (diff == 0) continue;
                issues.add(ProtobufDifference.from(String.format("%d reserved fields were removed, message %s", diff, entry.getKey())));
                continue;
            }
            issues.add(ProtobufDifference.from(String.format("%d reserved fields were removed, message %s", ((Set)entry.getValue()).size(), entry.getKey())));
        }
        return issues;
    }

    public List<ProtobufDifference> checkNoRemovingFieldsWithoutReserve() {
        ArrayList<ProtobufDifference> issues = new ArrayList<ProtobufDifference>();
        Map before = this.fileBefore.getFieldMap();
        Map after = this.fileAfter.getFieldMap();
        Map afterReservedFields = this.fileAfter.getReservedFields();
        Map afterNonreservedFields = this.fileAfter.getNonReservedFields();
        for (Map.Entry entry : before.entrySet()) {
            HashSet removedFieldNames = new HashSet(((Map)entry.getValue()).keySet());
            Map updated = (Map)after.get(entry.getKey());
            if (updated != null) {
                removedFieldNames.removeAll(updated.keySet());
            }
            int issuesCount = 0;
            Set reserved = afterReservedFields.getOrDefault(entry.getKey(), Collections.emptySet());
            Set nonreserved = afterNonreservedFields.getOrDefault(entry.getKey(), Collections.emptySet());
            HashSet nonReservedRemovedFieldNames = new HashSet(removedFieldNames);
            nonReservedRemovedFieldNames.removeAll(reserved);
            issuesCount += nonReservedRemovedFieldNames.size();
            for (FieldElement fieldElement : ((Map)entry.getValue()).values()) {
                if (!removedFieldNames.contains(fieldElement.getName()) || reserved.contains(fieldElement.getTag()) || nonreserved.contains(fieldElement.getTag())) continue;
                ++issuesCount;
            }
            if (issuesCount <= 0) continue;
            issues.add(ProtobufDifference.from(String.format("%d fields removed without reservation, message %s", issuesCount, entry.getKey())));
        }
        return issues;
    }

    public List<ProtobufDifference> checkNoChangingFieldIDs() {
        ArrayList<ProtobufDifference> issues = new ArrayList<ProtobufDifference>();
        Map before = this.fileBefore.getFieldMap();
        Map after = this.fileAfter.getFieldMap();
        for (Map.Entry entry : before.entrySet()) {
            Map afterMap = (Map)after.get(entry.getKey());
            if (afterMap == null) continue;
            for (Map.Entry beforeKV : ((Map)entry.getValue()).entrySet()) {
                FieldElement afterFE = (FieldElement)afterMap.get(beforeKV.getKey());
                if (afterFE == null || ((FieldElement)beforeKV.getValue()).getTag() == afterFE.getTag()) continue;
                issues.add(ProtobufDifference.from(String.format("Conflict, field id changed, message %s , before: %s , after %s", entry.getKey(), ((FieldElement)beforeKV.getValue()).getTag(), afterFE.getTag())));
            }
        }
        Map beforeEnum = this.fileBefore.getEnumFieldMap();
        Map afterEnum = this.fileAfter.getEnumFieldMap();
        for (Map.Entry entry : beforeEnum.entrySet()) {
            Map afterMap = (Map)afterEnum.get(entry.getKey());
            if (afterMap == null) continue;
            for (Map.Entry beforeKV : ((Map)entry.getValue()).entrySet()) {
                EnumConstantElement afterECE = (EnumConstantElement)afterMap.get(beforeKV.getKey());
                if (afterECE == null || ((EnumConstantElement)beforeKV.getValue()).getTag() == afterECE.getTag()) continue;
                issues.add(ProtobufDifference.from(String.format("Conflict, field id changed, message %s , before: %s , after %s", entry.getKey(), ((EnumConstantElement)beforeKV.getValue()).getTag(), afterECE.getTag())));
            }
        }
        return issues;
    }

    public List<ProtobufDifference> checkNoChangingFieldTypes() {
        ArrayList<ProtobufDifference> issues = new ArrayList<ProtobufDifference>();
        Map before = this.fileBefore.getFieldMap();
        Map after = this.fileAfter.getFieldMap();
        for (Map.Entry entry : before.entrySet()) {
            Map afterMap = (Map)after.get(entry.getKey());
            if (afterMap == null) continue;
            for (Map.Entry beforeKV : ((Map)entry.getValue()).entrySet()) {
                FieldElement afterFE = (FieldElement)afterMap.get(beforeKV.getKey());
                String beforeType = this.normalizeType(this.fileBefore, ((FieldElement)beforeKV.getValue()).getType());
                String afterType = this.normalizeType(this.fileAfter, afterFE.getType());
                if (afterFE != null && !beforeType.equals(afterType)) {
                    issues.add(ProtobufDifference.from(String.format("Field type changed, message %s , before: %s , after %s", entry.getKey(), ((FieldElement)beforeKV.getValue()).getType(), afterFE.getType())));
                }
                if (afterFE == null || Objects.equals(((FieldElement)beforeKV.getValue()).getLabel(), afterFE.getLabel())) continue;
                issues.add(ProtobufDifference.from(String.format("Field label changed, message %s , before: %s , after %s", entry.getKey(), ((FieldElement)beforeKV.getValue()).getLabel(), afterFE.getLabel())));
            }
        }
        return issues;
    }

    private String normalizeType(ProtobufFile file, String type) {
        if (type != null && type.startsWith(".")) {
            String nodot = type.substring(1);
            if (file.getPackageName() != null && nodot.startsWith(file.getPackageName())) {
                return nodot.substring(file.getPackageName().length() + 1);
            }
            return nodot;
        }
        return type;
    }

    public List<ProtobufDifference> checkNoChangingFieldNames() {
        ArrayList<ProtobufDifference> issues = new ArrayList<ProtobufDifference>();
        HashMap before = new HashMap(this.fileBefore.getFieldsById());
        before.putAll(this.fileBefore.getEnumFieldsById());
        HashMap after = new HashMap(this.fileAfter.getFieldsById());
        after.putAll(this.fileAfter.getEnumFieldsById());
        for (Map.Entry entry : before.entrySet()) {
            Map afterMap = (Map)after.get(entry.getKey());
            if (afterMap == null) continue;
            for (Map.Entry beforeKV : ((Map)entry.getValue()).entrySet()) {
                String nameAfter = (String)afterMap.get(beforeKV.getKey());
                if (((String)beforeKV.getValue()).equals(nameAfter)) continue;
                issues.add(ProtobufDifference.from(String.format("Field name changed, message %s , before: %s , after %s", entry.getKey(), beforeKV.getValue(), nameAfter)));
            }
        }
        return issues;
    }

    public List<ProtobufDifference> checkNoRemovingServiceRPCs() {
        ArrayList<ProtobufDifference> issues = new ArrayList<ProtobufDifference>();
        Map before = this.fileBefore.getServiceRPCnames();
        Map after = this.fileAfter.getServiceRPCnames();
        for (Map.Entry entry : before.entrySet()) {
            Set afterSet = (Set)after.get(entry.getKey());
            HashSet diff = new HashSet((Collection)entry.getValue());
            if (afterSet != null) {
                diff.removeAll(afterSet);
            }
            if (diff.size() <= 0) continue;
            issues.add(ProtobufDifference.from(String.format("%d rpc services removed, message %s", diff.size(), entry.getKey())));
        }
        return issues;
    }

    public List<ProtobufDifference> checkNoChangingRPCSignature() {
        ArrayList<ProtobufDifference> issues = new ArrayList<ProtobufDifference>();
        Map before = this.fileBefore.getServiceRPCSignatures();
        Map after = this.fileAfter.getServiceRPCSignatures();
        for (Map.Entry entry : before.entrySet()) {
            Map afterMap = (Map)after.get(entry.getKey());
            if (afterMap == null) continue;
            for (Map.Entry beforeKV : ((Map)entry.getValue()).entrySet()) {
                String afterSig = (String)afterMap.get(beforeKV.getKey());
                if (((String)beforeKV.getValue()).equals(afterSig)) continue;
                issues.add(ProtobufDifference.from(String.format("rpc service signature changed, message %s , before %s , after %s", entry.getKey(), beforeKV.getValue(), afterSig)));
            }
        }
        return issues;
    }
}

