/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.resolver;

import io.apicurio.registry.resolver.ERCache;
import io.apicurio.registry.resolver.ParsedSchema;
import io.apicurio.registry.resolver.ParsedSchemaImpl;
import io.apicurio.registry.resolver.SchemaLookupResult;
import io.apicurio.registry.resolver.SchemaParser;
import io.apicurio.registry.resolver.SchemaResolver;
import io.apicurio.registry.resolver.config.DefaultSchemaResolverConfig;
import io.apicurio.registry.resolver.data.Record;
import io.apicurio.registry.resolver.strategy.ArtifactReference;
import io.apicurio.registry.resolver.strategy.ArtifactReferenceResolverStrategy;
import io.apicurio.registry.resolver.utils.Utils;
import io.apicurio.registry.rest.client.RegistryClient;
import io.apicurio.registry.rest.client.RegistryClientFactory;
import io.apicurio.registry.rest.v2.beans.ArtifactMetaData;
import io.apicurio.registry.rest.v2.beans.VersionMetaData;
import io.apicurio.registry.utils.IoUtil;
import io.apicurio.rest.client.auth.Auth;
import io.apicurio.rest.client.auth.BasicAuth;
import io.apicurio.rest.client.auth.OidcAuth;
import io.apicurio.rest.client.auth.exception.AuthErrorHandler;
import io.apicurio.rest.client.error.RestClientErrorHandler;
import io.apicurio.rest.client.spi.ApicurioHttpClient;
import io.apicurio.rest.client.spi.ApicurioHttpClientFactory;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public abstract class AbstractSchemaResolver<S, T>
implements SchemaResolver<S, T> {
    protected final ERCache<SchemaLookupResult<S>> schemaCache = new ERCache();
    protected DefaultSchemaResolverConfig config;
    protected SchemaParser<S, T> schemaParser;
    protected RegistryClient client;
    protected ApicurioHttpClient authClient;
    protected ArtifactReferenceResolverStrategy<S, T> artifactResolverStrategy;
    protected String explicitArtifactGroupId;
    protected String explicitArtifactId;
    protected String explicitArtifactVersion;

    @Override
    public void configure(Map<String, ?> configs, SchemaParser<S, T> schemaParser) {
        String artifactVersionOverride;
        String artifactIdOverride;
        this.schemaParser = schemaParser;
        this.config = new DefaultSchemaResolverConfig(configs);
        if (this.client == null) {
            String baseUrl = this.config.getRegistryUrl();
            if (baseUrl == null) {
                throw new IllegalArgumentException("Missing registry base url, set apicurio.registry.url");
            }
            String authServerURL = this.config.getAuthServiceUrl();
            String tokenEndpoint = this.config.getTokenEndpoint();
            try {
                String username;
                this.client = authServerURL != null || tokenEndpoint != null ? this.configureClientWithBearerAuthentication(this.config, baseUrl, authServerURL, tokenEndpoint) : ((username = this.config.getAuthUsername()) != null ? this.configureClientWithBasicAuth(this.config, baseUrl, username) : RegistryClientFactory.create((String)baseUrl, this.config.originals()));
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
        Object ais = this.config.getArtifactResolverStrategy();
        Utils.instantiate(ArtifactReferenceResolverStrategy.class, ais, this::setArtifactResolverStrategy);
        this.schemaCache.configureLifetime(this.config.getCheckPeriod());
        this.schemaCache.configureRetryBackoff(this.config.getRetryBackoff());
        this.schemaCache.configureRetryCount(this.config.getRetryCount());
        this.schemaCache.configureGlobalIdKeyExtractor(SchemaLookupResult::getGlobalId);
        this.schemaCache.configureContentKeyExtractor(schema -> Optional.ofNullable(schema.getParsedSchema().getRawSchema()).map(IoUtil::toString).orElse(null));
        this.schemaCache.configureContentIdKeyExtractor(SchemaLookupResult::getContentId);
        this.schemaCache.configureArtifactCoordinatesKeyExtractor(SchemaLookupResult::toArtifactCoordinates);
        this.schemaCache.checkInitialized();
        String groupIdOverride = this.config.getExplicitArtifactGroupId();
        if (groupIdOverride != null) {
            this.explicitArtifactGroupId = groupIdOverride;
        }
        if ((artifactIdOverride = this.config.getExplicitArtifactId()) != null) {
            this.explicitArtifactId = artifactIdOverride;
        }
        if ((artifactVersionOverride = this.config.getExplicitArtifactVersion()) != null) {
            this.explicitArtifactVersion = artifactVersionOverride;
        }
    }

    @Override
    public void setClient(RegistryClient client) {
        this.client = client;
    }

    @Override
    public void setArtifactResolverStrategy(ArtifactReferenceResolverStrategy<S, T> artifactResolverStrategy) {
        this.artifactResolverStrategy = artifactResolverStrategy;
    }

    @Override
    public SchemaParser<S, T> getSchemaParser() {
        return this.schemaParser;
    }

    protected ArtifactReference resolveArtifactReference(Record<T> data, ParsedSchema<S> parsedSchema, boolean isReference, String referenceArtifactId) {
        ArtifactReference artifactReference = this.artifactResolverStrategy.artifactReference(data, parsedSchema);
        artifactReference = ArtifactReference.builder().groupId(this.explicitArtifactGroupId == null ? artifactReference.getGroupId() : this.explicitArtifactGroupId).artifactId(this.resolveArtifactId(artifactReference.getArtifactId(), isReference, referenceArtifactId)).version(this.explicitArtifactVersion == null ? artifactReference.getVersion() : this.explicitArtifactVersion).build();
        return artifactReference;
    }

    protected String resolveArtifactId(String artifactId, boolean isReference, String referenceArtifactId) {
        if (isReference) {
            return referenceArtifactId;
        }
        return this.explicitArtifactId == null ? artifactId : this.explicitArtifactId;
    }

    protected SchemaLookupResult<S> resolveSchemaByGlobalId(long globalId) {
        return this.schemaCache.getByGlobalId(globalId, globalIdKey -> {
            InputStream rawSchema = this.client.getContentByGlobalId(globalIdKey.longValue(), Boolean.valueOf(false), Boolean.valueOf(true));
            List artifactReferences = this.client.getArtifactReferencesByGlobalId(globalId);
            Map<String, ParsedSchema<S>> resolvedReferences = this.resolveReferences(artifactReferences);
            byte[] schema = IoUtil.toBytes((InputStream)rawSchema);
            S parsed = this.schemaParser.parseSchema(schema, resolvedReferences);
            ParsedSchemaImpl ps = new ParsedSchemaImpl<S>().setParsedSchema(parsed).setSchemaReferences(new ArrayList(resolvedReferences.values())).setRawSchema(schema);
            SchemaLookupResult.SchemaLookupResultBuilder result = SchemaLookupResult.builder();
            return result.globalId((long)globalIdKey).parsedSchema(ps).build();
        });
    }

    protected Map<String, ParsedSchema<S>> resolveReferences(List<io.apicurio.registry.rest.v2.beans.ArtifactReference> artifactReferences) {
        HashMap<String, ParsedSchema<S>> resolvedReferences = new HashMap<String, ParsedSchema<S>>();
        artifactReferences.forEach(reference -> {
            InputStream referenceContent = this.client.getArtifactVersion(reference.getGroupId(), reference.getArtifactId(), reference.getVersion());
            List referenceReferences = this.client.getArtifactReferencesByCoordinates(reference.getGroupId(), reference.getArtifactId(), reference.getVersion());
            if (!referenceReferences.isEmpty()) {
                Map<String, ParsedSchema<S>> nestedReferences = this.resolveReferences(referenceReferences);
                resolvedReferences.putAll(nestedReferences);
                resolvedReferences.put(reference.getName(), this.parseSchemaFromStream(reference.getName(), referenceContent, this.resolveReferences(referenceReferences)));
            } else {
                resolvedReferences.put(reference.getName(), this.parseSchemaFromStream(reference.getName(), referenceContent, Collections.emptyMap()));
            }
        });
        return resolvedReferences;
    }

    private ParsedSchema<S> parseSchemaFromStream(String name, InputStream rawSchema, Map<String, ParsedSchema<S>> resolvedReferences) {
        byte[] schema = IoUtil.toBytes((InputStream)rawSchema);
        S parsed = this.schemaParser.parseSchema(schema, resolvedReferences);
        return new ParsedSchemaImpl<S>().setParsedSchema(parsed).setSchemaReferences(new ArrayList(resolvedReferences.values())).setReferenceName(name).setRawSchema(schema);
    }

    @Override
    public void reset() {
        this.schemaCache.clear();
    }

    @Override
    public void close() throws IOException {
        if (this.client != null) {
            this.client.close();
        }
        if (this.authClient != null) {
            this.authClient.close();
        }
    }

    private RegistryClient configureClientWithBearerAuthentication(DefaultSchemaResolverConfig config, String registryUrl, String authServerUrl, String tokenEndpoint) {
        OidcAuth auth = authServerUrl != null ? this.configureAuthWithRealm(config, authServerUrl) : this.configureAuthWithUrl(config, tokenEndpoint);
        return RegistryClientFactory.create((String)registryUrl, config.originals(), (Auth)auth);
    }

    private OidcAuth configureAuthWithRealm(DefaultSchemaResolverConfig config, String authServerUrl) {
        String realm = config.getAuthRealm();
        if (realm == null) {
            throw new IllegalArgumentException("Missing registry auth realm, set apicurio.auth.realm");
        }
        String tokenEndpoint = authServerUrl + String.format("/realms/%s/protocol/openid-connect/token", realm);
        return this.configureAuthWithUrl(config, tokenEndpoint);
    }

    private OidcAuth configureAuthWithUrl(DefaultSchemaResolverConfig config, String tokenEndpoint) {
        String clientId = config.getAuthClientId();
        if (clientId == null) {
            throw new IllegalArgumentException("Missing registry auth clientId, set apicurio.auth.client.id");
        }
        String clientSecret = config.getAuthClientSecret();
        if (clientSecret == null) {
            throw new IllegalArgumentException("Missing registry auth secret, set apicurio.auth.client.secret");
        }
        this.authClient = ApicurioHttpClientFactory.create((String)tokenEndpoint, (RestClientErrorHandler)new AuthErrorHandler());
        return new OidcAuth(this.authClient, clientId, clientSecret);
    }

    private RegistryClient configureClientWithBasicAuth(DefaultSchemaResolverConfig config, String registryUrl, String username) {
        String password = config.getAuthPassword();
        if (password == null) {
            throw new IllegalArgumentException("Missing registry auth password, set apicurio.auth.password");
        }
        BasicAuth auth = new BasicAuth(username, password);
        return RegistryClientFactory.create((String)registryUrl, config.originals(), (Auth)auth);
    }

    protected void loadFromArtifactMetaData(ArtifactMetaData artifactMetadata, SchemaLookupResult.SchemaLookupResultBuilder<S> resultBuilder) {
        resultBuilder.globalId(artifactMetadata.getGlobalId());
        resultBuilder.contentId(artifactMetadata.getContentId());
        resultBuilder.groupId(artifactMetadata.getGroupId());
        resultBuilder.artifactId(artifactMetadata.getId());
        resultBuilder.version(String.valueOf(artifactMetadata.getVersion()));
    }

    protected void loadFromArtifactMetaData(VersionMetaData artifactMetadata, SchemaLookupResult.SchemaLookupResultBuilder<S> resultBuilder) {
        resultBuilder.globalId(artifactMetadata.getGlobalId());
        resultBuilder.contentId(artifactMetadata.getContentId());
        resultBuilder.groupId(artifactMetadata.getGroupId());
        resultBuilder.artifactId(artifactMetadata.getId());
        resultBuilder.version(String.valueOf(artifactMetadata.getVersion()));
    }
}

