/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.resolver;

import io.apicurio.registry.resolver.strategy.ArtifactCoordinates;
import io.apicurio.registry.rest.client.exception.RateLimitedClientException;
import java.time.Duration;
import java.time.Instant;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Supplier;

public class ERCache<V> {
    private final Map<Long, WrappedValue<V>> index1 = new ConcurrentHashMap<Long, WrappedValue<V>>();
    private final Map<String, WrappedValue<V>> index2 = new ConcurrentHashMap<String, WrappedValue<V>>();
    private final Map<Long, WrappedValue<V>> index3 = new ConcurrentHashMap<Long, WrappedValue<V>>();
    private final Map<ArtifactCoordinates, WrappedValue<V>> index4 = new ConcurrentHashMap<ArtifactCoordinates, WrappedValue<V>>();
    private Function<V, Long> keyExtractor1;
    private Function<V, String> keyExtractor2;
    private Function<V, Long> keyExtractor3;
    private Function<V, ArtifactCoordinates> keyExtractor4;
    private Duration lifetime = Duration.ZERO;
    private Duration backoff = Duration.ofMillis(200L);
    private long retries;

    public void configureLifetime(Duration lifetime) {
        this.lifetime = lifetime;
    }

    public void configureRetryBackoff(Duration backoff) {
        this.backoff = backoff;
    }

    public void configureRetryCount(long retries) {
        this.retries = retries;
    }

    public void configureGlobalIdKeyExtractor(Function<V, Long> keyExtractor) {
        this.keyExtractor1 = keyExtractor;
    }

    public void configureContentKeyExtractor(Function<V, String> keyExtractor) {
        this.keyExtractor2 = keyExtractor;
    }

    public void configureContentIdKeyExtractor(Function<V, Long> keyExtractor) {
        this.keyExtractor3 = keyExtractor;
    }

    public void configureArtifactCoordinatesKeyExtractor(Function<V, ArtifactCoordinates> keyExtractor) {
        this.keyExtractor4 = keyExtractor;
    }

    public void checkInitialized() {
        boolean initialized = this.keyExtractor1 != null && this.keyExtractor2 != null && this.keyExtractor3 != null && this.keyExtractor4 != null;
        boolean bl = initialized = initialized && this.lifetime != null && this.backoff != null && this.retries >= 0L;
        if (!initialized) {
            throw new IllegalStateException("Not properly initialized!");
        }
    }

    public boolean containsByGlobalId(Long key) {
        WrappedValue<V> value = this.index1.get(key);
        return value != null && !value.isExpired();
    }

    public boolean containsByContentId(Long key) {
        WrappedValue<V> value = this.index3.get(key);
        return value != null && !value.isExpired();
    }

    public boolean containsByArtifactCoordinates(ArtifactCoordinates key) {
        WrappedValue<V> value = this.index4.get(key);
        return value != null && !value.isExpired();
    }

    public V getByGlobalId(Long key, Function<Long, V> loaderFunction) {
        WrappedValue<V> value = this.index1.get(key);
        return this.getValue(value, key, loaderFunction);
    }

    public V getByContent(String key, Function<String, V> loaderFunction) {
        WrappedValue<V> value = this.index2.get(key);
        return this.getValue(value, key, loaderFunction);
    }

    public V getByContentId(Long key, Function<Long, V> loaderFunction) {
        WrappedValue<V> value = this.index3.get(key);
        return this.getValue(value, key, loaderFunction);
    }

    public V getByArtifactCoordinates(ArtifactCoordinates key, Function<ArtifactCoordinates, V> loaderFunction) {
        WrappedValue<V> value = this.index4.get(key);
        return this.getValue(value, key, loaderFunction);
    }

    private <T> V getValue(WrappedValue<V> value, T key, Function<T, V> loaderFunction) {
        V result;
        V v = result = value != null ? (V)value.value : null;
        if (value == null || value.isExpired()) {
            Result<Object, RuntimeException> newValue = ERCache.retry(this.backoff, this.retries, () -> loaderFunction.apply(key));
            if (newValue.isOk()) {
                this.reindex(new WrappedValue(this.lifetime, Instant.now(), newValue.ok));
                result = (V)newValue.ok;
            } else {
                throw (RuntimeException)newValue.error;
            }
        }
        return result;
    }

    private void reindex(WrappedValue<V> newValue) {
        Optional.ofNullable(this.keyExtractor1.apply(newValue.value)).ifPresent(k -> this.index1.put((Long)k, (WrappedValue<WrappedValue>)newValue));
        Optional.ofNullable(this.keyExtractor2.apply(newValue.value)).ifPresent(k -> this.index2.put((String)k, (WrappedValue<WrappedValue>)newValue));
        Optional.ofNullable(this.keyExtractor3.apply(newValue.value)).ifPresent(k -> this.index3.put((Long)k, (WrappedValue<WrappedValue>)newValue));
        Optional.ofNullable(this.keyExtractor4.apply(newValue.value)).ifPresent(k -> this.index4.put((ArtifactCoordinates)k, (WrappedValue<WrappedValue>)newValue));
    }

    public void clear() {
        this.index1.clear();
        this.index2.clear();
        this.index3.clear();
        this.index4.clear();
    }

    private static <T> Result<T, RuntimeException> retry(Duration backoff, long retries, Supplier<T> supplier) {
        if (retries < 0L) {
            throw new IllegalArgumentException();
        }
        Objects.requireNonNull(supplier);
        Objects.requireNonNull(backoff);
        for (long i = 0L; i <= retries; ++i) {
            try {
                T value = supplier.get();
                if (value != null) {
                    return Result.ok(value);
                }
                return Result.error(new NullPointerException("Could not retrieve schema for the cache. Loading function returned null."));
            }
            catch (RuntimeException e) {
                if (i == retries || !(e instanceof RateLimitedClientException)) {
                    return Result.error(e);
                }
                try {
                    Thread.sleep(backoff.toMillis());
                }
                catch (InterruptedException e2) {
                    e2.printStackTrace();
                }
                continue;
            }
        }
        return Result.error(new IllegalStateException("Unreachable."));
    }

    public static class Result<T, E extends Exception> {
        public final T ok;
        public final E error;

        public static <T, E extends Exception> Result<T, E> ok(T ok) {
            Objects.requireNonNull(ok);
            return new Result<T, Object>(ok, null);
        }

        public static <T, E extends Exception> Result<T, E> error(E error) {
            Objects.requireNonNull(error);
            return new Result<Object, E>(null, error);
        }

        private Result(T ok, E error) {
            this.ok = ok;
            this.error = error;
        }

        public boolean isOk() {
            return this.ok != null;
        }

        public boolean isError() {
            return this.error != null;
        }
    }

    private static class WrappedValue<V> {
        private final Duration lifetime;
        private final Instant lastUpdate;
        private final V value;

        public WrappedValue(Duration lifetime, Instant lastUpdate, V value) {
            this.lifetime = lifetime;
            this.lastUpdate = lastUpdate;
            this.value = value;
        }

        public V getValue() {
            return this.value;
        }

        public boolean isExpired() {
            return this.lastUpdate.plus(this.lifetime).isBefore(Instant.now());
        }
    }
}

